/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SharedAccess {
    EXTERNAL("EXTERNAL"),
    INTERNAL("INTERNAL"),
    NOT_SHARED("NOT_SHARED"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SharedAccess> VALUE_MAP;
    private final String value;

    private SharedAccess(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SharedAccess fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SharedAccess> knownValues() {
        EnumSet<SharedAccess> knownValues = EnumSet.allOf(SharedAccess.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SharedAccess.class, SharedAccess::toString);
    }
}

