/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.SeverityLevel;
import software.amazon.awssdk.services.macie2.model.SeverityLevelListCopier;
import software.amazon.awssdk.services.macie2.model.TagMapCopier;
import software.amazon.awssdk.services.macie2.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCustomDataIdentifierResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, GetCustomDataIdentifierResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetCustomDataIdentifierResponse.getter(GetCustomDataIdentifierResponse::arn)).setter(GetCustomDataIdentifierResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetCustomDataIdentifierResponse.getter(GetCustomDataIdentifierResponse::createdAt)).setter(GetCustomDataIdentifierResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deleted").getter(GetCustomDataIdentifierResponse.getter(GetCustomDataIdentifierResponse::deleted)).setter(GetCustomDataIdentifierResponse.setter(Builder::deleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleted").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetCustomDataIdentifierResponse.getter(GetCustomDataIdentifierResponse::description)).setter(GetCustomDataIdentifierResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetCustomDataIdentifierResponse.getter(GetCustomDataIdentifierResponse::id)).setter(GetCustomDataIdentifierResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<String>> IGNORE_WORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ignoreWords").getter(GetCustomDataIdentifierResponse.getter(GetCustomDataIdentifierResponse::ignoreWords)).setter(GetCustomDataIdentifierResponse.setter(Builder::ignoreWords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreWords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("keywords").getter(GetCustomDataIdentifierResponse.getter(GetCustomDataIdentifierResponse::keywords)).setter(GetCustomDataIdentifierResponse.setter(Builder::keywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAXIMUM_MATCH_DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumMatchDistance").getter(GetCustomDataIdentifierResponse.getter(GetCustomDataIdentifierResponse::maximumMatchDistance)).setter(GetCustomDataIdentifierResponse.setter(Builder::maximumMatchDistance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMatchDistance").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetCustomDataIdentifierResponse.getter(GetCustomDataIdentifierResponse::name)).setter(GetCustomDataIdentifierResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REGEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regex").getter(GetCustomDataIdentifierResponse.getter(GetCustomDataIdentifierResponse::regex)).setter(GetCustomDataIdentifierResponse.setter(Builder::regex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regex").build()}).build();
    private static final SdkField<List<SeverityLevel>> SEVERITY_LEVELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("severityLevels").getter(GetCustomDataIdentifierResponse.getter(GetCustomDataIdentifierResponse::severityLevels)).setter(GetCustomDataIdentifierResponse.setter(Builder::severityLevels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityLevels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SeverityLevel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetCustomDataIdentifierResponse.getter(GetCustomDataIdentifierResponse::tags)).setter(GetCustomDataIdentifierResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, DELETED_FIELD, DESCRIPTION_FIELD, ID_FIELD, IGNORE_WORDS_FIELD, KEYWORDS_FIELD, MAXIMUM_MATCH_DISTANCE_FIELD, NAME_FIELD, REGEX_FIELD, SEVERITY_LEVELS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCustomDataIdentifierResponse.memberNameToFieldInitializer();
    private final String arn;
    private final Instant createdAt;
    private final Boolean deleted;
    private final String description;
    private final String id;
    private final List<String> ignoreWords;
    private final List<String> keywords;
    private final Integer maximumMatchDistance;
    private final String name;
    private final String regex;
    private final List<SeverityLevel> severityLevels;
    private final Map<String, String> tags;

    private GetCustomDataIdentifierResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.deleted = builder.deleted;
        this.description = builder.description;
        this.id = builder.id;
        this.ignoreWords = builder.ignoreWords;
        this.keywords = builder.keywords;
        this.maximumMatchDistance = builder.maximumMatchDistance;
        this.name = builder.name;
        this.regex = builder.regex;
        this.severityLevels = builder.severityLevels;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Boolean deleted() {
        return this.deleted;
    }

    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasIgnoreWords() {
        return this.ignoreWords != null && !(this.ignoreWords instanceof SdkAutoConstructList);
    }

    public final List<String> ignoreWords() {
        return this.ignoreWords;
    }

    public final boolean hasKeywords() {
        return this.keywords != null && !(this.keywords instanceof SdkAutoConstructList);
    }

    public final List<String> keywords() {
        return this.keywords;
    }

    public final Integer maximumMatchDistance() {
        return this.maximumMatchDistance;
    }

    public final String name() {
        return this.name;
    }

    public final String regex() {
        return this.regex;
    }

    public final boolean hasSeverityLevels() {
        return this.severityLevels != null && !(this.severityLevels instanceof SdkAutoConstructList);
    }

    public final List<SeverityLevel> severityLevels() {
        return this.severityLevels;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIgnoreWords() ? this.ignoreWords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeywords() ? this.keywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumMatchDistance());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.regex());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSeverityLevels() ? this.severityLevels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCustomDataIdentifierResponse)) {
            return false;
        }
        GetCustomDataIdentifierResponse other = (GetCustomDataIdentifierResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deleted(), other.deleted()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && this.hasIgnoreWords() == other.hasIgnoreWords() && Objects.equals(this.ignoreWords(), other.ignoreWords()) && this.hasKeywords() == other.hasKeywords() && Objects.equals(this.keywords(), other.keywords()) && Objects.equals(this.maximumMatchDistance(), other.maximumMatchDistance()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.regex(), other.regex()) && this.hasSeverityLevels() == other.hasSeverityLevels() && Objects.equals(this.severityLevels(), other.severityLevels()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetCustomDataIdentifierResponse").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Deleted", (Object)this.deleted()).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("IgnoreWords", this.hasIgnoreWords() ? this.ignoreWords() : null).add("Keywords", this.hasKeywords() ? this.keywords() : null).add("MaximumMatchDistance", (Object)this.maximumMatchDistance()).add("Name", (Object)this.name()).add("Regex", (Object)this.regex()).add("SeverityLevels", this.hasSeverityLevels() ? this.severityLevels() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "deleted": {
                return Optional.ofNullable(clazz.cast(this.deleted()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ignoreWords": {
                return Optional.ofNullable(clazz.cast(this.ignoreWords()));
            }
            case "keywords": {
                return Optional.ofNullable(clazz.cast(this.keywords()));
            }
            case "maximumMatchDistance": {
                return Optional.ofNullable(clazz.cast(this.maximumMatchDistance()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "regex": {
                return Optional.ofNullable(clazz.cast(this.regex()));
            }
            case "severityLevels": {
                return Optional.ofNullable(clazz.cast(this.severityLevels()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("deleted", DELETED_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("id", ID_FIELD);
        map.put("ignoreWords", IGNORE_WORDS_FIELD);
        map.put("keywords", KEYWORDS_FIELD);
        map.put("maximumMatchDistance", MAXIMUM_MATCH_DISTANCE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("regex", REGEX_FIELD);
        map.put("severityLevels", SEVERITY_LEVELS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCustomDataIdentifierResponse, T> g) {
        return obj -> g.apply((GetCustomDataIdentifierResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private Boolean deleted;
        private String description;
        private String id;
        private List<String> ignoreWords = DefaultSdkAutoConstructList.getInstance();
        private List<String> keywords = DefaultSdkAutoConstructList.getInstance();
        private Integer maximumMatchDistance;
        private String name;
        private String regex;
        private List<SeverityLevel> severityLevels = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCustomDataIdentifierResponse model) {
            super(model);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.deleted(model.deleted);
            this.description(model.description);
            this.id(model.id);
            this.ignoreWords(model.ignoreWords);
            this.keywords(model.keywords);
            this.maximumMatchDistance(model.maximumMatchDistance);
            this.name(model.name);
            this.regex(model.regex);
            this.severityLevels(model.severityLevels);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getDeleted() {
            return this.deleted;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<String> getIgnoreWords() {
            if (this.ignoreWords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ignoreWords;
        }

        public final void setIgnoreWords(Collection<String> ignoreWords) {
            this.ignoreWords = ___listOf__stringCopier.copy(ignoreWords);
        }

        @Override
        public final Builder ignoreWords(Collection<String> ignoreWords) {
            this.ignoreWords = ___listOf__stringCopier.copy(ignoreWords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ignoreWords(String ... ignoreWords) {
            this.ignoreWords(Arrays.asList(ignoreWords));
            return this;
        }

        public final Collection<String> getKeywords() {
            if (this.keywords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keywords;
        }

        public final void setKeywords(Collection<String> keywords) {
            this.keywords = ___listOf__stringCopier.copy(keywords);
        }

        @Override
        public final Builder keywords(Collection<String> keywords) {
            this.keywords = ___listOf__stringCopier.copy(keywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keywords(String ... keywords) {
            this.keywords(Arrays.asList(keywords));
            return this;
        }

        public final Integer getMaximumMatchDistance() {
            return this.maximumMatchDistance;
        }

        public final void setMaximumMatchDistance(Integer maximumMatchDistance) {
            this.maximumMatchDistance = maximumMatchDistance;
        }

        @Override
        public final Builder maximumMatchDistance(Integer maximumMatchDistance) {
            this.maximumMatchDistance = maximumMatchDistance;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRegex() {
            return this.regex;
        }

        public final void setRegex(String regex) {
            this.regex = regex;
        }

        @Override
        public final Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public final List<SeverityLevel.Builder> getSeverityLevels() {
            List<SeverityLevel.Builder> result = SeverityLevelListCopier.copyToBuilder(this.severityLevels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSeverityLevels(Collection<SeverityLevel.BuilderImpl> severityLevels) {
            this.severityLevels = SeverityLevelListCopier.copyFromBuilder(severityLevels);
        }

        @Override
        public final Builder severityLevels(Collection<SeverityLevel> severityLevels) {
            this.severityLevels = SeverityLevelListCopier.copy(severityLevels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLevels(SeverityLevel ... severityLevels) {
            this.severityLevels(Arrays.asList(severityLevels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLevels(Consumer<SeverityLevel.Builder> ... severityLevels) {
            this.severityLevels(Stream.of(severityLevels).map(c -> (SeverityLevel)((SeverityLevel.Builder)SeverityLevel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetCustomDataIdentifierResponse build() {
            return new GetCustomDataIdentifierResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCustomDataIdentifierResponse> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder deleted(Boolean var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder ignoreWords(Collection<String> var1);

        public Builder ignoreWords(String ... var1);

        public Builder keywords(Collection<String> var1);

        public Builder keywords(String ... var1);

        public Builder maximumMatchDistance(Integer var1);

        public Builder name(String var1);

        public Builder regex(String var1);

        public Builder severityLevels(Collection<SeverityLevel> var1);

        public Builder severityLevels(SeverityLevel ... var1);

        public Builder severityLevels(Consumer<SeverityLevel.Builder> ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

