/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.services.macie2.model.S3ClassificationScopeUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateClassificationScopeRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, UpdateClassificationScopeRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateClassificationScopeRequest.getter(UpdateClassificationScopeRequest::id)).setter(UpdateClassificationScopeRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<S3ClassificationScopeUpdate> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3").getter(UpdateClassificationScopeRequest.getter(UpdateClassificationScopeRequest::s3)).setter(UpdateClassificationScopeRequest.setter(Builder::s3)).constructor(S3ClassificationScopeUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, S3_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("s3", S3_FIELD);
        }
    });
    private final String id;
    private final S3ClassificationScopeUpdate s3;

    private UpdateClassificationScopeRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.s3 = builder.s3;
    }

    public final String id() {
        return this.id;
    }

    public final S3ClassificationScopeUpdate s3() {
        return this.s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClassificationScopeRequest)) {
            return false;
        }
        UpdateClassificationScopeRequest other = (UpdateClassificationScopeRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.s3(), other.s3());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateClassificationScopeRequest").add("Id", (Object)this.id()).add("S3", (Object)this.s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClassificationScopeRequest, T> g) {
        return obj -> g.apply((UpdateClassificationScopeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private String id;
        private S3ClassificationScopeUpdate s3;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClassificationScopeRequest model) {
            super(model);
            this.id(model.id);
            this.s3(model.s3);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final S3ClassificationScopeUpdate.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3ClassificationScopeUpdate.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3ClassificationScopeUpdate s3) {
            this.s3 = s3;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClassificationScopeRequest build() {
            return new UpdateClassificationScopeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateClassificationScopeRequest> {
        public Builder id(String var1);

        public Builder s3(S3ClassificationScopeUpdate var1);

        default public Builder s3(Consumer<S3ClassificationScopeUpdate.Builder> s3) {
            return this.s3((S3ClassificationScopeUpdate)((S3ClassificationScopeUpdate.Builder)S3ClassificationScopeUpdate.builder().applyMutation(s3)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

