/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2Client;
import software.amazon.awssdk.services.macie2.internal.UserAgentUtils;
import software.amazon.awssdk.services.macie2.model.ListMembersRequest;
import software.amazon.awssdk.services.macie2.model.ListMembersResponse;
import software.amazon.awssdk.services.macie2.model.Member;

public class ListMembersIterable
implements SdkIterable<ListMembersResponse> {
    private final Macie2Client client;
    private final ListMembersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMembersIterable(Macie2Client client, ListMembersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMembersResponseFetcher();
    }

    public Iterator<ListMembersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Member> members() {
        Function<ListMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMembersResponseFetcher
    implements SyncPageFetcher<ListMembersResponse> {
        private ListMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMembersResponse nextPage(ListMembersResponse previousPage) {
            if (previousPage == null) {
                return ListMembersIterable.this.client.listMembers(ListMembersIterable.this.firstRequest);
            }
            return ListMembersIterable.this.client.listMembers((ListMembersRequest)((Object)ListMembersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

