/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2AsyncClient;
import software.amazon.awssdk.services.macie2.internal.UserAgentUtils;
import software.amazon.awssdk.services.macie2.model.JobSummary;
import software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest;
import software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse;

public class ListClassificationJobsPublisher
implements SdkPublisher<ListClassificationJobsResponse> {
    private final Macie2AsyncClient client;
    private final ListClassificationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListClassificationJobsPublisher(Macie2AsyncClient client, ListClassificationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListClassificationJobsPublisher(Macie2AsyncClient client, ListClassificationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListClassificationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListClassificationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobSummary> items() {
        Function<ListClassificationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListClassificationJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListClassificationJobsResponseFetcher
    implements AsyncPageFetcher<ListClassificationJobsResponse> {
        private ListClassificationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListClassificationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListClassificationJobsResponse> nextPage(ListClassificationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListClassificationJobsPublisher.this.client.listClassificationJobs(ListClassificationJobsPublisher.this.firstRequest);
            }
            return ListClassificationJobsPublisher.this.client.listClassificationJobs((ListClassificationJobsRequest)((Object)ListClassificationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

