/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRevealConfigurationRequest extends Macie2Request implements
        ToCopyableBuilder<UpdateRevealConfigurationRequest.Builder, UpdateRevealConfigurationRequest> {
    private static final SdkField<RevealConfiguration> CONFIGURATION_FIELD = SdkField
            .<RevealConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(UpdateRevealConfigurationRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(RevealConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<UpdateRetrievalConfiguration> RETRIEVAL_CONFIGURATION_FIELD = SdkField
            .<UpdateRetrievalConfiguration> builder(MarshallingType.SDK_POJO).memberName("retrievalConfiguration")
            .getter(getter(UpdateRevealConfigurationRequest::retrievalConfiguration))
            .setter(setter(Builder::retrievalConfiguration)).constructor(UpdateRetrievalConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            RETRIEVAL_CONFIGURATION_FIELD));

    private final RevealConfiguration configuration;

    private final UpdateRetrievalConfiguration retrievalConfiguration;

    private UpdateRevealConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
        this.retrievalConfiguration = builder.retrievalConfiguration;
    }

    /**
     * <p>
     * The KMS key to use to encrypt the sensitive data, and the status of the configuration for the Amazon Macie
     * account.
     * </p>
     * 
     * @return The KMS key to use to encrypt the sensitive data, and the status of the configuration for the Amazon
     *         Macie account.
     */
    public final RevealConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The access method and settings to use when retrieving the sensitive data.
     * </p>
     * 
     * @return The access method and settings to use when retrieving the sensitive data.
     */
    public final UpdateRetrievalConfiguration retrievalConfiguration() {
        return retrievalConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(retrievalConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRevealConfigurationRequest)) {
            return false;
        }
        UpdateRevealConfigurationRequest other = (UpdateRevealConfigurationRequest) obj;
        return Objects.equals(configuration(), other.configuration())
                && Objects.equals(retrievalConfiguration(), other.retrievalConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRevealConfigurationRequest").add("Configuration", configuration())
                .add("RetrievalConfiguration", retrievalConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "retrievalConfiguration":
            return Optional.ofNullable(clazz.cast(retrievalConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRevealConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateRevealConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRevealConfigurationRequest> {
        /**
         * <p>
         * The KMS key to use to encrypt the sensitive data, and the status of the configuration for the Amazon Macie
         * account.
         * </p>
         * 
         * @param configuration
         *        The KMS key to use to encrypt the sensitive data, and the status of the configuration for the Amazon
         *        Macie account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(RevealConfiguration configuration);

        /**
         * <p>
         * The KMS key to use to encrypt the sensitive data, and the status of the configuration for the Amazon Macie
         * account.
         * </p>
         * This is a convenience method that creates an instance of the {@link RevealConfiguration.Builder} avoiding the
         * need to create one manually via {@link RevealConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RevealConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(RevealConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link RevealConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(RevealConfiguration)
         */
        default Builder configuration(Consumer<RevealConfiguration.Builder> configuration) {
            return configuration(RevealConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The access method and settings to use when retrieving the sensitive data.
         * </p>
         * 
         * @param retrievalConfiguration
         *        The access method and settings to use when retrieving the sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalConfiguration(UpdateRetrievalConfiguration retrievalConfiguration);

        /**
         * <p>
         * The access method and settings to use when retrieving the sensitive data.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateRetrievalConfiguration.Builder}
         * avoiding the need to create one manually via {@link UpdateRetrievalConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateRetrievalConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #retrievalConfiguration(UpdateRetrievalConfiguration)}.
         * 
         * @param retrievalConfiguration
         *        a consumer that will call methods on {@link UpdateRetrievalConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrievalConfiguration(UpdateRetrievalConfiguration)
         */
        default Builder retrievalConfiguration(Consumer<UpdateRetrievalConfiguration.Builder> retrievalConfiguration) {
            return retrievalConfiguration(UpdateRetrievalConfiguration.builder().applyMutation(retrievalConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private RevealConfiguration configuration;

        private UpdateRetrievalConfiguration retrievalConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRevealConfigurationRequest model) {
            super(model);
            configuration(model.configuration);
            retrievalConfiguration(model.retrievalConfiguration);
        }

        public final RevealConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(RevealConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RevealConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final UpdateRetrievalConfiguration.Builder getRetrievalConfiguration() {
            return retrievalConfiguration != null ? retrievalConfiguration.toBuilder() : null;
        }

        public final void setRetrievalConfiguration(UpdateRetrievalConfiguration.BuilderImpl retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration != null ? retrievalConfiguration.build() : null;
        }

        @Override
        public final Builder retrievalConfiguration(UpdateRetrievalConfiguration retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRevealConfigurationRequest build() {
            return new UpdateRevealConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
