/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCustomDataIdentifierResponse extends Macie2Response implements
        ToCopyableBuilder<GetCustomDataIdentifierResponse.Builder, GetCustomDataIdentifierResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetCustomDataIdentifierResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetCustomDataIdentifierResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Boolean> DELETED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleted").getter(getter(GetCustomDataIdentifierResponse::deleted)).setter(setter(Builder::deleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleted").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetCustomDataIdentifierResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetCustomDataIdentifierResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<List<String>> IGNORE_WORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ignoreWords")
            .getter(getter(GetCustomDataIdentifierResponse::ignoreWords))
            .setter(setter(Builder::ignoreWords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreWords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> KEYWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("keywords")
            .getter(getter(GetCustomDataIdentifierResponse::keywords))
            .setter(setter(Builder::keywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAXIMUM_MATCH_DISTANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumMatchDistance").getter(getter(GetCustomDataIdentifierResponse::maximumMatchDistance))
            .setter(setter(Builder::maximumMatchDistance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMatchDistance").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetCustomDataIdentifierResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("regex")
            .getter(getter(GetCustomDataIdentifierResponse::regex)).setter(setter(Builder::regex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regex").build()).build();

    private static final SdkField<List<SeverityLevel>> SEVERITY_LEVELS_FIELD = SdkField
            .<List<SeverityLevel>> builder(MarshallingType.LIST)
            .memberName("severityLevels")
            .getter(getter(GetCustomDataIdentifierResponse::severityLevels))
            .setter(setter(Builder::severityLevels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityLevels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SeverityLevel> builder(MarshallingType.SDK_POJO)
                                            .constructor(SeverityLevel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetCustomDataIdentifierResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            DELETED_FIELD, DESCRIPTION_FIELD, ID_FIELD, IGNORE_WORDS_FIELD, KEYWORDS_FIELD, MAXIMUM_MATCH_DISTANCE_FIELD,
            NAME_FIELD, REGEX_FIELD, SEVERITY_LEVELS_FIELD, TAGS_FIELD));

    private final String arn;

    private final Instant createdAt;

    private final Boolean deleted;

    private final String description;

    private final String id;

    private final List<String> ignoreWords;

    private final List<String> keywords;

    private final Integer maximumMatchDistance;

    private final String name;

    private final String regex;

    private final List<SeverityLevel> severityLevels;

    private final Map<String, String> tags;

    private GetCustomDataIdentifierResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.deleted = builder.deleted;
        this.description = builder.description;
        this.id = builder.id;
        this.ignoreWords = builder.ignoreWords;
        this.keywords = builder.keywords;
        this.maximumMatchDistance = builder.maximumMatchDistance;
        this.name = builder.name;
        this.regex = builder.regex;
        this.severityLevels = builder.severityLevels;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom data identifier.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom data identifier.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie
     * doesn't delete it permanently. Instead, it soft deletes the identifier.
     * </p>
     * 
     * @return Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon
     *         Macie doesn't delete it permanently. Instead, it soft deletes the identifier.
     */
    public final Boolean deleted() {
        return deleted;
    }

    /**
     * <p>
     * The custom description of the custom data identifier.
     * </p>
     * 
     * @return The custom description of the custom data identifier.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier for the custom data identifier.
     * </p>
     * 
     * @return The unique identifier for the custom data identifier.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the IgnoreWords property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIgnoreWords() {
        return ignoreWords != null && !(ignoreWords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text
     * matched by the regular expression contains any string in this array, Amazon Macie ignores it. Ignore words are
     * case sensitive.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIgnoreWords} method.
     * </p>
     * 
     * @return An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If
     *         the text matched by the regular expression contains any string in this array, Amazon Macie ignores it.
     *         Ignore words are case sensitive.
     */
    public final List<String> ignoreWords() {
        return ignoreWords;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keywords property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeywords() {
        return keywords != null && !(keywords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that lists specific character sequences (<i>keywords</i>), one of which must precede and be within
     * proximity (maximumMatchDistance) of the regular expression to match. Keywords aren't case sensitive.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeywords} method.
     * </p>
     * 
     * @return An array that lists specific character sequences (<i>keywords</i>), one of which must precede and be
     *         within proximity (maximumMatchDistance) of the regular expression to match. Keywords aren't case
     *         sensitive.
     */
    public final List<String> keywords() {
        return keywords;
    }

    /**
     * <p>
     * The maximum number of characters that can exist between the end of at least one complete character sequence
     * specified by the keywords array and the end of the text that matches the regex pattern. If a complete keyword
     * precedes all the text that matches the pattern and the keyword is within the specified distance, Amazon Macie
     * includes the result. Otherwise, Macie excludes the result.
     * </p>
     * 
     * @return The maximum number of characters that can exist between the end of at least one complete character
     *         sequence specified by the keywords array and the end of the text that matches the regex pattern. If a
     *         complete keyword precedes all the text that matches the pattern and the keyword is within the specified
     *         distance, Amazon Macie includes the result. Otherwise, Macie excludes the result.
     */
    public final Integer maximumMatchDistance() {
        return maximumMatchDistance;
    }

    /**
     * <p>
     * The custom name of the custom data identifier.
     * </p>
     * 
     * @return The custom name of the custom data identifier.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The regular expression (<i>regex</i>) that defines the pattern to match.
     * </p>
     * 
     * @return The regular expression (<i>regex</i>) that defines the pattern to match.
     */
    public final String regex() {
        return regex;
    }

    /**
     * For responses, this returns true if the service returned a value for the SeverityLevels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSeverityLevels() {
        return severityLevels != null && !(severityLevels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the severity that's assigned to findings that the custom data identifier produces, based on the number
     * of occurrences of text that match the custom data identifier's detection criteria. By default, Amazon Macie
     * creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria,
     * and Macie assigns the MEDIUM severity to those findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSeverityLevels} method.
     * </p>
     * 
     * @return Specifies the severity that's assigned to findings that the custom data identifier produces, based on the
     *         number of occurrences of text that match the custom data identifier's detection criteria. By default,
     *         Amazon Macie creates findings for S3 objects that contain at least one occurrence of text that matches
     *         the detection criteria, and Macie assigns the MEDIUM severity to those findings.
     */
    public final List<SeverityLevel> severityLevels() {
        return severityLevels;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that identifies the tags (keys and values) that are associated with the custom data
     * identifier.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of key-value pairs that identifies the tags (keys and values) that are associated with the custom
     *         data identifier.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deleted());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasIgnoreWords() ? ignoreWords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKeywords() ? keywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maximumMatchDistance());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(regex());
        hashCode = 31 * hashCode + Objects.hashCode(hasSeverityLevels() ? severityLevels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCustomDataIdentifierResponse)) {
            return false;
        }
        GetCustomDataIdentifierResponse other = (GetCustomDataIdentifierResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(deleted(), other.deleted()) && Objects.equals(description(), other.description())
                && Objects.equals(id(), other.id()) && hasIgnoreWords() == other.hasIgnoreWords()
                && Objects.equals(ignoreWords(), other.ignoreWords()) && hasKeywords() == other.hasKeywords()
                && Objects.equals(keywords(), other.keywords())
                && Objects.equals(maximumMatchDistance(), other.maximumMatchDistance()) && Objects.equals(name(), other.name())
                && Objects.equals(regex(), other.regex()) && hasSeverityLevels() == other.hasSeverityLevels()
                && Objects.equals(severityLevels(), other.severityLevels()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCustomDataIdentifierResponse").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("Deleted", deleted()).add("Description", description()).add("Id", id())
                .add("IgnoreWords", hasIgnoreWords() ? ignoreWords() : null).add("Keywords", hasKeywords() ? keywords() : null)
                .add("MaximumMatchDistance", maximumMatchDistance()).add("Name", name()).add("Regex", regex())
                .add("SeverityLevels", hasSeverityLevels() ? severityLevels() : null).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "deleted":
            return Optional.ofNullable(clazz.cast(deleted()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ignoreWords":
            return Optional.ofNullable(clazz.cast(ignoreWords()));
        case "keywords":
            return Optional.ofNullable(clazz.cast(keywords()));
        case "maximumMatchDistance":
            return Optional.ofNullable(clazz.cast(maximumMatchDistance()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "regex":
            return Optional.ofNullable(clazz.cast(regex()));
        case "severityLevels":
            return Optional.ofNullable(clazz.cast(severityLevels()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCustomDataIdentifierResponse, T> g) {
        return obj -> g.apply((GetCustomDataIdentifierResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetCustomDataIdentifierResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom data identifier.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the custom data identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon
         * Macie doesn't delete it permanently. Instead, it soft deletes the identifier.
         * </p>
         * 
         * @param deleted
         *        Specifies whether the custom data identifier was deleted. If you delete a custom data identifier,
         *        Amazon Macie doesn't delete it permanently. Instead, it soft deletes the identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(Boolean deleted);

        /**
         * <p>
         * The custom description of the custom data identifier.
         * </p>
         * 
         * @param description
         *        The custom description of the custom data identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier for the custom data identifier.
         * </p>
         * 
         * @param id
         *        The unique identifier for the custom data identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the
         * text matched by the regular expression contains any string in this array, Amazon Macie ignores it. Ignore
         * words are case sensitive.
         * </p>
         * 
         * @param ignoreWords
         *        An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If
         *        the text matched by the regular expression contains any string in this array, Amazon Macie ignores it.
         *        Ignore words are case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreWords(Collection<String> ignoreWords);

        /**
         * <p>
         * An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the
         * text matched by the regular expression contains any string in this array, Amazon Macie ignores it. Ignore
         * words are case sensitive.
         * </p>
         * 
         * @param ignoreWords
         *        An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If
         *        the text matched by the regular expression contains any string in this array, Amazon Macie ignores it.
         *        Ignore words are case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreWords(String... ignoreWords);

        /**
         * <p>
         * An array that lists specific character sequences (<i>keywords</i>), one of which must precede and be within
         * proximity (maximumMatchDistance) of the regular expression to match. Keywords aren't case sensitive.
         * </p>
         * 
         * @param keywords
         *        An array that lists specific character sequences (<i>keywords</i>), one of which must precede and be
         *        within proximity (maximumMatchDistance) of the regular expression to match. Keywords aren't case
         *        sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywords(Collection<String> keywords);

        /**
         * <p>
         * An array that lists specific character sequences (<i>keywords</i>), one of which must precede and be within
         * proximity (maximumMatchDistance) of the regular expression to match. Keywords aren't case sensitive.
         * </p>
         * 
         * @param keywords
         *        An array that lists specific character sequences (<i>keywords</i>), one of which must precede and be
         *        within proximity (maximumMatchDistance) of the regular expression to match. Keywords aren't case
         *        sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywords(String... keywords);

        /**
         * <p>
         * The maximum number of characters that can exist between the end of at least one complete character sequence
         * specified by the keywords array and the end of the text that matches the regex pattern. If a complete keyword
         * precedes all the text that matches the pattern and the keyword is within the specified distance, Amazon Macie
         * includes the result. Otherwise, Macie excludes the result.
         * </p>
         * 
         * @param maximumMatchDistance
         *        The maximum number of characters that can exist between the end of at least one complete character
         *        sequence specified by the keywords array and the end of the text that matches the regex pattern. If a
         *        complete keyword precedes all the text that matches the pattern and the keyword is within the
         *        specified distance, Amazon Macie includes the result. Otherwise, Macie excludes the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumMatchDistance(Integer maximumMatchDistance);

        /**
         * <p>
         * The custom name of the custom data identifier.
         * </p>
         * 
         * @param name
         *        The custom name of the custom data identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The regular expression (<i>regex</i>) that defines the pattern to match.
         * </p>
         * 
         * @param regex
         *        The regular expression (<i>regex</i>) that defines the pattern to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regex(String regex);

        /**
         * <p>
         * Specifies the severity that's assigned to findings that the custom data identifier produces, based on the
         * number of occurrences of text that match the custom data identifier's detection criteria. By default, Amazon
         * Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection
         * criteria, and Macie assigns the MEDIUM severity to those findings.
         * </p>
         * 
         * @param severityLevels
         *        Specifies the severity that's assigned to findings that the custom data identifier produces, based on
         *        the number of occurrences of text that match the custom data identifier's detection criteria. By
         *        default, Amazon Macie creates findings for S3 objects that contain at least one occurrence of text
         *        that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityLevels(Collection<SeverityLevel> severityLevels);

        /**
         * <p>
         * Specifies the severity that's assigned to findings that the custom data identifier produces, based on the
         * number of occurrences of text that match the custom data identifier's detection criteria. By default, Amazon
         * Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection
         * criteria, and Macie assigns the MEDIUM severity to those findings.
         * </p>
         * 
         * @param severityLevels
         *        Specifies the severity that's assigned to findings that the custom data identifier produces, based on
         *        the number of occurrences of text that match the custom data identifier's detection criteria. By
         *        default, Amazon Macie creates findings for S3 objects that contain at least one occurrence of text
         *        that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityLevels(SeverityLevel... severityLevels);

        /**
         * <p>
         * Specifies the severity that's assigned to findings that the custom data identifier produces, based on the
         * number of occurrences of text that match the custom data identifier's detection criteria. By default, Amazon
         * Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection
         * criteria, and Macie assigns the MEDIUM severity to those findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.macie2.model.SeverityLevel.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.macie2.model.SeverityLevel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.macie2.model.SeverityLevel.Builder#build()} is called immediately and
         * its result is passed to {@link #severityLevels(List<SeverityLevel>)}.
         * 
         * @param severityLevels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.macie2.model.SeverityLevel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityLevels(java.util.Collection<SeverityLevel>)
         */
        Builder severityLevels(Consumer<SeverityLevel.Builder>... severityLevels);

        /**
         * <p>
         * A map of key-value pairs that identifies the tags (keys and values) that are associated with the custom data
         * identifier.
         * </p>
         * 
         * @param tags
         *        A map of key-value pairs that identifies the tags (keys and values) that are associated with the
         *        custom data identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private Boolean deleted;

        private String description;

        private String id;

        private List<String> ignoreWords = DefaultSdkAutoConstructList.getInstance();

        private List<String> keywords = DefaultSdkAutoConstructList.getInstance();

        private Integer maximumMatchDistance;

        private String name;

        private String regex;

        private List<SeverityLevel> severityLevels = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCustomDataIdentifierResponse model) {
            super(model);
            arn(model.arn);
            createdAt(model.createdAt);
            deleted(model.deleted);
            description(model.description);
            id(model.id);
            ignoreWords(model.ignoreWords);
            keywords(model.keywords);
            maximumMatchDistance(model.maximumMatchDistance);
            name(model.name);
            regex(model.regex);
            severityLevels(model.severityLevels);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getDeleted() {
            return deleted;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<String> getIgnoreWords() {
            if (ignoreWords instanceof SdkAutoConstructList) {
                return null;
            }
            return ignoreWords;
        }

        public final void setIgnoreWords(Collection<String> ignoreWords) {
            this.ignoreWords = ___listOf__stringCopier.copy(ignoreWords);
        }

        @Override
        public final Builder ignoreWords(Collection<String> ignoreWords) {
            this.ignoreWords = ___listOf__stringCopier.copy(ignoreWords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ignoreWords(String... ignoreWords) {
            ignoreWords(Arrays.asList(ignoreWords));
            return this;
        }

        public final Collection<String> getKeywords() {
            if (keywords instanceof SdkAutoConstructList) {
                return null;
            }
            return keywords;
        }

        public final void setKeywords(Collection<String> keywords) {
            this.keywords = ___listOf__stringCopier.copy(keywords);
        }

        @Override
        public final Builder keywords(Collection<String> keywords) {
            this.keywords = ___listOf__stringCopier.copy(keywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keywords(String... keywords) {
            keywords(Arrays.asList(keywords));
            return this;
        }

        public final Integer getMaximumMatchDistance() {
            return maximumMatchDistance;
        }

        public final void setMaximumMatchDistance(Integer maximumMatchDistance) {
            this.maximumMatchDistance = maximumMatchDistance;
        }

        @Override
        public final Builder maximumMatchDistance(Integer maximumMatchDistance) {
            this.maximumMatchDistance = maximumMatchDistance;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRegex() {
            return regex;
        }

        public final void setRegex(String regex) {
            this.regex = regex;
        }

        @Override
        public final Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public final List<SeverityLevel.Builder> getSeverityLevels() {
            List<SeverityLevel.Builder> result = SeverityLevelListCopier.copyToBuilder(this.severityLevels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSeverityLevels(Collection<SeverityLevel.BuilderImpl> severityLevels) {
            this.severityLevels = SeverityLevelListCopier.copyFromBuilder(severityLevels);
        }

        @Override
        public final Builder severityLevels(Collection<SeverityLevel> severityLevels) {
            this.severityLevels = SeverityLevelListCopier.copy(severityLevels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLevels(SeverityLevel... severityLevels) {
            severityLevels(Arrays.asList(severityLevels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLevels(Consumer<SeverityLevel.Builder>... severityLevels) {
            severityLevels(Stream.of(severityLevels).map(c -> SeverityLevel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetCustomDataIdentifierResponse build() {
            return new GetCustomDataIdentifierResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
