/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MacieStatus {
    PAUSED("PAUSED"),
    ENABLED("ENABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MacieStatus> VALUE_MAP;
    private final String value;

    private MacieStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MacieStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MacieStatus> knownValues() {
        EnumSet<MacieStatus> knownValues = EnumSet.allOf(MacieStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MacieStatus.class, MacieStatus::toString);
    }
}

