/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the status of the Amazon Macie configuration for retrieving occurrences of sensitive data reported by
 * findings, and the Key Management Service (KMS) key to use to encrypt sensitive data that's retrieved. When you enable
 * the configuration for the first time, your request must specify an KMS key. Otherwise, an error occurs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevealConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RevealConfiguration.Builder, RevealConfiguration> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(RevealConfiguration::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RevealConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(KMS_KEY_ID_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsKeyId;

    private final String status;

    private RevealConfiguration(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN), ID, or alias of the KMS key to use to encrypt sensitive data that's retrieved.
     * The key must be an existing, customer managed, symmetric encryption key that's enabled in the same Amazon Web
     * Services Region as the Amazon Macie account.
     * </p>
     * <p>
     * If this value specifies an alias, it must include the following prefix: alias/. If this value specifies a key
     * that's owned by another Amazon Web Services account, it must specify the ARN of the key or the ARN of the key's
     * alias.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN), ID, or alias of the KMS key to use to encrypt sensitive data that's
     *         retrieved. The key must be an existing, customer managed, symmetric encryption key that's enabled in the
     *         same Amazon Web Services Region as the Amazon Macie account.</p>
     *         <p>
     *         If this value specifies an alias, it must include the following prefix: alias/. If this value specifies a
     *         key that's owned by another Amazon Web Services account, it must specify the ARN of the key or the ARN of
     *         the key's alias.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The status of the configuration for the Amazon Macie account. In a request, valid values are: ENABLED, enable the
     * configuration for the account; and, DISABLED, disable the configuration for the account. In a response, possible
     * values are: ENABLED, the configuration is currently enabled for the account; and, DISABLED, the configuration is
     * currently disabled for the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RevealStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the configuration for the Amazon Macie account. In a request, valid values are: ENABLED,
     *         enable the configuration for the account; and, DISABLED, disable the configuration for the account. In a
     *         response, possible values are: ENABLED, the configuration is currently enabled for the account; and,
     *         DISABLED, the configuration is currently disabled for the account.
     * @see RevealStatus
     */
    public final RevealStatus status() {
        return RevealStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the configuration for the Amazon Macie account. In a request, valid values are: ENABLED, enable the
     * configuration for the account; and, DISABLED, disable the configuration for the account. In a response, possible
     * values are: ENABLED, the configuration is currently enabled for the account; and, DISABLED, the configuration is
     * currently disabled for the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RevealStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the configuration for the Amazon Macie account. In a request, valid values are: ENABLED,
     *         enable the configuration for the account; and, DISABLED, disable the configuration for the account. In a
     *         response, possible values are: ENABLED, the configuration is currently enabled for the account; and,
     *         DISABLED, the configuration is currently disabled for the account.
     * @see RevealStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevealConfiguration)) {
            return false;
        }
        RevealConfiguration other = (RevealConfiguration) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevealConfiguration").add("KmsKeyId", kmsKeyId()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevealConfiguration, T> g) {
        return obj -> g.apply((RevealConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RevealConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN), ID, or alias of the KMS key to use to encrypt sensitive data that's
         * retrieved. The key must be an existing, customer managed, symmetric encryption key that's enabled in the same
         * Amazon Web Services Region as the Amazon Macie account.
         * </p>
         * <p>
         * If this value specifies an alias, it must include the following prefix: alias/. If this value specifies a key
         * that's owned by another Amazon Web Services account, it must specify the ARN of the key or the ARN of the
         * key's alias.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Resource Name (ARN), ID, or alias of the KMS key to use to encrypt sensitive data that's
         *        retrieved. The key must be an existing, customer managed, symmetric encryption key that's enabled in
         *        the same Amazon Web Services Region as the Amazon Macie account.</p>
         *        <p>
         *        If this value specifies an alias, it must include the following prefix: alias/. If this value
         *        specifies a key that's owned by another Amazon Web Services account, it must specify the ARN of the
         *        key or the ARN of the key's alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The status of the configuration for the Amazon Macie account. In a request, valid values are: ENABLED, enable
         * the configuration for the account; and, DISABLED, disable the configuration for the account. In a response,
         * possible values are: ENABLED, the configuration is currently enabled for the account; and, DISABLED, the
         * configuration is currently disabled for the account.
         * </p>
         * 
         * @param status
         *        The status of the configuration for the Amazon Macie account. In a request, valid values are: ENABLED,
         *        enable the configuration for the account; and, DISABLED, disable the configuration for the account. In
         *        a response, possible values are: ENABLED, the configuration is currently enabled for the account; and,
         *        DISABLED, the configuration is currently disabled for the account.
         * @see RevealStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevealStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the configuration for the Amazon Macie account. In a request, valid values are: ENABLED, enable
         * the configuration for the account; and, DISABLED, disable the configuration for the account. In a response,
         * possible values are: ENABLED, the configuration is currently enabled for the account; and, DISABLED, the
         * configuration is currently disabled for the account.
         * </p>
         * 
         * @param status
         *        The status of the configuration for the Amazon Macie account. In a request, valid values are: ENABLED,
         *        enable the configuration for the account; and, DISABLED, disable the configuration for the account. In
         *        a response, possible values are: ENABLED, the configuration is currently enabled for the account; and,
         *        DISABLED, the configuration is currently disabled for the account.
         * @see RevealStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevealStatus
         */
        Builder status(RevealStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RevealConfiguration model) {
            kmsKeyId(model.kmsKeyId);
            status(model.status);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RevealStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public RevealConfiguration build() {
            return new RevealConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
