/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsageStatisticsRequest extends Macie2Request implements
        ToCopyableBuilder<GetUsageStatisticsRequest.Builder, GetUsageStatisticsRequest> {
    private static final SdkField<List<UsageStatisticsFilter>> FILTER_BY_FIELD = SdkField
            .<List<UsageStatisticsFilter>> builder(MarshallingType.LIST)
            .memberName("filterBy")
            .getter(getter(GetUsageStatisticsRequest::filterBy))
            .setter(setter(Builder::filterBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageStatisticsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageStatisticsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetUsageStatisticsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetUsageStatisticsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<UsageStatisticsSortBy> SORT_BY_FIELD = SdkField
            .<UsageStatisticsSortBy> builder(MarshallingType.SDK_POJO).memberName("sortBy")
            .getter(getter(GetUsageStatisticsRequest::sortBy)).setter(setter(Builder::sortBy))
            .constructor(UsageStatisticsSortBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> TIME_RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeRange").getter(getter(GetUsageStatisticsRequest::timeRangeAsString))
            .setter(setter(Builder::timeRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_BY_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD, TIME_RANGE_FIELD));

    private final List<UsageStatisticsFilter> filterBy;

    private final Integer maxResults;

    private final String nextToken;

    private final UsageStatisticsSortBy sortBy;

    private final String timeRange;

    private GetUsageStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.filterBy = builder.filterBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.timeRange = builder.timeRange;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilterBy() {
        return filterBy != null && !(filterBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each condition to use to filter the query results. If you specify more than one
     * condition, Amazon Macie uses an AND operator to join the conditions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterBy} method.
     * </p>
     * 
     * @return An array of objects, one for each condition to use to filter the query results. If you specify more than
     *         one condition, Amazon Macie uses an AND operator to join the conditions.
     */
    public final List<UsageStatisticsFilter> filterBy() {
        return filterBy;
    }

    /**
     * <p>
     * The maximum number of items to include in each page of the response.
     * </p>
     * 
     * @return The maximum number of items to include in each page of the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The nextToken string that specifies which page of results to return in a paginated response.
     * </p>
     * 
     * @return The nextToken string that specifies which page of results to return in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The criteria to use to sort the query results.
     * </p>
     * 
     * @return The criteria to use to sort the query results.
     */
    public final UsageStatisticsSortBy sortBy() {
        return sortBy;
    }

    /**
     * <p>
     * The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current calendar
     * month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value, Amazon Macie provides
     * usage data for the preceding 30 days.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeRange} will
     * return {@link TimeRange#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeRangeAsString}.
     * </p>
     * 
     * @return The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current
     *         calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value,
     *         Amazon Macie provides usage data for the preceding 30 days.
     * @see TimeRange
     */
    public final TimeRange timeRange() {
        return TimeRange.fromValue(timeRange);
    }

    /**
     * <p>
     * The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current calendar
     * month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value, Amazon Macie provides
     * usage data for the preceding 30 days.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeRange} will
     * return {@link TimeRange#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeRangeAsString}.
     * </p>
     * 
     * @return The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current
     *         calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value,
     *         Amazon Macie provides usage data for the preceding 30 days.
     * @see TimeRange
     */
    public final String timeRangeAsString() {
        return timeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterBy() ? filterBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(timeRangeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageStatisticsRequest)) {
            return false;
        }
        GetUsageStatisticsRequest other = (GetUsageStatisticsRequest) obj;
        return hasFilterBy() == other.hasFilterBy() && Objects.equals(filterBy(), other.filterBy())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(sortBy(), other.sortBy()) && Objects.equals(timeRangeAsString(), other.timeRangeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUsageStatisticsRequest").add("FilterBy", hasFilterBy() ? filterBy() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("SortBy", sortBy())
                .add("TimeRange", timeRangeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterBy":
            return Optional.ofNullable(clazz.cast(filterBy()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "timeRange":
            return Optional.ofNullable(clazz.cast(timeRangeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUsageStatisticsRequest, T> g) {
        return obj -> g.apply((GetUsageStatisticsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetUsageStatisticsRequest> {
        /**
         * <p>
         * An array of objects, one for each condition to use to filter the query results. If you specify more than one
         * condition, Amazon Macie uses an AND operator to join the conditions.
         * </p>
         * 
         * @param filterBy
         *        An array of objects, one for each condition to use to filter the query results. If you specify more
         *        than one condition, Amazon Macie uses an AND operator to join the conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterBy(Collection<UsageStatisticsFilter> filterBy);

        /**
         * <p>
         * An array of objects, one for each condition to use to filter the query results. If you specify more than one
         * condition, Amazon Macie uses an AND operator to join the conditions.
         * </p>
         * 
         * @param filterBy
         *        An array of objects, one for each condition to use to filter the query results. If you specify more
         *        than one condition, Amazon Macie uses an AND operator to join the conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterBy(UsageStatisticsFilter... filterBy);

        /**
         * <p>
         * An array of objects, one for each condition to use to filter the query results. If you specify more than one
         * condition, Amazon Macie uses an AND operator to join the conditions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.macie2.model.UsageStatisticsFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.macie2.model.UsageStatisticsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.macie2.model.UsageStatisticsFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filterBy(List<UsageStatisticsFilter>)}.
         * 
         * @param filterBy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.macie2.model.UsageStatisticsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterBy(java.util.Collection<UsageStatisticsFilter>)
         */
        Builder filterBy(Consumer<UsageStatisticsFilter.Builder>... filterBy);

        /**
         * <p>
         * The maximum number of items to include in each page of the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to include in each page of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The nextToken string that specifies which page of results to return in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string that specifies which page of results to return in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The criteria to use to sort the query results.
         * </p>
         * 
         * @param sortBy
         *        The criteria to use to sort the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(UsageStatisticsSortBy sortBy);

        /**
         * <p>
         * The criteria to use to sort the query results.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsageStatisticsSortBy.Builder} avoiding
         * the need to create one manually via {@link UsageStatisticsSortBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsageStatisticsSortBy.Builder#build()} is called immediately and
         * its result is passed to {@link #sortBy(UsageStatisticsSortBy)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link UsageStatisticsSortBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(UsageStatisticsSortBy)
         */
        default Builder sortBy(Consumer<UsageStatisticsSortBy.Builder> sortBy) {
            return sortBy(UsageStatisticsSortBy.builder().applyMutation(sortBy).build());
        }

        /**
         * <p>
         * The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current calendar
         * month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value, Amazon Macie
         * provides usage data for the preceding 30 days.
         * </p>
         * 
         * @param timeRange
         *        The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current
         *        calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value,
         *        Amazon Macie provides usage data for the preceding 30 days.
         * @see TimeRange
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeRange
         */
        Builder timeRange(String timeRange);

        /**
         * <p>
         * The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current calendar
         * month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value, Amazon Macie
         * provides usage data for the preceding 30 days.
         * </p>
         * 
         * @param timeRange
         *        The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current
         *        calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value,
         *        Amazon Macie provides usage data for the preceding 30 days.
         * @see TimeRange
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeRange
         */
        Builder timeRange(TimeRange timeRange);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private List<UsageStatisticsFilter> filterBy = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private UsageStatisticsSortBy sortBy;

        private String timeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageStatisticsRequest model) {
            super(model);
            filterBy(model.filterBy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sortBy(model.sortBy);
            timeRange(model.timeRange);
        }

        public final List<UsageStatisticsFilter.Builder> getFilterBy() {
            List<UsageStatisticsFilter.Builder> result = ___listOfUsageStatisticsFilterCopier.copyToBuilder(this.filterBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterBy(Collection<UsageStatisticsFilter.BuilderImpl> filterBy) {
            this.filterBy = ___listOfUsageStatisticsFilterCopier.copyFromBuilder(filterBy);
        }

        @Override
        public final Builder filterBy(Collection<UsageStatisticsFilter> filterBy) {
            this.filterBy = ___listOfUsageStatisticsFilterCopier.copy(filterBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterBy(UsageStatisticsFilter... filterBy) {
            filterBy(Arrays.asList(filterBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterBy(Consumer<UsageStatisticsFilter.Builder>... filterBy) {
            filterBy(Stream.of(filterBy).map(c -> UsageStatisticsFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final UsageStatisticsSortBy.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        public final void setSortBy(UsageStatisticsSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(UsageStatisticsSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final String getTimeRange() {
            return timeRange;
        }

        public final void setTimeRange(String timeRange) {
            this.timeRange = timeRange;
        }

        @Override
        public final Builder timeRange(String timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        @Override
        public final Builder timeRange(TimeRange timeRange) {
            this.timeRange(timeRange == null ? null : timeRange.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUsageStatisticsRequest build() {
            return new GetUsageStatisticsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
