/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetClassificationScopeResponse extends Macie2Response implements
        ToCopyableBuilder<GetClassificationScopeResponse.Builder, GetClassificationScopeResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetClassificationScopeResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetClassificationScopeResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<S3ClassificationScope> S3_FIELD = SdkField
            .<S3ClassificationScope> builder(MarshallingType.SDK_POJO).memberName("s3")
            .getter(getter(GetClassificationScopeResponse::s3)).setter(setter(Builder::s3))
            .constructor(S3ClassificationScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ID_FIELD, NAME_FIELD, S3_FIELD));

    private final String id;

    private final String name;

    private final S3ClassificationScope s3;

    private GetClassificationScopeResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.s3 = builder.s3;
    }

    /**
     * <p>
     * The unique identifier for the classification scope.
     * </p>
     * 
     * @return The unique identifier for the classification scope.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the classification scope: automated-sensitive-data-discovery.
     * </p>
     * 
     * @return The name of the classification scope: automated-sensitive-data-discovery.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The S3 buckets that are excluded from automated sensitive data discovery.
     * </p>
     * 
     * @return The S3 buckets that are excluded from automated sensitive data discovery.
     */
    public final S3ClassificationScope s3() {
        return s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClassificationScopeResponse)) {
            return false;
        }
        GetClassificationScopeResponse other = (GetClassificationScopeResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(s3(), other.s3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetClassificationScopeResponse").add("Id", id()).add("Name", name()).add("S3", s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "s3":
            return Optional.ofNullable(clazz.cast(s3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetClassificationScopeResponse, T> g) {
        return obj -> g.apply((GetClassificationScopeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetClassificationScopeResponse> {
        /**
         * <p>
         * The unique identifier for the classification scope.
         * </p>
         * 
         * @param id
         *        The unique identifier for the classification scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the classification scope: automated-sensitive-data-discovery.
         * </p>
         * 
         * @param name
         *        The name of the classification scope: automated-sensitive-data-discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The S3 buckets that are excluded from automated sensitive data discovery.
         * </p>
         * 
         * @param s3
         *        The S3 buckets that are excluded from automated sensitive data discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3ClassificationScope s3);

        /**
         * <p>
         * The S3 buckets that are excluded from automated sensitive data discovery.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ClassificationScope.Builder} avoiding
         * the need to create one manually via {@link S3ClassificationScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ClassificationScope.Builder#build()} is called immediately and
         * its result is passed to {@link #s3(S3ClassificationScope)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3ClassificationScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3ClassificationScope)
         */
        default Builder s3(Consumer<S3ClassificationScope.Builder> s3) {
            return s3(S3ClassificationScope.builder().applyMutation(s3).build());
        }
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private String id;

        private String name;

        private S3ClassificationScope s3;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClassificationScopeResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            s3(model.s3);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final S3ClassificationScope.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(S3ClassificationScope.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3ClassificationScope s3) {
            this.s3 = s3;
            return this;
        }

        @Override
        public GetClassificationScopeResponse build() {
            return new GetClassificationScopeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
