/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2AsyncClient;
import software.amazon.awssdk.services.macie2.internal.UserAgentUtils;
import software.amazon.awssdk.services.macie2.model.AdminAccount;
import software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest;
import software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse;

public class ListOrganizationAdminAccountsPublisher
implements SdkPublisher<ListOrganizationAdminAccountsResponse> {
    private final Macie2AsyncClient client;
    private final ListOrganizationAdminAccountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOrganizationAdminAccountsPublisher(Macie2AsyncClient client, ListOrganizationAdminAccountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOrganizationAdminAccountsPublisher(Macie2AsyncClient client, ListOrganizationAdminAccountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOrganizationAdminAccountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOrganizationAdminAccountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AdminAccount> adminAccounts() {
        Function<ListOrganizationAdminAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.adminAccounts() != null) {
                return response.adminAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOrganizationAdminAccountsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOrganizationAdminAccountsResponseFetcher
    implements AsyncPageFetcher<ListOrganizationAdminAccountsResponse> {
        private ListOrganizationAdminAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationAdminAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOrganizationAdminAccountsResponse> nextPage(ListOrganizationAdminAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationAdminAccountsPublisher.this.client.listOrganizationAdminAccounts(ListOrganizationAdminAccountsPublisher.this.firstRequest);
            }
            return ListOrganizationAdminAccountsPublisher.this.client.listOrganizationAdminAccounts((ListOrganizationAdminAccountsRequest)((Object)ListOrganizationAdminAccountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

