/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResourceProfileRequest extends Macie2Request implements
        ToCopyableBuilder<UpdateResourceProfileRequest.Builder, UpdateResourceProfileRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(UpdateResourceProfileRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceArn").build()).build();

    private static final SdkField<Integer> SENSITIVITY_SCORE_OVERRIDE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sensitivityScoreOverride").getter(getter(UpdateResourceProfileRequest::sensitivityScoreOverride))
            .setter(setter(Builder::sensitivityScoreOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitivityScoreOverride").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            SENSITIVITY_SCORE_OVERRIDE_FIELD));

    private final String resourceArn;

    private final Integer sensitivityScoreOverride;

    private UpdateResourceProfileRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.sensitivityScoreOverride = builder.sensitivityScoreOverride;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the S3 bucket that the request applies to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the S3 bucket that the request applies to.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The new sensitivity score for the bucket. Valid values are: 100, assign the maximum score and apply the
     * <i>Sensitive</i> label to the bucket; and, null (empty), assign a score that Amazon Macie calculates
     * automatically after you submit the request.
     * </p>
     * 
     * @return The new sensitivity score for the bucket. Valid values are: 100, assign the maximum score and apply the
     *         <i>Sensitive</i> label to the bucket; and, null (empty), assign a score that Amazon Macie calculates
     *         automatically after you submit the request.
     */
    public final Integer sensitivityScoreOverride() {
        return sensitivityScoreOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sensitivityScoreOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceProfileRequest)) {
            return false;
        }
        UpdateResourceProfileRequest other = (UpdateResourceProfileRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(sensitivityScoreOverride(), other.sensitivityScoreOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResourceProfileRequest").add("ResourceArn", resourceArn())
                .add("SensitivityScoreOverride", sensitivityScoreOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "sensitivityScoreOverride":
            return Optional.ofNullable(clazz.cast(sensitivityScoreOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceProfileRequest, T> g) {
        return obj -> g.apply((UpdateResourceProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateResourceProfileRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the S3 bucket that the request applies to.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the S3 bucket that the request applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The new sensitivity score for the bucket. Valid values are: 100, assign the maximum score and apply the
         * <i>Sensitive</i> label to the bucket; and, null (empty), assign a score that Amazon Macie calculates
         * automatically after you submit the request.
         * </p>
         * 
         * @param sensitivityScoreOverride
         *        The new sensitivity score for the bucket. Valid values are: 100, assign the maximum score and apply
         *        the <i>Sensitive</i> label to the bucket; and, null (empty), assign a score that Amazon Macie
         *        calculates automatically after you submit the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitivityScoreOverride(Integer sensitivityScoreOverride);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String resourceArn;

        private Integer sensitivityScoreOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceProfileRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            sensitivityScoreOverride(model.sensitivityScoreOverride);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Integer getSensitivityScoreOverride() {
            return sensitivityScoreOverride;
        }

        public final void setSensitivityScoreOverride(Integer sensitivityScoreOverride) {
            this.sensitivityScoreOverride = sensitivityScoreOverride;
        }

        @Override
        public final Builder sensitivityScoreOverride(Integer sensitivityScoreOverride) {
            this.sensitivityScoreOverride = sensitivityScoreOverride;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceProfileRequest build() {
            return new UpdateResourceProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
