/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the status of a sensitive data finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClassificationResultStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ClassificationResultStatus.Builder, ClassificationResultStatus> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(ClassificationResultStatus::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(ClassificationResultStatus::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String reason;

    private ClassificationResultStatus(BuilderImpl builder) {
        this.code = builder.code;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The status of the finding. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * COMPLETE - Amazon Macie successfully completed its analysis of the S3 object that the finding applies to.
     * </p>
     * </li>
     * <li>
     * <p>
     * PARTIAL - Macie analyzed only a subset of the data in the S3 object that the finding applies to. For example, the
     * object is an archive file that contains files in an unsupported format.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED - Macie wasn't able to analyze the S3 object that the finding applies to. For example, the object is a
     * file that uses an unsupported format.
     * </p>
     * </li>
     * </ul>
     * 
     * @return <p>
     *         The status of the finding. Possible values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         COMPLETE - Amazon Macie successfully completed its analysis of the S3 object that the finding applies to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PARTIAL - Macie analyzed only a subset of the data in the S3 object that the finding applies to. For
     *         example, the object is an archive file that contains files in an unsupported format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED - Macie wasn't able to analyze the S3 object that the finding applies to. For example, the object
     *         is a file that uses an unsupported format.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * A brief description of the status of the finding. This value is null if the status (code) of the finding is
     * COMPLETE.
     * </p>
     * <p>
     * Amazon Macie uses this value to notify you of any errors, warnings, or considerations that might impact your
     * analysis of the finding and the affected S3 object. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ARCHIVE_CONTAINS_UNPROCESSED_FILES - The object is an archive file and Macie extracted and analyzed only some or
     * none of the files in the archive. To determine which files Macie analyzed, if any, refer to the corresponding
     * sensitive data discovery result for the finding (ClassificationDetails.detailedResultsLocation).
     * </p>
     * </li>
     * <li>
     * <p>
     * ARCHIVE_EXCEEDS_SIZE_LIMIT - The object is an archive file whose total storage size exceeds the size quota for
     * this type of archive.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARCHIVE_NESTING_LEVEL_OVER_LIMIT - The object is an archive file whose nested depth exceeds the quota for the
     * maximum number of nested levels that Macie analyzes for this type of archive.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARCHIVE_TOTAL_BYTES_EXTRACTED_OVER_LIMIT - The object is an archive file that exceeds the quota for the maximum
     * amount of data that Macie extracts and analyzes for this type of archive.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARCHIVE_TOTAL_DOCUMENTS_PROCESSED_OVER_LIMIT - The object is an archive file that contains more than the maximum
     * number of files that Macie extracts and analyzes for this type of archive.
     * </p>
     * </li>
     * <li>
     * <p>
     * FILE_EXCEEDS_SIZE_LIMIT - The storage size of the object exceeds the size quota for this type of file.
     * </p>
     * </li>
     * <li>
     * <p>
     * INVALID_ENCRYPTION - The object is encrypted using server-side encryption but Macie isn't allowed to use the key.
     * Macie can't decrypt and analyze the object.
     * </p>
     * </li>
     * <li>
     * <p>
     * INVALID_KMS_KEY - The object is encrypted with an KMS key that was disabled or is being deleted. Macie can't
     * decrypt and analyze the object.
     * </p>
     * </li>
     * <li>
     * <p>
     * INVALID_OBJECT_STATE - The object doesn't use a supported Amazon S3 storage class.
     * </p>
     * </li>
     * <li>
     * <p>
     * JSON_NESTING_LEVEL_OVER_LIMIT - The object contains JSON data and the nested depth of the data exceeds the quota
     * for the number of nested levels that Macie analyzes for this type of file.
     * </p>
     * </li>
     * <li>
     * <p>
     * MALFORMED_FILE - The object is a malformed or corrupted file. An error occurred when Macie attempted to detect
     * the file's type or extract data from the file.
     * </p>
     * </li>
     * <li>
     * <p>
     * MALFORMED_OR_FILE_SIZE_EXCEEDS_LIMIT - The object is a Microsoft Office file that is malformed or exceeds the
     * size quota for this type of file. If the file is malformed, an error occurred when Macie attempted to extract
     * data from the file.
     * </p>
     * </li>
     * <li>
     * <p>
     * NO_SUCH_BUCKET_AVAILABLE - The object was in a bucket that was deleted shortly before or when Macie attempted to
     * analyze the object.
     * </p>
     * </li>
     * <li>
     * <p>
     * OBJECT_VERSION_MISMATCH - The object was changed while Macie was analyzing it.
     * </p>
     * </li>
     * <li>
     * <p>
     * OOXML_UNCOMPRESSED_RATIO_EXCEEDS_LIMIT - The object is an Office Open XML file whose compression ratio exceeds
     * the compression quota for this type of file.
     * </p>
     * </li>
     * <li>
     * <p>
     * OOXML_UNCOMPRESSED_SIZE_EXCEEDS_LIMIT - The object is an Office Open XML file that exceeds the size quota for
     * this type of file.
     * </p>
     * </li>
     * <li>
     * <p>
     * PERMISSION_DENIED - Macie isn't allowed to access the object. The object's permissions settings prevent Macie
     * from analyzing the object.
     * </p>
     * </li>
     * <li>
     * <p>
     * SOURCE_OBJECT_NO_LONGER_AVAILABLE - The object was deleted shortly before or when Macie attempted to analyze it.
     * </p>
     * </li>
     * <li>
     * <p>
     * TIME_CUT_OFF_REACHED - Macie started analyzing the object but additional analysis would exceed the time quota for
     * analyzing an object.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNABLE_TO_PARSE_FILE - The object is a file that contains structured data and an error occurred when Macie
     * attempted to parse the data.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNSUPPORTED_FILE_TYPE_EXCEPTION - The object is a file that uses an unsupported file or storage format.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about quotas, supported storage classes, and supported file and storage formats, see <a
     * href="https://docs.aws.amazon.com/macie/latest/user/macie-quotas.html">Quotas</a> and <a
     * href="https://docs.aws.amazon.com/macie/latest/user/discovery-supported-storage.html">Supported storage classes
     * and formats</a> in the <i>Amazon Macie User Guide</i>.
     * </p>
     * 
     * @return A brief description of the status of the finding. This value is null if the status (code) of the finding
     *         is COMPLETE.</p>
     *         <p>
     *         Amazon Macie uses this value to notify you of any errors, warnings, or considerations that might impact
     *         your analysis of the finding and the affected S3 object. Possible values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ARCHIVE_CONTAINS_UNPROCESSED_FILES - The object is an archive file and Macie extracted and analyzed only
     *         some or none of the files in the archive. To determine which files Macie analyzed, if any, refer to the
     *         corresponding sensitive data discovery result for the finding
     *         (ClassificationDetails.detailedResultsLocation).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARCHIVE_EXCEEDS_SIZE_LIMIT - The object is an archive file whose total storage size exceeds the size
     *         quota for this type of archive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARCHIVE_NESTING_LEVEL_OVER_LIMIT - The object is an archive file whose nested depth exceeds the quota for
     *         the maximum number of nested levels that Macie analyzes for this type of archive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARCHIVE_TOTAL_BYTES_EXTRACTED_OVER_LIMIT - The object is an archive file that exceeds the quota for the
     *         maximum amount of data that Macie extracts and analyzes for this type of archive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARCHIVE_TOTAL_DOCUMENTS_PROCESSED_OVER_LIMIT - The object is an archive file that contains more than the
     *         maximum number of files that Macie extracts and analyzes for this type of archive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FILE_EXCEEDS_SIZE_LIMIT - The storage size of the object exceeds the size quota for this type of file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_ENCRYPTION - The object is encrypted using server-side encryption but Macie isn't allowed to use
     *         the key. Macie can't decrypt and analyze the object.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_KMS_KEY - The object is encrypted with an KMS key that was disabled or is being deleted. Macie
     *         can't decrypt and analyze the object.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_OBJECT_STATE - The object doesn't use a supported Amazon S3 storage class.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         JSON_NESTING_LEVEL_OVER_LIMIT - The object contains JSON data and the nested depth of the data exceeds
     *         the quota for the number of nested levels that Macie analyzes for this type of file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MALFORMED_FILE - The object is a malformed or corrupted file. An error occurred when Macie attempted to
     *         detect the file's type or extract data from the file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MALFORMED_OR_FILE_SIZE_EXCEEDS_LIMIT - The object is a Microsoft Office file that is malformed or exceeds
     *         the size quota for this type of file. If the file is malformed, an error occurred when Macie attempted to
     *         extract data from the file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NO_SUCH_BUCKET_AVAILABLE - The object was in a bucket that was deleted shortly before or when Macie
     *         attempted to analyze the object.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OBJECT_VERSION_MISMATCH - The object was changed while Macie was analyzing it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OOXML_UNCOMPRESSED_RATIO_EXCEEDS_LIMIT - The object is an Office Open XML file whose compression ratio
     *         exceeds the compression quota for this type of file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OOXML_UNCOMPRESSED_SIZE_EXCEEDS_LIMIT - The object is an Office Open XML file that exceeds the size quota
     *         for this type of file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PERMISSION_DENIED - Macie isn't allowed to access the object. The object's permissions settings prevent
     *         Macie from analyzing the object.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SOURCE_OBJECT_NO_LONGER_AVAILABLE - The object was deleted shortly before or when Macie attempted to
     *         analyze it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TIME_CUT_OFF_REACHED - Macie started analyzing the object but additional analysis would exceed the time
     *         quota for analyzing an object.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNABLE_TO_PARSE_FILE - The object is a file that contains structured data and an error occurred when
     *         Macie attempted to parse the data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNSUPPORTED_FILE_TYPE_EXCEPTION - The object is a file that uses an unsupported file or storage format.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For information about quotas, supported storage classes, and supported file and storage formats, see <a
     *         href="https://docs.aws.amazon.com/macie/latest/user/macie-quotas.html">Quotas</a> and <a
     *         href="https://docs.aws.amazon.com/macie/latest/user/discovery-supported-storage.html">Supported storage
     *         classes and formats</a> in the <i>Amazon Macie User Guide</i>.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassificationResultStatus)) {
            return false;
        }
        ClassificationResultStatus other = (ClassificationResultStatus) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClassificationResultStatus").add("Code", code()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClassificationResultStatus, T> g) {
        return obj -> g.apply((ClassificationResultStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClassificationResultStatus> {
        /**
         * <p>
         * The status of the finding. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * COMPLETE - Amazon Macie successfully completed its analysis of the S3 object that the finding applies to.
         * </p>
         * </li>
         * <li>
         * <p>
         * PARTIAL - Macie analyzed only a subset of the data in the S3 object that the finding applies to. For example,
         * the object is an archive file that contains files in an unsupported format.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED - Macie wasn't able to analyze the S3 object that the finding applies to. For example, the object is
         * a file that uses an unsupported format.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        <p>
         *        The status of the finding. Possible values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        COMPLETE - Amazon Macie successfully completed its analysis of the S3 object that the finding applies
         *        to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PARTIAL - Macie analyzed only a subset of the data in the S3 object that the finding applies to. For
         *        example, the object is an archive file that contains files in an unsupported format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED - Macie wasn't able to analyze the S3 object that the finding applies to. For example, the
         *        object is a file that uses an unsupported format.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * A brief description of the status of the finding. This value is null if the status (code) of the finding is
         * COMPLETE.
         * </p>
         * <p>
         * Amazon Macie uses this value to notify you of any errors, warnings, or considerations that might impact your
         * analysis of the finding and the affected S3 object. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ARCHIVE_CONTAINS_UNPROCESSED_FILES - The object is an archive file and Macie extracted and analyzed only some
         * or none of the files in the archive. To determine which files Macie analyzed, if any, refer to the
         * corresponding sensitive data discovery result for the finding
         * (ClassificationDetails.detailedResultsLocation).
         * </p>
         * </li>
         * <li>
         * <p>
         * ARCHIVE_EXCEEDS_SIZE_LIMIT - The object is an archive file whose total storage size exceeds the size quota
         * for this type of archive.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARCHIVE_NESTING_LEVEL_OVER_LIMIT - The object is an archive file whose nested depth exceeds the quota for the
         * maximum number of nested levels that Macie analyzes for this type of archive.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARCHIVE_TOTAL_BYTES_EXTRACTED_OVER_LIMIT - The object is an archive file that exceeds the quota for the
         * maximum amount of data that Macie extracts and analyzes for this type of archive.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARCHIVE_TOTAL_DOCUMENTS_PROCESSED_OVER_LIMIT - The object is an archive file that contains more than the
         * maximum number of files that Macie extracts and analyzes for this type of archive.
         * </p>
         * </li>
         * <li>
         * <p>
         * FILE_EXCEEDS_SIZE_LIMIT - The storage size of the object exceeds the size quota for this type of file.
         * </p>
         * </li>
         * <li>
         * <p>
         * INVALID_ENCRYPTION - The object is encrypted using server-side encryption but Macie isn't allowed to use the
         * key. Macie can't decrypt and analyze the object.
         * </p>
         * </li>
         * <li>
         * <p>
         * INVALID_KMS_KEY - The object is encrypted with an KMS key that was disabled or is being deleted. Macie can't
         * decrypt and analyze the object.
         * </p>
         * </li>
         * <li>
         * <p>
         * INVALID_OBJECT_STATE - The object doesn't use a supported Amazon S3 storage class.
         * </p>
         * </li>
         * <li>
         * <p>
         * JSON_NESTING_LEVEL_OVER_LIMIT - The object contains JSON data and the nested depth of the data exceeds the
         * quota for the number of nested levels that Macie analyzes for this type of file.
         * </p>
         * </li>
         * <li>
         * <p>
         * MALFORMED_FILE - The object is a malformed or corrupted file. An error occurred when Macie attempted to
         * detect the file's type or extract data from the file.
         * </p>
         * </li>
         * <li>
         * <p>
         * MALFORMED_OR_FILE_SIZE_EXCEEDS_LIMIT - The object is a Microsoft Office file that is malformed or exceeds the
         * size quota for this type of file. If the file is malformed, an error occurred when Macie attempted to extract
         * data from the file.
         * </p>
         * </li>
         * <li>
         * <p>
         * NO_SUCH_BUCKET_AVAILABLE - The object was in a bucket that was deleted shortly before or when Macie attempted
         * to analyze the object.
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_VERSION_MISMATCH - The object was changed while Macie was analyzing it.
         * </p>
         * </li>
         * <li>
         * <p>
         * OOXML_UNCOMPRESSED_RATIO_EXCEEDS_LIMIT - The object is an Office Open XML file whose compression ratio
         * exceeds the compression quota for this type of file.
         * </p>
         * </li>
         * <li>
         * <p>
         * OOXML_UNCOMPRESSED_SIZE_EXCEEDS_LIMIT - The object is an Office Open XML file that exceeds the size quota for
         * this type of file.
         * </p>
         * </li>
         * <li>
         * <p>
         * PERMISSION_DENIED - Macie isn't allowed to access the object. The object's permissions settings prevent Macie
         * from analyzing the object.
         * </p>
         * </li>
         * <li>
         * <p>
         * SOURCE_OBJECT_NO_LONGER_AVAILABLE - The object was deleted shortly before or when Macie attempted to analyze
         * it.
         * </p>
         * </li>
         * <li>
         * <p>
         * TIME_CUT_OFF_REACHED - Macie started analyzing the object but additional analysis would exceed the time quota
         * for analyzing an object.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNABLE_TO_PARSE_FILE - The object is a file that contains structured data and an error occurred when Macie
         * attempted to parse the data.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNSUPPORTED_FILE_TYPE_EXCEPTION - The object is a file that uses an unsupported file or storage format.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For information about quotas, supported storage classes, and supported file and storage formats, see <a
         * href="https://docs.aws.amazon.com/macie/latest/user/macie-quotas.html">Quotas</a> and <a
         * href="https://docs.aws.amazon.com/macie/latest/user/discovery-supported-storage.html">Supported storage
         * classes and formats</a> in the <i>Amazon Macie User Guide</i>.
         * </p>
         * 
         * @param reason
         *        A brief description of the status of the finding. This value is null if the status (code) of the
         *        finding is COMPLETE.</p>
         *        <p>
         *        Amazon Macie uses this value to notify you of any errors, warnings, or considerations that might
         *        impact your analysis of the finding and the affected S3 object. Possible values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ARCHIVE_CONTAINS_UNPROCESSED_FILES - The object is an archive file and Macie extracted and analyzed
         *        only some or none of the files in the archive. To determine which files Macie analyzed, if any, refer
         *        to the corresponding sensitive data discovery result for the finding
         *        (ClassificationDetails.detailedResultsLocation).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARCHIVE_EXCEEDS_SIZE_LIMIT - The object is an archive file whose total storage size exceeds the size
         *        quota for this type of archive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARCHIVE_NESTING_LEVEL_OVER_LIMIT - The object is an archive file whose nested depth exceeds the quota
         *        for the maximum number of nested levels that Macie analyzes for this type of archive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARCHIVE_TOTAL_BYTES_EXTRACTED_OVER_LIMIT - The object is an archive file that exceeds the quota for
         *        the maximum amount of data that Macie extracts and analyzes for this type of archive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARCHIVE_TOTAL_DOCUMENTS_PROCESSED_OVER_LIMIT - The object is an archive file that contains more than
         *        the maximum number of files that Macie extracts and analyzes for this type of archive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FILE_EXCEEDS_SIZE_LIMIT - The storage size of the object exceeds the size quota for this type of file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INVALID_ENCRYPTION - The object is encrypted using server-side encryption but Macie isn't allowed to
         *        use the key. Macie can't decrypt and analyze the object.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INVALID_KMS_KEY - The object is encrypted with an KMS key that was disabled or is being deleted. Macie
         *        can't decrypt and analyze the object.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INVALID_OBJECT_STATE - The object doesn't use a supported Amazon S3 storage class.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        JSON_NESTING_LEVEL_OVER_LIMIT - The object contains JSON data and the nested depth of the data exceeds
         *        the quota for the number of nested levels that Macie analyzes for this type of file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MALFORMED_FILE - The object is a malformed or corrupted file. An error occurred when Macie attempted
         *        to detect the file's type or extract data from the file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MALFORMED_OR_FILE_SIZE_EXCEEDS_LIMIT - The object is a Microsoft Office file that is malformed or
         *        exceeds the size quota for this type of file. If the file is malformed, an error occurred when Macie
         *        attempted to extract data from the file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NO_SUCH_BUCKET_AVAILABLE - The object was in a bucket that was deleted shortly before or when Macie
         *        attempted to analyze the object.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_VERSION_MISMATCH - The object was changed while Macie was analyzing it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OOXML_UNCOMPRESSED_RATIO_EXCEEDS_LIMIT - The object is an Office Open XML file whose compression ratio
         *        exceeds the compression quota for this type of file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OOXML_UNCOMPRESSED_SIZE_EXCEEDS_LIMIT - The object is an Office Open XML file that exceeds the size
         *        quota for this type of file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PERMISSION_DENIED - Macie isn't allowed to access the object. The object's permissions settings
         *        prevent Macie from analyzing the object.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SOURCE_OBJECT_NO_LONGER_AVAILABLE - The object was deleted shortly before or when Macie attempted to
         *        analyze it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TIME_CUT_OFF_REACHED - Macie started analyzing the object but additional analysis would exceed the
         *        time quota for analyzing an object.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNABLE_TO_PARSE_FILE - The object is a file that contains structured data and an error occurred when
         *        Macie attempted to parse the data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNSUPPORTED_FILE_TYPE_EXCEPTION - The object is a file that uses an unsupported file or storage
         *        format.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For information about quotas, supported storage classes, and supported file and storage formats, see
         *        <a href="https://docs.aws.amazon.com/macie/latest/user/macie-quotas.html">Quotas</a> and <a
         *        href="https://docs.aws.amazon.com/macie/latest/user/discovery-supported-storage.html">Supported
         *        storage classes and formats</a> in the <i>Amazon Macie User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassificationResultStatus model) {
            code(model.code);
            reason(model.reason);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public ClassificationResultStatus build() {
            return new ClassificationResultStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
