/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2AsyncClient;
import software.amazon.awssdk.services.macie2.model.ListSensitivityInspectionTemplatesRequest;
import software.amazon.awssdk.services.macie2.model.ListSensitivityInspectionTemplatesResponse;
import software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplatesEntry;

public class ListSensitivityInspectionTemplatesPublisher
implements SdkPublisher<ListSensitivityInspectionTemplatesResponse> {
    private final Macie2AsyncClient client;
    private final ListSensitivityInspectionTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSensitivityInspectionTemplatesPublisher(Macie2AsyncClient client, ListSensitivityInspectionTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSensitivityInspectionTemplatesPublisher(Macie2AsyncClient client, ListSensitivityInspectionTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSensitivityInspectionTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSensitivityInspectionTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SensitivityInspectionTemplatesEntry> sensitivityInspectionTemplates() {
        Function<ListSensitivityInspectionTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sensitivityInspectionTemplates() != null) {
                return response.sensitivityInspectionTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSensitivityInspectionTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSensitivityInspectionTemplatesResponseFetcher
    implements AsyncPageFetcher<ListSensitivityInspectionTemplatesResponse> {
        private ListSensitivityInspectionTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListSensitivityInspectionTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSensitivityInspectionTemplatesResponse> nextPage(ListSensitivityInspectionTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListSensitivityInspectionTemplatesPublisher.this.client.listSensitivityInspectionTemplates(ListSensitivityInspectionTemplatesPublisher.this.firstRequest);
            }
            return ListSensitivityInspectionTemplatesPublisher.this.client.listSensitivityInspectionTemplates((ListSensitivityInspectionTemplatesRequest)((Object)ListSensitivityInspectionTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

