/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2AsyncClient;
import software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsRequest;
import software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsResponse;
import software.amazon.awssdk.services.macie2.model.ResourceProfileArtifact;

public class ListResourceProfileArtifactsPublisher
implements SdkPublisher<ListResourceProfileArtifactsResponse> {
    private final Macie2AsyncClient client;
    private final ListResourceProfileArtifactsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceProfileArtifactsPublisher(Macie2AsyncClient client, ListResourceProfileArtifactsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceProfileArtifactsPublisher(Macie2AsyncClient client, ListResourceProfileArtifactsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceProfileArtifactsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceProfileArtifactsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceProfileArtifact> artifacts() {
        Function<ListResourceProfileArtifactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.artifacts() != null) {
                return response.artifacts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceProfileArtifactsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceProfileArtifactsResponseFetcher
    implements AsyncPageFetcher<ListResourceProfileArtifactsResponse> {
        private ListResourceProfileArtifactsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceProfileArtifactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceProfileArtifactsResponse> nextPage(ListResourceProfileArtifactsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceProfileArtifactsPublisher.this.client.listResourceProfileArtifacts(ListResourceProfileArtifactsPublisher.this.firstRequest);
            }
            return ListResourceProfileArtifactsPublisher.this.client.listResourceProfileArtifacts((ListResourceProfileArtifactsRequest)((Object)ListResourceProfileArtifactsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

