/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2Client;
import software.amazon.awssdk.services.macie2.model.CustomDataIdentifierSummary;
import software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest;
import software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse;

public class ListCustomDataIdentifiersIterable
implements SdkIterable<ListCustomDataIdentifiersResponse> {
    private final Macie2Client client;
    private final ListCustomDataIdentifiersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomDataIdentifiersIterable(Macie2Client client, ListCustomDataIdentifiersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCustomDataIdentifiersResponseFetcher();
    }

    public Iterator<ListCustomDataIdentifiersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CustomDataIdentifierSummary> items() {
        Function<ListCustomDataIdentifiersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCustomDataIdentifiersResponseFetcher
    implements SyncPageFetcher<ListCustomDataIdentifiersResponse> {
        private ListCustomDataIdentifiersResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomDataIdentifiersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomDataIdentifiersResponse nextPage(ListCustomDataIdentifiersResponse previousPage) {
            if (previousPage == null) {
                return ListCustomDataIdentifiersIterable.this.client.listCustomDataIdentifiers(ListCustomDataIdentifiersIterable.this.firstRequest);
            }
            return ListCustomDataIdentifiersIterable.this.client.listCustomDataIdentifiers((ListCustomDataIdentifiersRequest)((Object)ListCustomDataIdentifiersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

