/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides statistical data for sensitive data discovery metrics that apply to an S3 bucket that Amazon Macie monitors
 * and analyzes for your account. The statistics capture the results of automated sensitive data discovery activities
 * that Macie has performed for the bucket. The data is available only if automated sensitive data discovery is
 * currently enabled for your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceStatistics.Builder, ResourceStatistics> {
    private static final SdkField<Long> TOTAL_BYTES_CLASSIFIED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalBytesClassified").getter(getter(ResourceStatistics::totalBytesClassified))
            .setter(setter(Builder::totalBytesClassified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalBytesClassified").build())
            .build();

    private static final SdkField<Long> TOTAL_DETECTIONS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalDetections").getter(getter(ResourceStatistics::totalDetections))
            .setter(setter(Builder::totalDetections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalDetections").build()).build();

    private static final SdkField<Long> TOTAL_DETECTIONS_SUPPRESSED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalDetectionsSuppressed").getter(getter(ResourceStatistics::totalDetectionsSuppressed))
            .setter(setter(Builder::totalDetectionsSuppressed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalDetectionsSuppressed").build())
            .build();

    private static final SdkField<Long> TOTAL_ITEMS_CLASSIFIED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalItemsClassified").getter(getter(ResourceStatistics::totalItemsClassified))
            .setter(setter(Builder::totalItemsClassified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalItemsClassified").build())
            .build();

    private static final SdkField<Long> TOTAL_ITEMS_SENSITIVE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalItemsSensitive").getter(getter(ResourceStatistics::totalItemsSensitive))
            .setter(setter(Builder::totalItemsSensitive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalItemsSensitive").build())
            .build();

    private static final SdkField<Long> TOTAL_ITEMS_SKIPPED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalItemsSkipped").getter(getter(ResourceStatistics::totalItemsSkipped))
            .setter(setter(Builder::totalItemsSkipped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalItemsSkipped").build()).build();

    private static final SdkField<Long> TOTAL_ITEMS_SKIPPED_INVALID_ENCRYPTION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("totalItemsSkippedInvalidEncryption")
            .getter(getter(ResourceStatistics::totalItemsSkippedInvalidEncryption))
            .setter(setter(Builder::totalItemsSkippedInvalidEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalItemsSkippedInvalidEncryption")
                    .build()).build();

    private static final SdkField<Long> TOTAL_ITEMS_SKIPPED_INVALID_KMS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("totalItemsSkippedInvalidKms")
            .getter(getter(ResourceStatistics::totalItemsSkippedInvalidKms))
            .setter(setter(Builder::totalItemsSkippedInvalidKms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalItemsSkippedInvalidKms")
                    .build()).build();

    private static final SdkField<Long> TOTAL_ITEMS_SKIPPED_PERMISSION_DENIED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("totalItemsSkippedPermissionDenied")
            .getter(getter(ResourceStatistics::totalItemsSkippedPermissionDenied))
            .setter(setter(Builder::totalItemsSkippedPermissionDenied))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalItemsSkippedPermissionDenied")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_BYTES_CLASSIFIED_FIELD,
            TOTAL_DETECTIONS_FIELD, TOTAL_DETECTIONS_SUPPRESSED_FIELD, TOTAL_ITEMS_CLASSIFIED_FIELD, TOTAL_ITEMS_SENSITIVE_FIELD,
            TOTAL_ITEMS_SKIPPED_FIELD, TOTAL_ITEMS_SKIPPED_INVALID_ENCRYPTION_FIELD, TOTAL_ITEMS_SKIPPED_INVALID_KMS_FIELD,
            TOTAL_ITEMS_SKIPPED_PERMISSION_DENIED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long totalBytesClassified;

    private final Long totalDetections;

    private final Long totalDetectionsSuppressed;

    private final Long totalItemsClassified;

    private final Long totalItemsSensitive;

    private final Long totalItemsSkipped;

    private final Long totalItemsSkippedInvalidEncryption;

    private final Long totalItemsSkippedInvalidKms;

    private final Long totalItemsSkippedPermissionDenied;

    private ResourceStatistics(BuilderImpl builder) {
        this.totalBytesClassified = builder.totalBytesClassified;
        this.totalDetections = builder.totalDetections;
        this.totalDetectionsSuppressed = builder.totalDetectionsSuppressed;
        this.totalItemsClassified = builder.totalItemsClassified;
        this.totalItemsSensitive = builder.totalItemsSensitive;
        this.totalItemsSkipped = builder.totalItemsSkipped;
        this.totalItemsSkippedInvalidEncryption = builder.totalItemsSkippedInvalidEncryption;
        this.totalItemsSkippedInvalidKms = builder.totalItemsSkippedInvalidKms;
        this.totalItemsSkippedPermissionDenied = builder.totalItemsSkippedPermissionDenied;
    }

    /**
     * <p>
     * The total amount of data, in bytes, that Amazon Macie has analyzed in the bucket.
     * </p>
     * 
     * @return The total amount of data, in bytes, that Amazon Macie has analyzed in the bucket.
     */
    public final Long totalBytesClassified() {
        return totalBytesClassified;
    }

    /**
     * <p>
     * The total number of occurrences of sensitive data that Amazon Macie has found in the bucket's objects. This
     * includes occurrences that are currently suppressed by the sensitivity scoring settings for the bucket
     * (totalDetectionsSuppressed).
     * </p>
     * 
     * @return The total number of occurrences of sensitive data that Amazon Macie has found in the bucket's objects.
     *         This includes occurrences that are currently suppressed by the sensitivity scoring settings for the
     *         bucket (totalDetectionsSuppressed).
     */
    public final Long totalDetections() {
        return totalDetections;
    }

    /**
     * <p>
     * The total number of occurrences of sensitive data that are currently suppressed by the sensitivity scoring
     * settings for the bucket. These represent occurrences of sensitive data that Amazon Macie found in the bucket's
     * objects, but the occurrences were manually suppressed. By default, suppressed occurrences are excluded from the
     * bucket's sensitivity score.
     * </p>
     * 
     * @return The total number of occurrences of sensitive data that are currently suppressed by the sensitivity
     *         scoring settings for the bucket. These represent occurrences of sensitive data that Amazon Macie found in
     *         the bucket's objects, but the occurrences were manually suppressed. By default, suppressed occurrences
     *         are excluded from the bucket's sensitivity score.
     */
    public final Long totalDetectionsSuppressed() {
        return totalDetectionsSuppressed;
    }

    /**
     * <p>
     * The total number of objects that Amazon Macie has analyzed in the bucket.
     * </p>
     * 
     * @return The total number of objects that Amazon Macie has analyzed in the bucket.
     */
    public final Long totalItemsClassified() {
        return totalItemsClassified;
    }

    /**
     * <p>
     * The total number of the bucket's objects that Amazon Macie has found sensitive data in.
     * </p>
     * 
     * @return The total number of the bucket's objects that Amazon Macie has found sensitive data in.
     */
    public final Long totalItemsSensitive() {
        return totalItemsSensitive;
    }

    /**
     * <p>
     * The total number of objects that Amazon Macie hasn't analyzed in the bucket due to an error or issue. For
     * example, the object is a malformed file. This value includes objects that Macie hasn't analyzed for reasons
     * reported by other statistics in the ResourceStatistics object.
     * </p>
     * 
     * @return The total number of objects that Amazon Macie hasn't analyzed in the bucket due to an error or issue. For
     *         example, the object is a malformed file. This value includes objects that Macie hasn't analyzed for
     *         reasons reported by other statistics in the ResourceStatistics object.
     */
    public final Long totalItemsSkipped() {
        return totalItemsSkipped;
    }

    /**
     * <p>
     * The total number of objects that Amazon Macie hasn't analyzed in the bucket because the objects are encrypted
     * with a key that Macie isn't allowed to use.
     * </p>
     * 
     * @return The total number of objects that Amazon Macie hasn't analyzed in the bucket because the objects are
     *         encrypted with a key that Macie isn't allowed to use.
     */
    public final Long totalItemsSkippedInvalidEncryption() {
        return totalItemsSkippedInvalidEncryption;
    }

    /**
     * <p>
     * The total number of objects that Amazon Macie hasn't analyzed in the bucket because the objects are encrypted
     * with an KMS key that was disabled or deleted.
     * </p>
     * 
     * @return The total number of objects that Amazon Macie hasn't analyzed in the bucket because the objects are
     *         encrypted with an KMS key that was disabled or deleted.
     */
    public final Long totalItemsSkippedInvalidKms() {
        return totalItemsSkippedInvalidKms;
    }

    /**
     * <p>
     * The total number of objects that Amazon Macie hasn't analyzed in the bucket because Macie isn't allowed to access
     * the objects.
     * </p>
     * 
     * @return The total number of objects that Amazon Macie hasn't analyzed in the bucket because Macie isn't allowed
     *         to access the objects.
     */
    public final Long totalItemsSkippedPermissionDenied() {
        return totalItemsSkippedPermissionDenied;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalBytesClassified());
        hashCode = 31 * hashCode + Objects.hashCode(totalDetections());
        hashCode = 31 * hashCode + Objects.hashCode(totalDetectionsSuppressed());
        hashCode = 31 * hashCode + Objects.hashCode(totalItemsClassified());
        hashCode = 31 * hashCode + Objects.hashCode(totalItemsSensitive());
        hashCode = 31 * hashCode + Objects.hashCode(totalItemsSkipped());
        hashCode = 31 * hashCode + Objects.hashCode(totalItemsSkippedInvalidEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(totalItemsSkippedInvalidKms());
        hashCode = 31 * hashCode + Objects.hashCode(totalItemsSkippedPermissionDenied());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceStatistics)) {
            return false;
        }
        ResourceStatistics other = (ResourceStatistics) obj;
        return Objects.equals(totalBytesClassified(), other.totalBytesClassified())
                && Objects.equals(totalDetections(), other.totalDetections())
                && Objects.equals(totalDetectionsSuppressed(), other.totalDetectionsSuppressed())
                && Objects.equals(totalItemsClassified(), other.totalItemsClassified())
                && Objects.equals(totalItemsSensitive(), other.totalItemsSensitive())
                && Objects.equals(totalItemsSkipped(), other.totalItemsSkipped())
                && Objects.equals(totalItemsSkippedInvalidEncryption(), other.totalItemsSkippedInvalidEncryption())
                && Objects.equals(totalItemsSkippedInvalidKms(), other.totalItemsSkippedInvalidKms())
                && Objects.equals(totalItemsSkippedPermissionDenied(), other.totalItemsSkippedPermissionDenied());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceStatistics").add("TotalBytesClassified", totalBytesClassified())
                .add("TotalDetections", totalDetections()).add("TotalDetectionsSuppressed", totalDetectionsSuppressed())
                .add("TotalItemsClassified", totalItemsClassified()).add("TotalItemsSensitive", totalItemsSensitive())
                .add("TotalItemsSkipped", totalItemsSkipped())
                .add("TotalItemsSkippedInvalidEncryption", totalItemsSkippedInvalidEncryption())
                .add("TotalItemsSkippedInvalidKms", totalItemsSkippedInvalidKms())
                .add("TotalItemsSkippedPermissionDenied", totalItemsSkippedPermissionDenied()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalBytesClassified":
            return Optional.ofNullable(clazz.cast(totalBytesClassified()));
        case "totalDetections":
            return Optional.ofNullable(clazz.cast(totalDetections()));
        case "totalDetectionsSuppressed":
            return Optional.ofNullable(clazz.cast(totalDetectionsSuppressed()));
        case "totalItemsClassified":
            return Optional.ofNullable(clazz.cast(totalItemsClassified()));
        case "totalItemsSensitive":
            return Optional.ofNullable(clazz.cast(totalItemsSensitive()));
        case "totalItemsSkipped":
            return Optional.ofNullable(clazz.cast(totalItemsSkipped()));
        case "totalItemsSkippedInvalidEncryption":
            return Optional.ofNullable(clazz.cast(totalItemsSkippedInvalidEncryption()));
        case "totalItemsSkippedInvalidKms":
            return Optional.ofNullable(clazz.cast(totalItemsSkippedInvalidKms()));
        case "totalItemsSkippedPermissionDenied":
            return Optional.ofNullable(clazz.cast(totalItemsSkippedPermissionDenied()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceStatistics, T> g) {
        return obj -> g.apply((ResourceStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceStatistics> {
        /**
         * <p>
         * The total amount of data, in bytes, that Amazon Macie has analyzed in the bucket.
         * </p>
         * 
         * @param totalBytesClassified
         *        The total amount of data, in bytes, that Amazon Macie has analyzed in the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalBytesClassified(Long totalBytesClassified);

        /**
         * <p>
         * The total number of occurrences of sensitive data that Amazon Macie has found in the bucket's objects. This
         * includes occurrences that are currently suppressed by the sensitivity scoring settings for the bucket
         * (totalDetectionsSuppressed).
         * </p>
         * 
         * @param totalDetections
         *        The total number of occurrences of sensitive data that Amazon Macie has found in the bucket's objects.
         *        This includes occurrences that are currently suppressed by the sensitivity scoring settings for the
         *        bucket (totalDetectionsSuppressed).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalDetections(Long totalDetections);

        /**
         * <p>
         * The total number of occurrences of sensitive data that are currently suppressed by the sensitivity scoring
         * settings for the bucket. These represent occurrences of sensitive data that Amazon Macie found in the
         * bucket's objects, but the occurrences were manually suppressed. By default, suppressed occurrences are
         * excluded from the bucket's sensitivity score.
         * </p>
         * 
         * @param totalDetectionsSuppressed
         *        The total number of occurrences of sensitive data that are currently suppressed by the sensitivity
         *        scoring settings for the bucket. These represent occurrences of sensitive data that Amazon Macie found
         *        in the bucket's objects, but the occurrences were manually suppressed. By default, suppressed
         *        occurrences are excluded from the bucket's sensitivity score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalDetectionsSuppressed(Long totalDetectionsSuppressed);

        /**
         * <p>
         * The total number of objects that Amazon Macie has analyzed in the bucket.
         * </p>
         * 
         * @param totalItemsClassified
         *        The total number of objects that Amazon Macie has analyzed in the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalItemsClassified(Long totalItemsClassified);

        /**
         * <p>
         * The total number of the bucket's objects that Amazon Macie has found sensitive data in.
         * </p>
         * 
         * @param totalItemsSensitive
         *        The total number of the bucket's objects that Amazon Macie has found sensitive data in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalItemsSensitive(Long totalItemsSensitive);

        /**
         * <p>
         * The total number of objects that Amazon Macie hasn't analyzed in the bucket due to an error or issue. For
         * example, the object is a malformed file. This value includes objects that Macie hasn't analyzed for reasons
         * reported by other statistics in the ResourceStatistics object.
         * </p>
         * 
         * @param totalItemsSkipped
         *        The total number of objects that Amazon Macie hasn't analyzed in the bucket due to an error or issue.
         *        For example, the object is a malformed file. This value includes objects that Macie hasn't analyzed
         *        for reasons reported by other statistics in the ResourceStatistics object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalItemsSkipped(Long totalItemsSkipped);

        /**
         * <p>
         * The total number of objects that Amazon Macie hasn't analyzed in the bucket because the objects are encrypted
         * with a key that Macie isn't allowed to use.
         * </p>
         * 
         * @param totalItemsSkippedInvalidEncryption
         *        The total number of objects that Amazon Macie hasn't analyzed in the bucket because the objects are
         *        encrypted with a key that Macie isn't allowed to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalItemsSkippedInvalidEncryption(Long totalItemsSkippedInvalidEncryption);

        /**
         * <p>
         * The total number of objects that Amazon Macie hasn't analyzed in the bucket because the objects are encrypted
         * with an KMS key that was disabled or deleted.
         * </p>
         * 
         * @param totalItemsSkippedInvalidKms
         *        The total number of objects that Amazon Macie hasn't analyzed in the bucket because the objects are
         *        encrypted with an KMS key that was disabled or deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalItemsSkippedInvalidKms(Long totalItemsSkippedInvalidKms);

        /**
         * <p>
         * The total number of objects that Amazon Macie hasn't analyzed in the bucket because Macie isn't allowed to
         * access the objects.
         * </p>
         * 
         * @param totalItemsSkippedPermissionDenied
         *        The total number of objects that Amazon Macie hasn't analyzed in the bucket because Macie isn't
         *        allowed to access the objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalItemsSkippedPermissionDenied(Long totalItemsSkippedPermissionDenied);
    }

    static final class BuilderImpl implements Builder {
        private Long totalBytesClassified;

        private Long totalDetections;

        private Long totalDetectionsSuppressed;

        private Long totalItemsClassified;

        private Long totalItemsSensitive;

        private Long totalItemsSkipped;

        private Long totalItemsSkippedInvalidEncryption;

        private Long totalItemsSkippedInvalidKms;

        private Long totalItemsSkippedPermissionDenied;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceStatistics model) {
            totalBytesClassified(model.totalBytesClassified);
            totalDetections(model.totalDetections);
            totalDetectionsSuppressed(model.totalDetectionsSuppressed);
            totalItemsClassified(model.totalItemsClassified);
            totalItemsSensitive(model.totalItemsSensitive);
            totalItemsSkipped(model.totalItemsSkipped);
            totalItemsSkippedInvalidEncryption(model.totalItemsSkippedInvalidEncryption);
            totalItemsSkippedInvalidKms(model.totalItemsSkippedInvalidKms);
            totalItemsSkippedPermissionDenied(model.totalItemsSkippedPermissionDenied);
        }

        public final Long getTotalBytesClassified() {
            return totalBytesClassified;
        }

        public final void setTotalBytesClassified(Long totalBytesClassified) {
            this.totalBytesClassified = totalBytesClassified;
        }

        @Override
        public final Builder totalBytesClassified(Long totalBytesClassified) {
            this.totalBytesClassified = totalBytesClassified;
            return this;
        }

        public final Long getTotalDetections() {
            return totalDetections;
        }

        public final void setTotalDetections(Long totalDetections) {
            this.totalDetections = totalDetections;
        }

        @Override
        public final Builder totalDetections(Long totalDetections) {
            this.totalDetections = totalDetections;
            return this;
        }

        public final Long getTotalDetectionsSuppressed() {
            return totalDetectionsSuppressed;
        }

        public final void setTotalDetectionsSuppressed(Long totalDetectionsSuppressed) {
            this.totalDetectionsSuppressed = totalDetectionsSuppressed;
        }

        @Override
        public final Builder totalDetectionsSuppressed(Long totalDetectionsSuppressed) {
            this.totalDetectionsSuppressed = totalDetectionsSuppressed;
            return this;
        }

        public final Long getTotalItemsClassified() {
            return totalItemsClassified;
        }

        public final void setTotalItemsClassified(Long totalItemsClassified) {
            this.totalItemsClassified = totalItemsClassified;
        }

        @Override
        public final Builder totalItemsClassified(Long totalItemsClassified) {
            this.totalItemsClassified = totalItemsClassified;
            return this;
        }

        public final Long getTotalItemsSensitive() {
            return totalItemsSensitive;
        }

        public final void setTotalItemsSensitive(Long totalItemsSensitive) {
            this.totalItemsSensitive = totalItemsSensitive;
        }

        @Override
        public final Builder totalItemsSensitive(Long totalItemsSensitive) {
            this.totalItemsSensitive = totalItemsSensitive;
            return this;
        }

        public final Long getTotalItemsSkipped() {
            return totalItemsSkipped;
        }

        public final void setTotalItemsSkipped(Long totalItemsSkipped) {
            this.totalItemsSkipped = totalItemsSkipped;
        }

        @Override
        public final Builder totalItemsSkipped(Long totalItemsSkipped) {
            this.totalItemsSkipped = totalItemsSkipped;
            return this;
        }

        public final Long getTotalItemsSkippedInvalidEncryption() {
            return totalItemsSkippedInvalidEncryption;
        }

        public final void setTotalItemsSkippedInvalidEncryption(Long totalItemsSkippedInvalidEncryption) {
            this.totalItemsSkippedInvalidEncryption = totalItemsSkippedInvalidEncryption;
        }

        @Override
        public final Builder totalItemsSkippedInvalidEncryption(Long totalItemsSkippedInvalidEncryption) {
            this.totalItemsSkippedInvalidEncryption = totalItemsSkippedInvalidEncryption;
            return this;
        }

        public final Long getTotalItemsSkippedInvalidKms() {
            return totalItemsSkippedInvalidKms;
        }

        public final void setTotalItemsSkippedInvalidKms(Long totalItemsSkippedInvalidKms) {
            this.totalItemsSkippedInvalidKms = totalItemsSkippedInvalidKms;
        }

        @Override
        public final Builder totalItemsSkippedInvalidKms(Long totalItemsSkippedInvalidKms) {
            this.totalItemsSkippedInvalidKms = totalItemsSkippedInvalidKms;
            return this;
        }

        public final Long getTotalItemsSkippedPermissionDenied() {
            return totalItemsSkippedPermissionDenied;
        }

        public final void setTotalItemsSkippedPermissionDenied(Long totalItemsSkippedPermissionDenied) {
            this.totalItemsSkippedPermissionDenied = totalItemsSkippedPermissionDenied;
        }

        @Override
        public final Builder totalItemsSkippedPermissionDenied(Long totalItemsSkippedPermissionDenied) {
            this.totalItemsSkippedPermissionDenied = totalItemsSkippedPermissionDenied;
            return this;
        }

        @Override
        public ResourceStatistics build() {
            return new ResourceStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
