/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSensitivityInspectionTemplateResponse extends Macie2Response implements
        ToCopyableBuilder<GetSensitivityInspectionTemplateResponse.Builder, GetSensitivityInspectionTemplateResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetSensitivityInspectionTemplateResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<SensitivityInspectionTemplateExcludes> EXCLUDES_FIELD = SdkField
            .<SensitivityInspectionTemplateExcludes> builder(MarshallingType.SDK_POJO).memberName("excludes")
            .getter(getter(GetSensitivityInspectionTemplateResponse::excludes)).setter(setter(Builder::excludes))
            .constructor(SensitivityInspectionTemplateExcludes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludes").build()).build();

    private static final SdkField<SensitivityInspectionTemplateIncludes> INCLUDES_FIELD = SdkField
            .<SensitivityInspectionTemplateIncludes> builder(MarshallingType.SDK_POJO).memberName("includes")
            .getter(getter(GetSensitivityInspectionTemplateResponse::includes)).setter(setter(Builder::includes))
            .constructor(SensitivityInspectionTemplateIncludes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includes").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetSensitivityInspectionTemplateResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SENSITIVITY_INSPECTION_TEMPLATE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("sensitivityInspectionTemplateId")
            .getter(getter(GetSensitivityInspectionTemplateResponse::sensitivityInspectionTemplateId))
            .setter(setter(Builder::sensitivityInspectionTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitivityInspectionTemplateId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            EXCLUDES_FIELD, INCLUDES_FIELD, NAME_FIELD, SENSITIVITY_INSPECTION_TEMPLATE_ID_FIELD));

    private final String description;

    private final SensitivityInspectionTemplateExcludes excludes;

    private final SensitivityInspectionTemplateIncludes includes;

    private final String name;

    private final String sensitivityInspectionTemplateId;

    private GetSensitivityInspectionTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.excludes = builder.excludes;
        this.includes = builder.includes;
        this.name = builder.name;
        this.sensitivityInspectionTemplateId = builder.sensitivityInspectionTemplateId;
    }

    /**
     * <p>
     * The custom description of the template.
     * </p>
     * 
     * @return The custom description of the template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The managed data identifiers that are explicitly excluded (not used) when analyzing data.
     * </p>
     * 
     * @return <p>
     *         The managed data identifiers that are explicitly excluded (not used) when analyzing data.
     *         </p>
     */
    public final SensitivityInspectionTemplateExcludes excludes() {
        return excludes;
    }

    /**
     * <p>
     * The allow lists, custom data identifiers, and managed data identifiers that are included (used) when analyzing
     * data.
     * </p>
     * 
     * @return The allow lists, custom data identifiers, and managed data identifiers that are included (used) when
     *         analyzing data.
     */
    public final SensitivityInspectionTemplateIncludes includes() {
        return includes;
    }

    /**
     * <p>
     * The name of the template: automated-sensitive-data-discovery.
     * </p>
     * 
     * @return The name of the template: automated-sensitive-data-discovery.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier for the template.
     * </p>
     * 
     * @return The unique identifier for the template.
     */
    public final String sensitivityInspectionTemplateId() {
        return sensitivityInspectionTemplateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(excludes());
        hashCode = 31 * hashCode + Objects.hashCode(includes());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sensitivityInspectionTemplateId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSensitivityInspectionTemplateResponse)) {
            return false;
        }
        GetSensitivityInspectionTemplateResponse other = (GetSensitivityInspectionTemplateResponse) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(excludes(), other.excludes())
                && Objects.equals(includes(), other.includes()) && Objects.equals(name(), other.name())
                && Objects.equals(sensitivityInspectionTemplateId(), other.sensitivityInspectionTemplateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSensitivityInspectionTemplateResponse").add("Description", description())
                .add("Excludes", excludes()).add("Includes", includes()).add("Name", name())
                .add("SensitivityInspectionTemplateId", sensitivityInspectionTemplateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "excludes":
            return Optional.ofNullable(clazz.cast(excludes()));
        case "includes":
            return Optional.ofNullable(clazz.cast(includes()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "sensitivityInspectionTemplateId":
            return Optional.ofNullable(clazz.cast(sensitivityInspectionTemplateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSensitivityInspectionTemplateResponse, T> g) {
        return obj -> g.apply((GetSensitivityInspectionTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSensitivityInspectionTemplateResponse> {
        /**
         * <p>
         * The custom description of the template.
         * </p>
         * 
         * @param description
         *        The custom description of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The managed data identifiers that are explicitly excluded (not used) when analyzing data.
         * </p>
         * 
         * @param excludes
         *        <p>
         *        The managed data identifiers that are explicitly excluded (not used) when analyzing data.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(SensitivityInspectionTemplateExcludes excludes);

        /**
         * <p>
         * The managed data identifiers that are explicitly excluded (not used) when analyzing data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SensitivityInspectionTemplateExcludes.Builder} avoiding the need to create one manually via
         * {@link SensitivityInspectionTemplateExcludes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SensitivityInspectionTemplateExcludes.Builder#build()} is called
         * immediately and its result is passed to {@link #excludes(SensitivityInspectionTemplateExcludes)}.
         * 
         * @param excludes
         *        a consumer that will call methods on {@link SensitivityInspectionTemplateExcludes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludes(SensitivityInspectionTemplateExcludes)
         */
        default Builder excludes(Consumer<SensitivityInspectionTemplateExcludes.Builder> excludes) {
            return excludes(SensitivityInspectionTemplateExcludes.builder().applyMutation(excludes).build());
        }

        /**
         * <p>
         * The allow lists, custom data identifiers, and managed data identifiers that are included (used) when
         * analyzing data.
         * </p>
         * 
         * @param includes
         *        The allow lists, custom data identifiers, and managed data identifiers that are included (used) when
         *        analyzing data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(SensitivityInspectionTemplateIncludes includes);

        /**
         * <p>
         * The allow lists, custom data identifiers, and managed data identifiers that are included (used) when
         * analyzing data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SensitivityInspectionTemplateIncludes.Builder} avoiding the need to create one manually via
         * {@link SensitivityInspectionTemplateIncludes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SensitivityInspectionTemplateIncludes.Builder#build()} is called
         * immediately and its result is passed to {@link #includes(SensitivityInspectionTemplateIncludes)}.
         * 
         * @param includes
         *        a consumer that will call methods on {@link SensitivityInspectionTemplateIncludes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includes(SensitivityInspectionTemplateIncludes)
         */
        default Builder includes(Consumer<SensitivityInspectionTemplateIncludes.Builder> includes) {
            return includes(SensitivityInspectionTemplateIncludes.builder().applyMutation(includes).build());
        }

        /**
         * <p>
         * The name of the template: automated-sensitive-data-discovery.
         * </p>
         * 
         * @param name
         *        The name of the template: automated-sensitive-data-discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier for the template.
         * </p>
         * 
         * @param sensitivityInspectionTemplateId
         *        The unique identifier for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitivityInspectionTemplateId(String sensitivityInspectionTemplateId);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private String description;

        private SensitivityInspectionTemplateExcludes excludes;

        private SensitivityInspectionTemplateIncludes includes;

        private String name;

        private String sensitivityInspectionTemplateId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSensitivityInspectionTemplateResponse model) {
            super(model);
            description(model.description);
            excludes(model.excludes);
            includes(model.includes);
            name(model.name);
            sensitivityInspectionTemplateId(model.sensitivityInspectionTemplateId);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SensitivityInspectionTemplateExcludes.Builder getExcludes() {
            return excludes != null ? excludes.toBuilder() : null;
        }

        public final void setExcludes(SensitivityInspectionTemplateExcludes.BuilderImpl excludes) {
            this.excludes = excludes != null ? excludes.build() : null;
        }

        @Override
        public final Builder excludes(SensitivityInspectionTemplateExcludes excludes) {
            this.excludes = excludes;
            return this;
        }

        public final SensitivityInspectionTemplateIncludes.Builder getIncludes() {
            return includes != null ? includes.toBuilder() : null;
        }

        public final void setIncludes(SensitivityInspectionTemplateIncludes.BuilderImpl includes) {
            this.includes = includes != null ? includes.build() : null;
        }

        @Override
        public final Builder includes(SensitivityInspectionTemplateIncludes includes) {
            this.includes = includes;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSensitivityInspectionTemplateId() {
            return sensitivityInspectionTemplateId;
        }

        public final void setSensitivityInspectionTemplateId(String sensitivityInspectionTemplateId) {
            this.sensitivityInspectionTemplateId = sensitivityInspectionTemplateId;
        }

        @Override
        public final Builder sensitivityInspectionTemplateId(String sensitivityInspectionTemplateId) {
            this.sensitivityInspectionTemplateId = sensitivityInspectionTemplateId;
            return this;
        }

        @Override
        public GetSensitivityInspectionTemplateResponse build() {
            return new GetSensitivityInspectionTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
