/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * For a finding, the category of sensitive data that was detected and produced the finding. For a managed data
 * identifier, the category of sensitive data that the managed data identifier detects. Possible values are:
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum SensitiveDataItemCategory {
    FINANCIAL_INFORMATION("FINANCIAL_INFORMATION"),

    PERSONAL_INFORMATION("PERSONAL_INFORMATION"),

    CREDENTIALS("CREDENTIALS"),

    CUSTOM_IDENTIFIER("CUSTOM_IDENTIFIER"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SensitiveDataItemCategory> VALUE_MAP = EnumUtils.uniqueIndex(
            SensitiveDataItemCategory.class, SensitiveDataItemCategory::toString);

    private final String value;

    private SensitiveDataItemCategory(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return SensitiveDataItemCategory corresponding to the value
     */
    public static SensitiveDataItemCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link SensitiveDataItemCategory}s
     */
    public static Set<SensitiveDataItemCategory> knownValues() {
        Set<SensitiveDataItemCategory> knownValues = EnumSet.allOf(SensitiveDataItemCategory.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
