/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2AsyncClient;
import software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest;
import software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse;
import software.amazon.awssdk.services.macie2.model.UsageRecord;

public class GetUsageStatisticsPublisher
implements SdkPublisher<GetUsageStatisticsResponse> {
    private final Macie2AsyncClient client;
    private final GetUsageStatisticsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetUsageStatisticsPublisher(Macie2AsyncClient client, GetUsageStatisticsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetUsageStatisticsPublisher(Macie2AsyncClient client, GetUsageStatisticsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetUsageStatisticsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetUsageStatisticsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UsageRecord> records() {
        Function<GetUsageStatisticsResponse, Iterator> getIterator = response -> {
            if (response != null && response.records() != null) {
                return response.records().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetUsageStatisticsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetUsageStatisticsResponseFetcher
    implements AsyncPageFetcher<GetUsageStatisticsResponse> {
        private GetUsageStatisticsResponseFetcher() {
        }

        public boolean hasNextPage(GetUsageStatisticsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetUsageStatisticsResponse> nextPage(GetUsageStatisticsResponse previousPage) {
            if (previousPage == null) {
                return GetUsageStatisticsPublisher.this.client.getUsageStatistics(GetUsageStatisticsPublisher.this.firstRequest);
            }
            return GetUsageStatisticsPublisher.this.client.getUsageStatistics((GetUsageStatisticsRequest)((Object)GetUsageStatisticsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

