/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies property- and tag-based conditions that define criteria for including or excluding S3 buckets from a
 * classification job. Exclude conditions take precedence over include conditions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3BucketCriteriaForJob implements SdkPojo, Serializable,
        ToCopyableBuilder<S3BucketCriteriaForJob.Builder, S3BucketCriteriaForJob> {
    private static final SdkField<CriteriaBlockForJob> EXCLUDES_FIELD = SdkField
            .<CriteriaBlockForJob> builder(MarshallingType.SDK_POJO).memberName("excludes")
            .getter(getter(S3BucketCriteriaForJob::excludes)).setter(setter(Builder::excludes))
            .constructor(CriteriaBlockForJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludes").build()).build();

    private static final SdkField<CriteriaBlockForJob> INCLUDES_FIELD = SdkField
            .<CriteriaBlockForJob> builder(MarshallingType.SDK_POJO).memberName("includes")
            .getter(getter(S3BucketCriteriaForJob::includes)).setter(setter(Builder::includes))
            .constructor(CriteriaBlockForJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EXCLUDES_FIELD, INCLUDES_FIELD));

    private static final long serialVersionUID = 1L;

    private final CriteriaBlockForJob excludes;

    private final CriteriaBlockForJob includes;

    private S3BucketCriteriaForJob(BuilderImpl builder) {
        this.excludes = builder.excludes;
        this.includes = builder.includes;
    }

    /**
     * <p>
     * The property- and tag-based conditions that determine which buckets to exclude from the job.
     * </p>
     * 
     * @return The property- and tag-based conditions that determine which buckets to exclude from the job.
     */
    public final CriteriaBlockForJob excludes() {
        return excludes;
    }

    /**
     * <p>
     * The property- and tag-based conditions that determine which buckets to include in the job.
     * </p>
     * 
     * @return The property- and tag-based conditions that determine which buckets to include in the job.
     */
    public final CriteriaBlockForJob includes() {
        return includes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(excludes());
        hashCode = 31 * hashCode + Objects.hashCode(includes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketCriteriaForJob)) {
            return false;
        }
        S3BucketCriteriaForJob other = (S3BucketCriteriaForJob) obj;
        return Objects.equals(excludes(), other.excludes()) && Objects.equals(includes(), other.includes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3BucketCriteriaForJob").add("Excludes", excludes()).add("Includes", includes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "excludes":
            return Optional.ofNullable(clazz.cast(excludes()));
        case "includes":
            return Optional.ofNullable(clazz.cast(includes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3BucketCriteriaForJob, T> g) {
        return obj -> g.apply((S3BucketCriteriaForJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3BucketCriteriaForJob> {
        /**
         * <p>
         * The property- and tag-based conditions that determine which buckets to exclude from the job.
         * </p>
         * 
         * @param excludes
         *        The property- and tag-based conditions that determine which buckets to exclude from the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(CriteriaBlockForJob excludes);

        /**
         * <p>
         * The property- and tag-based conditions that determine which buckets to exclude from the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link CriteriaBlockForJob.Builder} avoiding the
         * need to create one manually via {@link CriteriaBlockForJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link CriteriaBlockForJob.Builder#build()} is called immediately and
         * its result is passed to {@link #excludes(CriteriaBlockForJob)}.
         * 
         * @param excludes
         *        a consumer that will call methods on {@link CriteriaBlockForJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludes(CriteriaBlockForJob)
         */
        default Builder excludes(Consumer<CriteriaBlockForJob.Builder> excludes) {
            return excludes(CriteriaBlockForJob.builder().applyMutation(excludes).build());
        }

        /**
         * <p>
         * The property- and tag-based conditions that determine which buckets to include in the job.
         * </p>
         * 
         * @param includes
         *        The property- and tag-based conditions that determine which buckets to include in the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(CriteriaBlockForJob includes);

        /**
         * <p>
         * The property- and tag-based conditions that determine which buckets to include in the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link CriteriaBlockForJob.Builder} avoiding the
         * need to create one manually via {@link CriteriaBlockForJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link CriteriaBlockForJob.Builder#build()} is called immediately and
         * its result is passed to {@link #includes(CriteriaBlockForJob)}.
         * 
         * @param includes
         *        a consumer that will call methods on {@link CriteriaBlockForJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includes(CriteriaBlockForJob)
         */
        default Builder includes(Consumer<CriteriaBlockForJob.Builder> includes) {
            return includes(CriteriaBlockForJob.builder().applyMutation(includes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CriteriaBlockForJob excludes;

        private CriteriaBlockForJob includes;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketCriteriaForJob model) {
            excludes(model.excludes);
            includes(model.includes);
        }

        public final CriteriaBlockForJob.Builder getExcludes() {
            return excludes != null ? excludes.toBuilder() : null;
        }

        public final void setExcludes(CriteriaBlockForJob.BuilderImpl excludes) {
            this.excludes = excludes != null ? excludes.build() : null;
        }

        @Override
        public final Builder excludes(CriteriaBlockForJob excludes) {
            this.excludes = excludes;
            return this;
        }

        public final CriteriaBlockForJob.Builder getIncludes() {
            return includes != null ? includes.toBuilder() : null;
        }

        public final void setIncludes(CriteriaBlockForJob.BuilderImpl includes) {
            this.includes = includes != null ? includes.build() : null;
        }

        @Override
        public final Builder includes(CriteriaBlockForJob includes) {
            this.includes = includes;
            return this;
        }

        @Override
        public S3BucketCriteriaForJob build() {
            return new S3BucketCriteriaForJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
