/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketStatisticsResponse extends Macie2Response implements
        ToCopyableBuilder<GetBucketStatisticsResponse.Builder, GetBucketStatisticsResponse> {
    private static final SdkField<Long> BUCKET_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("bucketCount").getter(getter(GetBucketStatisticsResponse::bucketCount))
            .setter(setter(Builder::bucketCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCount").build()).build();

    private static final SdkField<BucketCountByEffectivePermission> BUCKET_COUNT_BY_EFFECTIVE_PERMISSION_FIELD = SdkField
            .<BucketCountByEffectivePermission> builder(MarshallingType.SDK_POJO)
            .memberName("bucketCountByEffectivePermission")
            .getter(getter(GetBucketStatisticsResponse::bucketCountByEffectivePermission))
            .setter(setter(Builder::bucketCountByEffectivePermission))
            .constructor(BucketCountByEffectivePermission::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCountByEffectivePermission")
                    .build()).build();

    private static final SdkField<BucketCountByEncryptionType> BUCKET_COUNT_BY_ENCRYPTION_TYPE_FIELD = SdkField
            .<BucketCountByEncryptionType> builder(MarshallingType.SDK_POJO)
            .memberName("bucketCountByEncryptionType")
            .getter(getter(GetBucketStatisticsResponse::bucketCountByEncryptionType))
            .setter(setter(Builder::bucketCountByEncryptionType))
            .constructor(BucketCountByEncryptionType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCountByEncryptionType")
                    .build()).build();

    private static final SdkField<BucketCountPolicyAllowsUnencryptedObjectUploads> BUCKET_COUNT_BY_OBJECT_ENCRYPTION_REQUIREMENT_FIELD = SdkField
            .<BucketCountPolicyAllowsUnencryptedObjectUploads> builder(MarshallingType.SDK_POJO)
            .memberName("bucketCountByObjectEncryptionRequirement")
            .getter(getter(GetBucketStatisticsResponse::bucketCountByObjectEncryptionRequirement))
            .setter(setter(Builder::bucketCountByObjectEncryptionRequirement))
            .constructor(BucketCountPolicyAllowsUnencryptedObjectUploads::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("bucketCountByObjectEncryptionRequirement").build()).build();

    private static final SdkField<BucketCountBySharedAccessType> BUCKET_COUNT_BY_SHARED_ACCESS_TYPE_FIELD = SdkField
            .<BucketCountBySharedAccessType> builder(MarshallingType.SDK_POJO)
            .memberName("bucketCountBySharedAccessType")
            .getter(getter(GetBucketStatisticsResponse::bucketCountBySharedAccessType))
            .setter(setter(Builder::bucketCountBySharedAccessType))
            .constructor(BucketCountBySharedAccessType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCountBySharedAccessType")
                    .build()).build();

    private static final SdkField<Long> CLASSIFIABLE_OBJECT_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("classifiableObjectCount").getter(getter(GetBucketStatisticsResponse::classifiableObjectCount))
            .setter(setter(Builder::classifiableObjectCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classifiableObjectCount").build())
            .build();

    private static final SdkField<Long> CLASSIFIABLE_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("classifiableSizeInBytes").getter(getter(GetBucketStatisticsResponse::classifiableSizeInBytes))
            .setter(setter(Builder::classifiableSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classifiableSizeInBytes").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdated")
            .getter(getter(GetBucketStatisticsResponse::lastUpdated))
            .setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Long> OBJECT_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("objectCount").getter(getter(GetBucketStatisticsResponse::objectCount))
            .setter(setter(Builder::objectCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectCount").build()).build();

    private static final SdkField<Long> SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("sizeInBytes").getter(getter(GetBucketStatisticsResponse::sizeInBytes))
            .setter(setter(Builder::sizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInBytes").build()).build();

    private static final SdkField<Long> SIZE_IN_BYTES_COMPRESSED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("sizeInBytesCompressed").getter(getter(GetBucketStatisticsResponse::sizeInBytesCompressed))
            .setter(setter(Builder::sizeInBytesCompressed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInBytesCompressed").build())
            .build();

    private static final SdkField<ObjectLevelStatistics> UNCLASSIFIABLE_OBJECT_COUNT_FIELD = SdkField
            .<ObjectLevelStatistics> builder(MarshallingType.SDK_POJO).memberName("unclassifiableObjectCount")
            .getter(getter(GetBucketStatisticsResponse::unclassifiableObjectCount))
            .setter(setter(Builder::unclassifiableObjectCount)).constructor(ObjectLevelStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unclassifiableObjectCount").build())
            .build();

    private static final SdkField<ObjectLevelStatistics> UNCLASSIFIABLE_OBJECT_SIZE_IN_BYTES_FIELD = SdkField
            .<ObjectLevelStatistics> builder(MarshallingType.SDK_POJO)
            .memberName("unclassifiableObjectSizeInBytes")
            .getter(getter(GetBucketStatisticsResponse::unclassifiableObjectSizeInBytes))
            .setter(setter(Builder::unclassifiableObjectSizeInBytes))
            .constructor(ObjectLevelStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unclassifiableObjectSizeInBytes")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_COUNT_FIELD,
            BUCKET_COUNT_BY_EFFECTIVE_PERMISSION_FIELD, BUCKET_COUNT_BY_ENCRYPTION_TYPE_FIELD,
            BUCKET_COUNT_BY_OBJECT_ENCRYPTION_REQUIREMENT_FIELD, BUCKET_COUNT_BY_SHARED_ACCESS_TYPE_FIELD,
            CLASSIFIABLE_OBJECT_COUNT_FIELD, CLASSIFIABLE_SIZE_IN_BYTES_FIELD, LAST_UPDATED_FIELD, OBJECT_COUNT_FIELD,
            SIZE_IN_BYTES_FIELD, SIZE_IN_BYTES_COMPRESSED_FIELD, UNCLASSIFIABLE_OBJECT_COUNT_FIELD,
            UNCLASSIFIABLE_OBJECT_SIZE_IN_BYTES_FIELD));

    private final Long bucketCount;

    private final BucketCountByEffectivePermission bucketCountByEffectivePermission;

    private final BucketCountByEncryptionType bucketCountByEncryptionType;

    private final BucketCountPolicyAllowsUnencryptedObjectUploads bucketCountByObjectEncryptionRequirement;

    private final BucketCountBySharedAccessType bucketCountBySharedAccessType;

    private final Long classifiableObjectCount;

    private final Long classifiableSizeInBytes;

    private final Instant lastUpdated;

    private final Long objectCount;

    private final Long sizeInBytes;

    private final Long sizeInBytesCompressed;

    private final ObjectLevelStatistics unclassifiableObjectCount;

    private final ObjectLevelStatistics unclassifiableObjectSizeInBytes;

    private GetBucketStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.bucketCount = builder.bucketCount;
        this.bucketCountByEffectivePermission = builder.bucketCountByEffectivePermission;
        this.bucketCountByEncryptionType = builder.bucketCountByEncryptionType;
        this.bucketCountByObjectEncryptionRequirement = builder.bucketCountByObjectEncryptionRequirement;
        this.bucketCountBySharedAccessType = builder.bucketCountBySharedAccessType;
        this.classifiableObjectCount = builder.classifiableObjectCount;
        this.classifiableSizeInBytes = builder.classifiableSizeInBytes;
        this.lastUpdated = builder.lastUpdated;
        this.objectCount = builder.objectCount;
        this.sizeInBytes = builder.sizeInBytes;
        this.sizeInBytesCompressed = builder.sizeInBytesCompressed;
        this.unclassifiableObjectCount = builder.unclassifiableObjectCount;
        this.unclassifiableObjectSizeInBytes = builder.unclassifiableObjectSizeInBytes;
    }

    /**
     * <p>
     * The total number of buckets.
     * </p>
     * 
     * @return The total number of buckets.
     */
    public final Long bucketCount() {
        return bucketCount;
    }

    /**
     * <p>
     * The total number of buckets that are publicly accessible based on a combination of permissions settings for each
     * bucket.
     * </p>
     * 
     * @return The total number of buckets that are publicly accessible based on a combination of permissions settings
     *         for each bucket.
     */
    public final BucketCountByEffectivePermission bucketCountByEffectivePermission() {
        return bucketCountByEffectivePermission;
    }

    /**
     * <p>
     * The total number of buckets that use certain types of server-side encryption to encrypt new objects by default.
     * This object also reports the total number of buckets that don't encrypt new objects by default.
     * </p>
     * 
     * @return The total number of buckets that use certain types of server-side encryption to encrypt new objects by
     *         default. This object also reports the total number of buckets that don't encrypt new objects by default.
     */
    public final BucketCountByEncryptionType bucketCountByEncryptionType() {
        return bucketCountByEncryptionType;
    }

    /**
     * <p>
     * The total number of buckets whose bucket policies do or don't require server-side encryption of objects when
     * objects are uploaded to the buckets.
     * </p>
     * 
     * @return The total number of buckets whose bucket policies do or don't require server-side encryption of objects
     *         when objects are uploaded to the buckets.
     */
    public final BucketCountPolicyAllowsUnencryptedObjectUploads bucketCountByObjectEncryptionRequirement() {
        return bucketCountByObjectEncryptionRequirement;
    }

    /**
     * <p>
     * The total number of buckets that are or aren't shared with another Amazon Web Services account.
     * </p>
     * 
     * @return The total number of buckets that are or aren't shared with another Amazon Web Services account.
     */
    public final BucketCountBySharedAccessType bucketCountBySharedAccessType() {
        return bucketCountBySharedAccessType;
    }

    /**
     * <p>
     * The total number of objects that Amazon Macie can analyze in the buckets. These objects use a supported storage
     * class and have a file name extension for a supported file or storage format.
     * </p>
     * 
     * @return The total number of objects that Amazon Macie can analyze in the buckets. These objects use a supported
     *         storage class and have a file name extension for a supported file or storage format.
     */
    public final Long classifiableObjectCount() {
        return classifiableObjectCount;
    }

    /**
     * <p>
     * The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets. These objects
     * use a supported storage class and have a file name extension for a supported file or storage format.
     * </p>
     * <p>
     * If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the latest
     * version of each applicable object in those buckets. This value doesn't reflect the storage size of all versions
     * of all applicable objects in the buckets.
     * </p>
     * 
     * @return The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets. These
     *         objects use a supported storage class and have a file name extension for a supported file or storage
     *         format.</p>
     *         <p>
     *         If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the
     *         latest version of each applicable object in those buckets. This value doesn't reflect the storage size of
     *         all versions of all applicable objects in the buckets.
     */
    public final Long classifiableSizeInBytes() {
        return classifiableSizeInBytes;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and
     * object metadata from Amazon S3 for the buckets.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both
     *         bucket and object metadata from Amazon S3 for the buckets.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The total number of objects in the buckets.
     * </p>
     * 
     * @return The total number of objects in the buckets.
     */
    public final Long objectCount() {
        return objectCount;
    }

    /**
     * <p>
     * The total storage size, in bytes, of the buckets.
     * </p>
     * <p>
     * If versioning is enabled for any of the buckets, Amazon Macie calculates this value based on the size of the
     * latest version of each object in those buckets. This value doesn't reflect the storage size of all versions of
     * the objects in the buckets.
     * </p>
     * 
     * @return The total storage size, in bytes, of the buckets.</p>
     *         <p>
     *         If versioning is enabled for any of the buckets, Amazon Macie calculates this value based on the size of
     *         the latest version of each object in those buckets. This value doesn't reflect the storage size of all
     *         versions of the objects in the buckets.
     */
    public final Long sizeInBytes() {
        return sizeInBytes;
    }

    /**
     * <p>
     * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the buckets.
     * </p>
     * <p>
     * If versioning is enabled for any of the buckets, Amazon Macie calculates this value based on the size of the
     * latest version of each applicable object in those buckets. This value doesn't reflect the storage size of all
     * versions of the applicable objects in the buckets.
     * </p>
     * 
     * @return The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the
     *         buckets.</p>
     *         <p>
     *         If versioning is enabled for any of the buckets, Amazon Macie calculates this value based on the size of
     *         the latest version of each applicable object in those buckets. This value doesn't reflect the storage
     *         size of all versions of the applicable objects in the buckets.
     */
    public final Long sizeInBytesCompressed() {
        return sizeInBytesCompressed;
    }

    /**
     * <p>
     * The total number of objects that Amazon Macie can't analyze in the buckets. These objects don't use a supported
     * storage class or don't have a file name extension for a supported file or storage format.
     * </p>
     * 
     * @return The total number of objects that Amazon Macie can't analyze in the buckets. These objects don't use a
     *         supported storage class or don't have a file name extension for a supported file or storage format.
     */
    public final ObjectLevelStatistics unclassifiableObjectCount() {
        return unclassifiableObjectCount;
    }

    /**
     * <p>
     * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the buckets. These objects
     * don't use a supported storage class or don't have a file name extension for a supported file or storage format.
     * </p>
     * 
     * @return The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the buckets. These
     *         objects don't use a supported storage class or don't have a file name extension for a supported file or
     *         storage format.
     */
    public final ObjectLevelStatistics unclassifiableObjectSizeInBytes() {
        return unclassifiableObjectSizeInBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bucketCount());
        hashCode = 31 * hashCode + Objects.hashCode(bucketCountByEffectivePermission());
        hashCode = 31 * hashCode + Objects.hashCode(bucketCountByEncryptionType());
        hashCode = 31 * hashCode + Objects.hashCode(bucketCountByObjectEncryptionRequirement());
        hashCode = 31 * hashCode + Objects.hashCode(bucketCountBySharedAccessType());
        hashCode = 31 * hashCode + Objects.hashCode(classifiableObjectCount());
        hashCode = 31 * hashCode + Objects.hashCode(classifiableSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(objectCount());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInBytesCompressed());
        hashCode = 31 * hashCode + Objects.hashCode(unclassifiableObjectCount());
        hashCode = 31 * hashCode + Objects.hashCode(unclassifiableObjectSizeInBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketStatisticsResponse)) {
            return false;
        }
        GetBucketStatisticsResponse other = (GetBucketStatisticsResponse) obj;
        return Objects.equals(bucketCount(), other.bucketCount())
                && Objects.equals(bucketCountByEffectivePermission(), other.bucketCountByEffectivePermission())
                && Objects.equals(bucketCountByEncryptionType(), other.bucketCountByEncryptionType())
                && Objects.equals(bucketCountByObjectEncryptionRequirement(), other.bucketCountByObjectEncryptionRequirement())
                && Objects.equals(bucketCountBySharedAccessType(), other.bucketCountBySharedAccessType())
                && Objects.equals(classifiableObjectCount(), other.classifiableObjectCount())
                && Objects.equals(classifiableSizeInBytes(), other.classifiableSizeInBytes())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(objectCount(), other.objectCount())
                && Objects.equals(sizeInBytes(), other.sizeInBytes())
                && Objects.equals(sizeInBytesCompressed(), other.sizeInBytesCompressed())
                && Objects.equals(unclassifiableObjectCount(), other.unclassifiableObjectCount())
                && Objects.equals(unclassifiableObjectSizeInBytes(), other.unclassifiableObjectSizeInBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBucketStatisticsResponse").add("BucketCount", bucketCount())
                .add("BucketCountByEffectivePermission", bucketCountByEffectivePermission())
                .add("BucketCountByEncryptionType", bucketCountByEncryptionType())
                .add("BucketCountByObjectEncryptionRequirement", bucketCountByObjectEncryptionRequirement())
                .add("BucketCountBySharedAccessType", bucketCountBySharedAccessType())
                .add("ClassifiableObjectCount", classifiableObjectCount())
                .add("ClassifiableSizeInBytes", classifiableSizeInBytes()).add("LastUpdated", lastUpdated())
                .add("ObjectCount", objectCount()).add("SizeInBytes", sizeInBytes())
                .add("SizeInBytesCompressed", sizeInBytesCompressed())
                .add("UnclassifiableObjectCount", unclassifiableObjectCount())
                .add("UnclassifiableObjectSizeInBytes", unclassifiableObjectSizeInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketCount":
            return Optional.ofNullable(clazz.cast(bucketCount()));
        case "bucketCountByEffectivePermission":
            return Optional.ofNullable(clazz.cast(bucketCountByEffectivePermission()));
        case "bucketCountByEncryptionType":
            return Optional.ofNullable(clazz.cast(bucketCountByEncryptionType()));
        case "bucketCountByObjectEncryptionRequirement":
            return Optional.ofNullable(clazz.cast(bucketCountByObjectEncryptionRequirement()));
        case "bucketCountBySharedAccessType":
            return Optional.ofNullable(clazz.cast(bucketCountBySharedAccessType()));
        case "classifiableObjectCount":
            return Optional.ofNullable(clazz.cast(classifiableObjectCount()));
        case "classifiableSizeInBytes":
            return Optional.ofNullable(clazz.cast(classifiableSizeInBytes()));
        case "lastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "objectCount":
            return Optional.ofNullable(clazz.cast(objectCount()));
        case "sizeInBytes":
            return Optional.ofNullable(clazz.cast(sizeInBytes()));
        case "sizeInBytesCompressed":
            return Optional.ofNullable(clazz.cast(sizeInBytesCompressed()));
        case "unclassifiableObjectCount":
            return Optional.ofNullable(clazz.cast(unclassifiableObjectCount()));
        case "unclassifiableObjectSizeInBytes":
            return Optional.ofNullable(clazz.cast(unclassifiableObjectSizeInBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketStatisticsResponse, T> g) {
        return obj -> g.apply((GetBucketStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetBucketStatisticsResponse> {
        /**
         * <p>
         * The total number of buckets.
         * </p>
         * 
         * @param bucketCount
         *        The total number of buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketCount(Long bucketCount);

        /**
         * <p>
         * The total number of buckets that are publicly accessible based on a combination of permissions settings for
         * each bucket.
         * </p>
         * 
         * @param bucketCountByEffectivePermission
         *        The total number of buckets that are publicly accessible based on a combination of permissions
         *        settings for each bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketCountByEffectivePermission(BucketCountByEffectivePermission bucketCountByEffectivePermission);

        /**
         * <p>
         * The total number of buckets that are publicly accessible based on a combination of permissions settings for
         * each bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link BucketCountByEffectivePermission.Builder}
         * avoiding the need to create one manually via {@link BucketCountByEffectivePermission#builder()}.
         *
         * When the {@link Consumer} completes, {@link BucketCountByEffectivePermission.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #bucketCountByEffectivePermission(BucketCountByEffectivePermission)}.
         * 
         * @param bucketCountByEffectivePermission
         *        a consumer that will call methods on {@link BucketCountByEffectivePermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketCountByEffectivePermission(BucketCountByEffectivePermission)
         */
        default Builder bucketCountByEffectivePermission(
                Consumer<BucketCountByEffectivePermission.Builder> bucketCountByEffectivePermission) {
            return bucketCountByEffectivePermission(BucketCountByEffectivePermission.builder()
                    .applyMutation(bucketCountByEffectivePermission).build());
        }

        /**
         * <p>
         * The total number of buckets that use certain types of server-side encryption to encrypt new objects by
         * default. This object also reports the total number of buckets that don't encrypt new objects by default.
         * </p>
         * 
         * @param bucketCountByEncryptionType
         *        The total number of buckets that use certain types of server-side encryption to encrypt new objects by
         *        default. This object also reports the total number of buckets that don't encrypt new objects by
         *        default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketCountByEncryptionType(BucketCountByEncryptionType bucketCountByEncryptionType);

        /**
         * <p>
         * The total number of buckets that use certain types of server-side encryption to encrypt new objects by
         * default. This object also reports the total number of buckets that don't encrypt new objects by default.
         * </p>
         * This is a convenience method that creates an instance of the {@link BucketCountByEncryptionType.Builder}
         * avoiding the need to create one manually via {@link BucketCountByEncryptionType#builder()}.
         *
         * When the {@link Consumer} completes, {@link BucketCountByEncryptionType.Builder#build()} is called
         * immediately and its result is passed to {@link #bucketCountByEncryptionType(BucketCountByEncryptionType)}.
         * 
         * @param bucketCountByEncryptionType
         *        a consumer that will call methods on {@link BucketCountByEncryptionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketCountByEncryptionType(BucketCountByEncryptionType)
         */
        default Builder bucketCountByEncryptionType(Consumer<BucketCountByEncryptionType.Builder> bucketCountByEncryptionType) {
            return bucketCountByEncryptionType(BucketCountByEncryptionType.builder().applyMutation(bucketCountByEncryptionType)
                    .build());
        }

        /**
         * <p>
         * The total number of buckets whose bucket policies do or don't require server-side encryption of objects when
         * objects are uploaded to the buckets.
         * </p>
         * 
         * @param bucketCountByObjectEncryptionRequirement
         *        The total number of buckets whose bucket policies do or don't require server-side encryption of
         *        objects when objects are uploaded to the buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketCountByObjectEncryptionRequirement(
                BucketCountPolicyAllowsUnencryptedObjectUploads bucketCountByObjectEncryptionRequirement);

        /**
         * <p>
         * The total number of buckets whose bucket policies do or don't require server-side encryption of objects when
         * objects are uploaded to the buckets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BucketCountPolicyAllowsUnencryptedObjectUploads.Builder} avoiding the need to create one manually via
         * {@link BucketCountPolicyAllowsUnencryptedObjectUploads#builder()}.
         *
         * When the {@link Consumer} completes, {@link BucketCountPolicyAllowsUnencryptedObjectUploads.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #bucketCountByObjectEncryptionRequirement(BucketCountPolicyAllowsUnencryptedObjectUploads)}.
         * 
         * @param bucketCountByObjectEncryptionRequirement
         *        a consumer that will call methods on {@link BucketCountPolicyAllowsUnencryptedObjectUploads.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketCountByObjectEncryptionRequirement(BucketCountPolicyAllowsUnencryptedObjectUploads)
         */
        default Builder bucketCountByObjectEncryptionRequirement(
                Consumer<BucketCountPolicyAllowsUnencryptedObjectUploads.Builder> bucketCountByObjectEncryptionRequirement) {
            return bucketCountByObjectEncryptionRequirement(BucketCountPolicyAllowsUnencryptedObjectUploads.builder()
                    .applyMutation(bucketCountByObjectEncryptionRequirement).build());
        }

        /**
         * <p>
         * The total number of buckets that are or aren't shared with another Amazon Web Services account.
         * </p>
         * 
         * @param bucketCountBySharedAccessType
         *        The total number of buckets that are or aren't shared with another Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketCountBySharedAccessType(BucketCountBySharedAccessType bucketCountBySharedAccessType);

        /**
         * <p>
         * The total number of buckets that are or aren't shared with another Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the {@link BucketCountBySharedAccessType.Builder}
         * avoiding the need to create one manually via {@link BucketCountBySharedAccessType#builder()}.
         *
         * When the {@link Consumer} completes, {@link BucketCountBySharedAccessType.Builder#build()} is called
         * immediately and its result is passed to {@link #bucketCountBySharedAccessType(BucketCountBySharedAccessType)}
         * .
         * 
         * @param bucketCountBySharedAccessType
         *        a consumer that will call methods on {@link BucketCountBySharedAccessType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketCountBySharedAccessType(BucketCountBySharedAccessType)
         */
        default Builder bucketCountBySharedAccessType(
                Consumer<BucketCountBySharedAccessType.Builder> bucketCountBySharedAccessType) {
            return bucketCountBySharedAccessType(BucketCountBySharedAccessType.builder()
                    .applyMutation(bucketCountBySharedAccessType).build());
        }

        /**
         * <p>
         * The total number of objects that Amazon Macie can analyze in the buckets. These objects use a supported
         * storage class and have a file name extension for a supported file or storage format.
         * </p>
         * 
         * @param classifiableObjectCount
         *        The total number of objects that Amazon Macie can analyze in the buckets. These objects use a
         *        supported storage class and have a file name extension for a supported file or storage format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classifiableObjectCount(Long classifiableObjectCount);

        /**
         * <p>
         * The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets. These
         * objects use a supported storage class and have a file name extension for a supported file or storage format.
         * </p>
         * <p>
         * If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the latest
         * version of each applicable object in those buckets. This value doesn't reflect the storage size of all
         * versions of all applicable objects in the buckets.
         * </p>
         * 
         * @param classifiableSizeInBytes
         *        The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets.
         *        These objects use a supported storage class and have a file name extension for a supported file or
         *        storage format.</p>
         *        <p>
         *        If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the
         *        latest version of each applicable object in those buckets. This value doesn't reflect the storage size
         *        of all versions of all applicable objects in the buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classifiableSizeInBytes(Long classifiableSizeInBytes);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket
         * and object metadata from Amazon S3 for the buckets.
         * </p>
         * 
         * @param lastUpdated
         *        The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both
         *        bucket and object metadata from Amazon S3 for the buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The total number of objects in the buckets.
         * </p>
         * 
         * @param objectCount
         *        The total number of objects in the buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectCount(Long objectCount);

        /**
         * <p>
         * The total storage size, in bytes, of the buckets.
         * </p>
         * <p>
         * If versioning is enabled for any of the buckets, Amazon Macie calculates this value based on the size of the
         * latest version of each object in those buckets. This value doesn't reflect the storage size of all versions
         * of the objects in the buckets.
         * </p>
         * 
         * @param sizeInBytes
         *        The total storage size, in bytes, of the buckets.</p>
         *        <p>
         *        If versioning is enabled for any of the buckets, Amazon Macie calculates this value based on the size
         *        of the latest version of each object in those buckets. This value doesn't reflect the storage size of
         *        all versions of the objects in the buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInBytes(Long sizeInBytes);

        /**
         * <p>
         * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the buckets.
         * </p>
         * <p>
         * If versioning is enabled for any of the buckets, Amazon Macie calculates this value based on the size of the
         * latest version of each applicable object in those buckets. This value doesn't reflect the storage size of all
         * versions of the applicable objects in the buckets.
         * </p>
         * 
         * @param sizeInBytesCompressed
         *        The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the
         *        buckets.</p>
         *        <p>
         *        If versioning is enabled for any of the buckets, Amazon Macie calculates this value based on the size
         *        of the latest version of each applicable object in those buckets. This value doesn't reflect the
         *        storage size of all versions of the applicable objects in the buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInBytesCompressed(Long sizeInBytesCompressed);

        /**
         * <p>
         * The total number of objects that Amazon Macie can't analyze in the buckets. These objects don't use a
         * supported storage class or don't have a file name extension for a supported file or storage format.
         * </p>
         * 
         * @param unclassifiableObjectCount
         *        The total number of objects that Amazon Macie can't analyze in the buckets. These objects don't use a
         *        supported storage class or don't have a file name extension for a supported file or storage format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unclassifiableObjectCount(ObjectLevelStatistics unclassifiableObjectCount);

        /**
         * <p>
         * The total number of objects that Amazon Macie can't analyze in the buckets. These objects don't use a
         * supported storage class or don't have a file name extension for a supported file or storage format.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectLevelStatistics.Builder} avoiding
         * the need to create one manually via {@link ObjectLevelStatistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectLevelStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #unclassifiableObjectCount(ObjectLevelStatistics)}.
         * 
         * @param unclassifiableObjectCount
         *        a consumer that will call methods on {@link ObjectLevelStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unclassifiableObjectCount(ObjectLevelStatistics)
         */
        default Builder unclassifiableObjectCount(Consumer<ObjectLevelStatistics.Builder> unclassifiableObjectCount) {
            return unclassifiableObjectCount(ObjectLevelStatistics.builder().applyMutation(unclassifiableObjectCount).build());
        }

        /**
         * <p>
         * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the buckets. These
         * objects don't use a supported storage class or don't have a file name extension for a supported file or
         * storage format.
         * </p>
         * 
         * @param unclassifiableObjectSizeInBytes
         *        The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the buckets. These
         *        objects don't use a supported storage class or don't have a file name extension for a supported file
         *        or storage format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unclassifiableObjectSizeInBytes(ObjectLevelStatistics unclassifiableObjectSizeInBytes);

        /**
         * <p>
         * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the buckets. These
         * objects don't use a supported storage class or don't have a file name extension for a supported file or
         * storage format.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectLevelStatistics.Builder} avoiding
         * the need to create one manually via {@link ObjectLevelStatistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectLevelStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #unclassifiableObjectSizeInBytes(ObjectLevelStatistics)}.
         * 
         * @param unclassifiableObjectSizeInBytes
         *        a consumer that will call methods on {@link ObjectLevelStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unclassifiableObjectSizeInBytes(ObjectLevelStatistics)
         */
        default Builder unclassifiableObjectSizeInBytes(Consumer<ObjectLevelStatistics.Builder> unclassifiableObjectSizeInBytes) {
            return unclassifiableObjectSizeInBytes(ObjectLevelStatistics.builder().applyMutation(unclassifiableObjectSizeInBytes)
                    .build());
        }
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private Long bucketCount;

        private BucketCountByEffectivePermission bucketCountByEffectivePermission;

        private BucketCountByEncryptionType bucketCountByEncryptionType;

        private BucketCountPolicyAllowsUnencryptedObjectUploads bucketCountByObjectEncryptionRequirement;

        private BucketCountBySharedAccessType bucketCountBySharedAccessType;

        private Long classifiableObjectCount;

        private Long classifiableSizeInBytes;

        private Instant lastUpdated;

        private Long objectCount;

        private Long sizeInBytes;

        private Long sizeInBytesCompressed;

        private ObjectLevelStatistics unclassifiableObjectCount;

        private ObjectLevelStatistics unclassifiableObjectSizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketStatisticsResponse model) {
            super(model);
            bucketCount(model.bucketCount);
            bucketCountByEffectivePermission(model.bucketCountByEffectivePermission);
            bucketCountByEncryptionType(model.bucketCountByEncryptionType);
            bucketCountByObjectEncryptionRequirement(model.bucketCountByObjectEncryptionRequirement);
            bucketCountBySharedAccessType(model.bucketCountBySharedAccessType);
            classifiableObjectCount(model.classifiableObjectCount);
            classifiableSizeInBytes(model.classifiableSizeInBytes);
            lastUpdated(model.lastUpdated);
            objectCount(model.objectCount);
            sizeInBytes(model.sizeInBytes);
            sizeInBytesCompressed(model.sizeInBytesCompressed);
            unclassifiableObjectCount(model.unclassifiableObjectCount);
            unclassifiableObjectSizeInBytes(model.unclassifiableObjectSizeInBytes);
        }

        public final Long getBucketCount() {
            return bucketCount;
        }

        public final void setBucketCount(Long bucketCount) {
            this.bucketCount = bucketCount;
        }

        @Override
        public final Builder bucketCount(Long bucketCount) {
            this.bucketCount = bucketCount;
            return this;
        }

        public final BucketCountByEffectivePermission.Builder getBucketCountByEffectivePermission() {
            return bucketCountByEffectivePermission != null ? bucketCountByEffectivePermission.toBuilder() : null;
        }

        public final void setBucketCountByEffectivePermission(
                BucketCountByEffectivePermission.BuilderImpl bucketCountByEffectivePermission) {
            this.bucketCountByEffectivePermission = bucketCountByEffectivePermission != null ? bucketCountByEffectivePermission
                    .build() : null;
        }

        @Override
        public final Builder bucketCountByEffectivePermission(BucketCountByEffectivePermission bucketCountByEffectivePermission) {
            this.bucketCountByEffectivePermission = bucketCountByEffectivePermission;
            return this;
        }

        public final BucketCountByEncryptionType.Builder getBucketCountByEncryptionType() {
            return bucketCountByEncryptionType != null ? bucketCountByEncryptionType.toBuilder() : null;
        }

        public final void setBucketCountByEncryptionType(BucketCountByEncryptionType.BuilderImpl bucketCountByEncryptionType) {
            this.bucketCountByEncryptionType = bucketCountByEncryptionType != null ? bucketCountByEncryptionType.build() : null;
        }

        @Override
        public final Builder bucketCountByEncryptionType(BucketCountByEncryptionType bucketCountByEncryptionType) {
            this.bucketCountByEncryptionType = bucketCountByEncryptionType;
            return this;
        }

        public final BucketCountPolicyAllowsUnencryptedObjectUploads.Builder getBucketCountByObjectEncryptionRequirement() {
            return bucketCountByObjectEncryptionRequirement != null ? bucketCountByObjectEncryptionRequirement.toBuilder() : null;
        }

        public final void setBucketCountByObjectEncryptionRequirement(
                BucketCountPolicyAllowsUnencryptedObjectUploads.BuilderImpl bucketCountByObjectEncryptionRequirement) {
            this.bucketCountByObjectEncryptionRequirement = bucketCountByObjectEncryptionRequirement != null ? bucketCountByObjectEncryptionRequirement
                    .build() : null;
        }

        @Override
        public final Builder bucketCountByObjectEncryptionRequirement(
                BucketCountPolicyAllowsUnencryptedObjectUploads bucketCountByObjectEncryptionRequirement) {
            this.bucketCountByObjectEncryptionRequirement = bucketCountByObjectEncryptionRequirement;
            return this;
        }

        public final BucketCountBySharedAccessType.Builder getBucketCountBySharedAccessType() {
            return bucketCountBySharedAccessType != null ? bucketCountBySharedAccessType.toBuilder() : null;
        }

        public final void setBucketCountBySharedAccessType(BucketCountBySharedAccessType.BuilderImpl bucketCountBySharedAccessType) {
            this.bucketCountBySharedAccessType = bucketCountBySharedAccessType != null ? bucketCountBySharedAccessType.build()
                    : null;
        }

        @Override
        public final Builder bucketCountBySharedAccessType(BucketCountBySharedAccessType bucketCountBySharedAccessType) {
            this.bucketCountBySharedAccessType = bucketCountBySharedAccessType;
            return this;
        }

        public final Long getClassifiableObjectCount() {
            return classifiableObjectCount;
        }

        public final void setClassifiableObjectCount(Long classifiableObjectCount) {
            this.classifiableObjectCount = classifiableObjectCount;
        }

        @Override
        public final Builder classifiableObjectCount(Long classifiableObjectCount) {
            this.classifiableObjectCount = classifiableObjectCount;
            return this;
        }

        public final Long getClassifiableSizeInBytes() {
            return classifiableSizeInBytes;
        }

        public final void setClassifiableSizeInBytes(Long classifiableSizeInBytes) {
            this.classifiableSizeInBytes = classifiableSizeInBytes;
        }

        @Override
        public final Builder classifiableSizeInBytes(Long classifiableSizeInBytes) {
            this.classifiableSizeInBytes = classifiableSizeInBytes;
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final Long getObjectCount() {
            return objectCount;
        }

        public final void setObjectCount(Long objectCount) {
            this.objectCount = objectCount;
        }

        @Override
        public final Builder objectCount(Long objectCount) {
            this.objectCount = objectCount;
            return this;
        }

        public final Long getSizeInBytes() {
            return sizeInBytes;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final Long getSizeInBytesCompressed() {
            return sizeInBytesCompressed;
        }

        public final void setSizeInBytesCompressed(Long sizeInBytesCompressed) {
            this.sizeInBytesCompressed = sizeInBytesCompressed;
        }

        @Override
        public final Builder sizeInBytesCompressed(Long sizeInBytesCompressed) {
            this.sizeInBytesCompressed = sizeInBytesCompressed;
            return this;
        }

        public final ObjectLevelStatistics.Builder getUnclassifiableObjectCount() {
            return unclassifiableObjectCount != null ? unclassifiableObjectCount.toBuilder() : null;
        }

        public final void setUnclassifiableObjectCount(ObjectLevelStatistics.BuilderImpl unclassifiableObjectCount) {
            this.unclassifiableObjectCount = unclassifiableObjectCount != null ? unclassifiableObjectCount.build() : null;
        }

        @Override
        public final Builder unclassifiableObjectCount(ObjectLevelStatistics unclassifiableObjectCount) {
            this.unclassifiableObjectCount = unclassifiableObjectCount;
            return this;
        }

        public final ObjectLevelStatistics.Builder getUnclassifiableObjectSizeInBytes() {
            return unclassifiableObjectSizeInBytes != null ? unclassifiableObjectSizeInBytes.toBuilder() : null;
        }

        public final void setUnclassifiableObjectSizeInBytes(ObjectLevelStatistics.BuilderImpl unclassifiableObjectSizeInBytes) {
            this.unclassifiableObjectSizeInBytes = unclassifiableObjectSizeInBytes != null ? unclassifiableObjectSizeInBytes
                    .build() : null;
        }

        @Override
        public final Builder unclassifiableObjectSizeInBytes(ObjectLevelStatistics unclassifiableObjectSizeInBytes) {
            this.unclassifiableObjectSizeInBytes = unclassifiableObjectSizeInBytes;
            return this;
        }

        @Override
        public GetBucketStatisticsResponse build() {
            return new GetBucketStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
