/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the account-level and bucket-level permissions settings for an S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketPermissionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BucketPermissionConfiguration.Builder, BucketPermissionConfiguration> {
    private static final SdkField<AccountLevelPermissions> ACCOUNT_LEVEL_PERMISSIONS_FIELD = SdkField
            .<AccountLevelPermissions> builder(MarshallingType.SDK_POJO).memberName("accountLevelPermissions")
            .getter(getter(BucketPermissionConfiguration::accountLevelPermissions))
            .setter(setter(Builder::accountLevelPermissions)).constructor(AccountLevelPermissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountLevelPermissions").build())
            .build();

    private static final SdkField<BucketLevelPermissions> BUCKET_LEVEL_PERMISSIONS_FIELD = SdkField
            .<BucketLevelPermissions> builder(MarshallingType.SDK_POJO).memberName("bucketLevelPermissions")
            .getter(getter(BucketPermissionConfiguration::bucketLevelPermissions))
            .setter(setter(Builder::bucketLevelPermissions)).constructor(BucketLevelPermissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketLevelPermissions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACCOUNT_LEVEL_PERMISSIONS_FIELD, BUCKET_LEVEL_PERMISSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AccountLevelPermissions accountLevelPermissions;

    private final BucketLevelPermissions bucketLevelPermissions;

    private BucketPermissionConfiguration(BuilderImpl builder) {
        this.accountLevelPermissions = builder.accountLevelPermissions;
        this.bucketLevelPermissions = builder.bucketLevelPermissions;
    }

    /**
     * <p>
     * The account-level permissions settings that apply to the bucket.
     * </p>
     * 
     * @return The account-level permissions settings that apply to the bucket.
     */
    public final AccountLevelPermissions accountLevelPermissions() {
        return accountLevelPermissions;
    }

    /**
     * <p>
     * The bucket-level permissions settings for the bucket.
     * </p>
     * 
     * @return The bucket-level permissions settings for the bucket.
     */
    public final BucketLevelPermissions bucketLevelPermissions() {
        return bucketLevelPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountLevelPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(bucketLevelPermissions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketPermissionConfiguration)) {
            return false;
        }
        BucketPermissionConfiguration other = (BucketPermissionConfiguration) obj;
        return Objects.equals(accountLevelPermissions(), other.accountLevelPermissions())
                && Objects.equals(bucketLevelPermissions(), other.bucketLevelPermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketPermissionConfiguration").add("AccountLevelPermissions", accountLevelPermissions())
                .add("BucketLevelPermissions", bucketLevelPermissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountLevelPermissions":
            return Optional.ofNullable(clazz.cast(accountLevelPermissions()));
        case "bucketLevelPermissions":
            return Optional.ofNullable(clazz.cast(bucketLevelPermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketPermissionConfiguration, T> g) {
        return obj -> g.apply((BucketPermissionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketPermissionConfiguration> {
        /**
         * <p>
         * The account-level permissions settings that apply to the bucket.
         * </p>
         * 
         * @param accountLevelPermissions
         *        The account-level permissions settings that apply to the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountLevelPermissions(AccountLevelPermissions accountLevelPermissions);

        /**
         * <p>
         * The account-level permissions settings that apply to the bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountLevelPermissions.Builder} avoiding
         * the need to create one manually via {@link AccountLevelPermissions#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccountLevelPermissions.Builder#build()} is called immediately
         * and its result is passed to {@link #accountLevelPermissions(AccountLevelPermissions)}.
         * 
         * @param accountLevelPermissions
         *        a consumer that will call methods on {@link AccountLevelPermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountLevelPermissions(AccountLevelPermissions)
         */
        default Builder accountLevelPermissions(Consumer<AccountLevelPermissions.Builder> accountLevelPermissions) {
            return accountLevelPermissions(AccountLevelPermissions.builder().applyMutation(accountLevelPermissions).build());
        }

        /**
         * <p>
         * The bucket-level permissions settings for the bucket.
         * </p>
         * 
         * @param bucketLevelPermissions
         *        The bucket-level permissions settings for the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketLevelPermissions(BucketLevelPermissions bucketLevelPermissions);

        /**
         * <p>
         * The bucket-level permissions settings for the bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link BucketLevelPermissions.Builder} avoiding
         * the need to create one manually via {@link BucketLevelPermissions#builder()}.
         *
         * When the {@link Consumer} completes, {@link BucketLevelPermissions.Builder#build()} is called immediately and
         * its result is passed to {@link #bucketLevelPermissions(BucketLevelPermissions)}.
         * 
         * @param bucketLevelPermissions
         *        a consumer that will call methods on {@link BucketLevelPermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketLevelPermissions(BucketLevelPermissions)
         */
        default Builder bucketLevelPermissions(Consumer<BucketLevelPermissions.Builder> bucketLevelPermissions) {
            return bucketLevelPermissions(BucketLevelPermissions.builder().applyMutation(bucketLevelPermissions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AccountLevelPermissions accountLevelPermissions;

        private BucketLevelPermissions bucketLevelPermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketPermissionConfiguration model) {
            accountLevelPermissions(model.accountLevelPermissions);
            bucketLevelPermissions(model.bucketLevelPermissions);
        }

        public final AccountLevelPermissions.Builder getAccountLevelPermissions() {
            return accountLevelPermissions != null ? accountLevelPermissions.toBuilder() : null;
        }

        public final void setAccountLevelPermissions(AccountLevelPermissions.BuilderImpl accountLevelPermissions) {
            this.accountLevelPermissions = accountLevelPermissions != null ? accountLevelPermissions.build() : null;
        }

        @Override
        public final Builder accountLevelPermissions(AccountLevelPermissions accountLevelPermissions) {
            this.accountLevelPermissions = accountLevelPermissions;
            return this;
        }

        public final BucketLevelPermissions.Builder getBucketLevelPermissions() {
            return bucketLevelPermissions != null ? bucketLevelPermissions.toBuilder() : null;
        }

        public final void setBucketLevelPermissions(BucketLevelPermissions.BuilderImpl bucketLevelPermissions) {
            this.bucketLevelPermissions = bucketLevelPermissions != null ? bucketLevelPermissions.build() : null;
        }

        @Override
        public final Builder bucketLevelPermissions(BucketLevelPermissions bucketLevelPermissions) {
            this.bucketLevelPermissions = bucketLevelPermissions;
            return this;
        }

        @Override
        public BucketPermissionConfiguration build() {
            return new BucketPermissionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
