/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMlModelRequest extends MachineLearningRequest implements
        ToCopyableBuilder<GetMlModelRequest.Builder, GetMlModelRequest> {
    private static final SdkField<String> ML_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMlModelRequest::mlModelId)).setter(setter(Builder::mlModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelId").build()).build();

    private static final SdkField<Boolean> VERBOSE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetMlModelRequest::verbose)).setter(setter(Builder::verbose))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Verbose").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_MODEL_ID_FIELD,
            VERBOSE_FIELD));

    private final String mlModelId;

    private final Boolean verbose;

    private GetMlModelRequest(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
        this.verbose = builder.verbose;
    }

    /**
     * <p>
     * The ID assigned to the <code>MLModel</code> at creation.
     * </p>
     * 
     * @return The ID assigned to the <code>MLModel</code> at creation.
     */
    public String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.
     * </p>
     * <p>
     * If true, <code>Recipe</code> is returned.
     * </p>
     * <p>
     * If false, <code>Recipe</code> is not returned.
     * </p>
     * 
     * @return Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.</p>
     *         <p>
     *         If true, <code>Recipe</code> is returned.
     *         </p>
     *         <p>
     *         If false, <code>Recipe</code> is not returned.
     */
    public Boolean verbose() {
        return verbose;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(verbose());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlModelRequest)) {
            return false;
        }
        GetMlModelRequest other = (GetMlModelRequest) obj;
        return Objects.equals(mlModelId(), other.mlModelId()) && Objects.equals(verbose(), other.verbose());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMlModelRequest").add("MLModelId", mlModelId()).add("Verbose", verbose()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MLModelId":
            return Optional.ofNullable(clazz.cast(mlModelId()));
        case "Verbose":
            return Optional.ofNullable(clazz.cast(verbose()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMlModelRequest, T> g) {
        return obj -> g.apply((GetMlModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMlModelRequest> {
        /**
         * <p>
         * The ID assigned to the <code>MLModel</code> at creation.
         * </p>
         * 
         * @param mlModelId
         *        The ID assigned to the <code>MLModel</code> at creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.
         * </p>
         * <p>
         * If true, <code>Recipe</code> is returned.
         * </p>
         * <p>
         * If false, <code>Recipe</code> is not returned.
         * </p>
         * 
         * @param verbose
         *        Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.</p>
         *        <p>
         *        If true, <code>Recipe</code> is returned.
         *        </p>
         *        <p>
         *        If false, <code>Recipe</code> is not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verbose(Boolean verbose);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String mlModelId;

        private Boolean verbose;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlModelRequest model) {
            super(model);
            mlModelId(model.mlModelId);
            verbose(model.verbose);
        }

        public final String getMlModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final Boolean getVerbose() {
            return verbose;
        }

        @Override
        public final Builder verbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public final void setVerbose(Boolean verbose) {
            this.verbose = verbose;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMlModelRequest build() {
            return new GetMlModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
