/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>CreateBatchPrediction</code> operation, and is an acknowledgement that Amazon ML
 * received the request.
 * </p>
 * <p>
 * The <code>CreateBatchPrediction</code> operation is asynchronous. You can poll for status updates by using the
 * <code>&gt;GetBatchPrediction</code> operation and checking the <code>Status</code> parameter of the result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBatchPredictionResponse extends MachineLearningResponse implements
        ToCopyableBuilder<CreateBatchPredictionResponse.Builder, CreateBatchPredictionResponse> {
    private static final SdkField<String> BATCH_PREDICTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBatchPredictionResponse::batchPredictionId)).setter(setter(Builder::batchPredictionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchPredictionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_PREDICTION_ID_FIELD));

    private final String batchPredictionId;

    private CreateBatchPredictionResponse(BuilderImpl builder) {
        super(builder);
        this.batchPredictionId = builder.batchPredictionId;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value is identical to the
     * value of the <code>BatchPredictionId</code> in the request.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value is identical to
     *         the value of the <code>BatchPredictionId</code> in the request.
     */
    public String batchPredictionId() {
        return batchPredictionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batchPredictionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBatchPredictionResponse)) {
            return false;
        }
        CreateBatchPredictionResponse other = (CreateBatchPredictionResponse) obj;
        return Objects.equals(batchPredictionId(), other.batchPredictionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateBatchPredictionResponse").add("BatchPredictionId", batchPredictionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchPredictionId":
            return Optional.ofNullable(clazz.cast(batchPredictionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBatchPredictionResponse, T> g) {
        return obj -> g.apply((CreateBatchPredictionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateBatchPredictionResponse> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value is identical to the
         * value of the <code>BatchPredictionId</code> in the request.
         * </p>
         * 
         * @param batchPredictionId
         *        A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value is identical
         *        to the value of the <code>BatchPredictionId</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionId(String batchPredictionId);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private String batchPredictionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBatchPredictionResponse model) {
            super(model);
            batchPredictionId(model.batchPredictionId);
        }

        public final String getBatchPredictionId() {
            return batchPredictionId;
        }

        @Override
        public final Builder batchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
            return this;
        }

        public final void setBatchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
        }

        @Override
        public CreateBatchPredictionResponse build() {
            return new CreateBatchPredictionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
