/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.machinelearning.MachineLearningAsyncClient;
import software.amazon.awssdk.services.machinelearning.MachineLearningServiceClientConfiguration;
import software.amazon.awssdk.services.machinelearning.internal.MachineLearningServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.machinelearning.model.AddTagsRequest;
import software.amazon.awssdk.services.machinelearning.model.AddTagsResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRdsRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRdsResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Request;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Response;
import software.amazon.awssdk.services.machinelearning.model.CreateEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateMlModelRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateMlModelResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteMlModelRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteMlModelResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteTagsRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteTagsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeTagsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeTagsResponse;
import software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.GetDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.model.GetDataSourceResponse;
import software.amazon.awssdk.services.machinelearning.model.GetEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.GetEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.GetMlModelRequest;
import software.amazon.awssdk.services.machinelearning.model.GetMlModelResponse;
import software.amazon.awssdk.services.machinelearning.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.machinelearning.model.InternalServerException;
import software.amazon.awssdk.services.machinelearning.model.InvalidInputException;
import software.amazon.awssdk.services.machinelearning.model.InvalidTagException;
import software.amazon.awssdk.services.machinelearning.model.LimitExceededException;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningException;
import software.amazon.awssdk.services.machinelearning.model.PredictRequest;
import software.amazon.awssdk.services.machinelearning.model.PredictResponse;
import software.amazon.awssdk.services.machinelearning.model.PredictorNotMountedException;
import software.amazon.awssdk.services.machinelearning.model.ResourceNotFoundException;
import software.amazon.awssdk.services.machinelearning.model.TagLimitExceededException;
import software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateMlModelRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateMlModelResponse;
import software.amazon.awssdk.services.machinelearning.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromRdsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromRedshiftRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromS3RequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateMlModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateRealtimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteMlModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteRealtimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeBatchPredictionsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeMlModelsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetDataSourceRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetMlModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.PredictRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateMlModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.waiters.MachineLearningAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultMachineLearningAsyncClient
implements MachineLearningAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultMachineLearningAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ScheduledExecutorService executorService;

    protected DefaultMachineLearningAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Machine_Learning#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = (ScheduledExecutorService)clientConfiguration.option((ClientOption)SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, addTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$addTags$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$addTags$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBatchPredictionResponse> createBatchPrediction(CreateBatchPredictionRequest createBatchPredictionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBatchPredictionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, createBatchPredictionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBatchPrediction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBatchPredictionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBatchPrediction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateBatchPredictionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createBatchPredictionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$createBatchPrediction$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$createBatchPrediction$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDataSourceFromRdsResponse> createDataSourceFromRDS(CreateDataSourceFromRdsRequest createDataSourceFromRdsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataSourceFromRdsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, createDataSourceFromRdsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataSourceFromRDS");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataSourceFromRdsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataSourceFromRDS").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDataSourceFromRdsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDataSourceFromRdsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$createDataSourceFromRDS$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$createDataSourceFromRDS$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDataSourceFromRedshiftResponse> createDataSourceFromRedshift(CreateDataSourceFromRedshiftRequest createDataSourceFromRedshiftRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataSourceFromRedshiftRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, createDataSourceFromRedshiftRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataSourceFromRedshift");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataSourceFromRedshiftResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataSourceFromRedshift").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDataSourceFromRedshiftRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDataSourceFromRedshiftRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$createDataSourceFromRedshift$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$createDataSourceFromRedshift$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDataSourceFromS3Response> createDataSourceFromS3(CreateDataSourceFromS3Request createDataSourceFromS3Request) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataSourceFromS3Request, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, createDataSourceFromS3Request.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataSourceFromS3");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataSourceFromS3Response::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataSourceFromS3").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDataSourceFromS3RequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDataSourceFromS3Request));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$createDataSourceFromS3$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$createDataSourceFromS3$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateEvaluationResponse> createEvaluation(CreateEvaluationRequest createEvaluationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEvaluationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, createEvaluationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEvaluation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEvaluationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEvaluation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateEvaluationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createEvaluationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$createEvaluation$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$createEvaluation$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateMlModelResponse> createMLModel(CreateMlModelRequest createMlModelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMlModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, createMlModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMLModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMlModelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMLModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateMlModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createMlModelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$createMLModel$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$createMLModel$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRealtimeEndpointResponse> createRealtimeEndpoint(CreateRealtimeEndpointRequest createRealtimeEndpointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRealtimeEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, createRealtimeEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRealtimeEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRealtimeEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRealtimeEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRealtimeEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRealtimeEndpointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$createRealtimeEndpoint$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$createRealtimeEndpoint$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBatchPredictionResponse> deleteBatchPrediction(DeleteBatchPredictionRequest deleteBatchPredictionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBatchPredictionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, deleteBatchPredictionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBatchPrediction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBatchPredictionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBatchPrediction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteBatchPredictionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteBatchPredictionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$deleteBatchPrediction$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$deleteBatchPrediction$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDataSourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$deleteDataSource$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$deleteDataSource$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEvaluationResponse> deleteEvaluation(DeleteEvaluationRequest deleteEvaluationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEvaluationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, deleteEvaluationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEvaluation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEvaluationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEvaluation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteEvaluationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEvaluationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$deleteEvaluation$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$deleteEvaluation$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteMlModelResponse> deleteMLModel(DeleteMlModelRequest deleteMlModelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMlModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, deleteMlModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMLModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMlModelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMLModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteMlModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteMlModelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$deleteMLModel$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$deleteMLModel$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRealtimeEndpointResponse> deleteRealtimeEndpoint(DeleteRealtimeEndpointRequest deleteRealtimeEndpointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRealtimeEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRealtimeEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRealtimeEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRealtimeEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRealtimeEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRealtimeEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRealtimeEndpointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$deleteRealtimeEndpoint$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$deleteRealtimeEndpoint$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, deleteTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$deleteTags$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$deleteTags$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeBatchPredictionsResponse> describeBatchPredictions(DescribeBatchPredictionsRequest describeBatchPredictionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeBatchPredictionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, describeBatchPredictionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBatchPredictions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBatchPredictionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBatchPredictions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeBatchPredictionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeBatchPredictionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$describeBatchPredictions$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$describeBatchPredictions$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDataSourcesResponse> describeDataSources(DescribeDataSourcesRequest describeDataSourcesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDataSourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, describeDataSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataSources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDataSourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataSources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDataSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDataSourcesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$describeDataSources$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$describeDataSources$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEvaluationsResponse> describeEvaluations(DescribeEvaluationsRequest describeEvaluationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEvaluationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, describeEvaluationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEvaluations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEvaluationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvaluations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEvaluationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEvaluationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$describeEvaluations$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$describeEvaluations$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeMlModelsResponse> describeMLModels(DescribeMlModelsRequest describeMlModelsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMlModelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, describeMlModelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMLModels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMlModelsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMLModels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeMlModelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeMlModelsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$describeMLModels$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$describeMLModels$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, describeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$describeTags$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$describeTags$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBatchPredictionResponse> getBatchPrediction(GetBatchPredictionRequest getBatchPredictionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBatchPredictionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, getBatchPredictionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBatchPrediction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBatchPredictionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBatchPrediction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetBatchPredictionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBatchPredictionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$getBatchPrediction$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$getBatchPrediction$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDataSourceResponse> getDataSource(GetDataSourceRequest getDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, getDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDataSourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$getDataSource$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$getDataSource$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetEvaluationResponse> getEvaluation(GetEvaluationRequest getEvaluationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEvaluationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, getEvaluationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEvaluation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEvaluationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEvaluation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetEvaluationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getEvaluationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$getEvaluation$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$getEvaluation$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMlModelResponse> getMLModel(GetMlModelRequest getMlModelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMlModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, getMlModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMLModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMlModelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMLModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetMlModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMlModelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$getMLModel$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$getMLModel$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PredictResponse> predict(PredictRequest predictRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)predictRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, predictRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Predict");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PredictResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("Predict").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PredictRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)predictRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$predict$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$predict$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBatchPredictionResponse> updateBatchPrediction(UpdateBatchPredictionRequest updateBatchPredictionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBatchPredictionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, updateBatchPredictionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBatchPrediction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBatchPredictionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBatchPrediction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateBatchPredictionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateBatchPredictionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$updateBatchPrediction$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$updateBatchPrediction$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, updateDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDataSourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$updateDataSource$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$updateDataSource$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateEvaluationResponse> updateEvaluation(UpdateEvaluationRequest updateEvaluationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateEvaluationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, updateEvaluationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEvaluation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEvaluationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEvaluation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateEvaluationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateEvaluationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$updateEvaluation$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$updateEvaluation$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateMlModelResponse> updateMLModel(UpdateMlModelRequest updateMlModelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateMlModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMachineLearningAsyncClient.resolveMetricPublishers(clientConfiguration, updateMlModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Machine Learning");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMLModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMlModelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "TagLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "PredictorNotMountedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PredictorNotMountedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PredictorNotMountedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMLModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateMlModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateMlModelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMachineLearningAsyncClient.lambda$updateMLModel$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMachineLearningAsyncClient.lambda$updateMLModel$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public MachineLearningAsyncWaiter waiter() {
        return MachineLearningAsyncWaiter.builder().client(this).scheduledExecutorService(this.executorService).build();
    }

    @Override
    public final MachineLearningServiceClientConfiguration serviceClientConfiguration() {
        return new MachineLearningServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "machinelearning";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MachineLearningException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        MachineLearningServiceClientConfigurationBuilder serviceConfigBuilder = new MachineLearningServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateMLModel$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateMLModel$110(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateMlModelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateEvaluation$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEvaluation$106(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateEvaluationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDataSource$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDataSource$102(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDataSourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateBatchPrediction$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBatchPrediction$98(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateBatchPredictionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$predict$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$predict$94(List metricPublishers, MetricCollector apiCallMetricCollector, PredictResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMLModel$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMLModel$90(List metricPublishers, MetricCollector apiCallMetricCollector, GetMlModelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getEvaluation$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEvaluation$86(List metricPublishers, MetricCollector apiCallMetricCollector, GetEvaluationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDataSource$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataSource$82(List metricPublishers, MetricCollector apiCallMetricCollector, GetDataSourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBatchPrediction$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBatchPrediction$78(List metricPublishers, MetricCollector apiCallMetricCollector, GetBatchPredictionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTags$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTags$74(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeMLModels$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMLModels$70(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeMlModelsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEvaluations$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEvaluations$66(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEvaluationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDataSources$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataSources$62(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDataSourcesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeBatchPredictions$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBatchPredictions$58(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeBatchPredictionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTags$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTags$54(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRealtimeEndpoint$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRealtimeEndpoint$50(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRealtimeEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteMLModel$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMLModel$46(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteMlModelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteEvaluation$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEvaluation$42(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteEvaluationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDataSource$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataSource$38(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDataSourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBatchPrediction$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBatchPrediction$34(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBatchPredictionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRealtimeEndpoint$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRealtimeEndpoint$30(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRealtimeEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createMLModel$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMLModel$26(List metricPublishers, MetricCollector apiCallMetricCollector, CreateMlModelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createEvaluation$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEvaluation$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateEvaluationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDataSourceFromS3$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataSourceFromS3$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDataSourceFromS3Response r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDataSourceFromRedshift$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataSourceFromRedshift$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDataSourceFromRedshiftResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDataSourceFromRDS$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataSourceFromRDS$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDataSourceFromRdsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createBatchPrediction$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBatchPrediction$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateBatchPredictionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addTags$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addTags$2(List metricPublishers, MetricCollector apiCallMetricCollector, AddTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

