/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.machinelearning.MachineLearningClient;
import software.amazon.awssdk.services.machinelearning.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.services.machinelearning.waiters.MachineLearningWaiter;
import software.amazon.awssdk.services.machinelearning.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultMachineLearningWaiter
implements MachineLearningWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final MachineLearningClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeDataSourcesResponse> dataSourceAvailableWaiter;
    private final Waiter<DescribeMlModelsResponse> mLModelAvailableWaiter;
    private final Waiter<DescribeEvaluationsResponse> evaluationAvailableWaiter;
    private final Waiter<DescribeBatchPredictionsResponse> batchPredictionAvailableWaiter;

    private DefaultMachineLearningWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (MachineLearningClient)MachineLearningClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.dataSourceAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeDataSourcesResponse.class).acceptors(DefaultMachineLearningWaiter.dataSourceAvailableWaiterAcceptors())).overrideConfiguration(DefaultMachineLearningWaiter.dataSourceAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.mLModelAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeMlModelsResponse.class).acceptors(DefaultMachineLearningWaiter.mLModelAvailableWaiterAcceptors())).overrideConfiguration(DefaultMachineLearningWaiter.mLModelAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.evaluationAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeEvaluationsResponse.class).acceptors(DefaultMachineLearningWaiter.evaluationAvailableWaiterAcceptors())).overrideConfiguration(DefaultMachineLearningWaiter.evaluationAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.batchPredictionAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeBatchPredictionsResponse.class).acceptors(DefaultMachineLearningWaiter.batchPredictionAvailableWaiterAcceptors())).overrideConfiguration(DefaultMachineLearningWaiter.batchPredictionAvailableWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeBatchPredictionsResponse> waitUntilBatchPredictionAvailable(DescribeBatchPredictionsRequest describeBatchPredictionsRequest) {
        return this.batchPredictionAvailableWaiter.run(() -> this.client.describeBatchPredictions(this.applyWaitersUserAgent(describeBatchPredictionsRequest)));
    }

    @Override
    public WaiterResponse<DescribeBatchPredictionsResponse> waitUntilBatchPredictionAvailable(DescribeBatchPredictionsRequest describeBatchPredictionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.batchPredictionAvailableWaiter.run(() -> this.client.describeBatchPredictions(this.applyWaitersUserAgent(describeBatchPredictionsRequest)), DefaultMachineLearningWaiter.batchPredictionAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeDataSourcesResponse> waitUntilDataSourceAvailable(DescribeDataSourcesRequest describeDataSourcesRequest) {
        return this.dataSourceAvailableWaiter.run(() -> this.client.describeDataSources(this.applyWaitersUserAgent(describeDataSourcesRequest)));
    }

    @Override
    public WaiterResponse<DescribeDataSourcesResponse> waitUntilDataSourceAvailable(DescribeDataSourcesRequest describeDataSourcesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dataSourceAvailableWaiter.run(() -> this.client.describeDataSources(this.applyWaitersUserAgent(describeDataSourcesRequest)), DefaultMachineLearningWaiter.dataSourceAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeEvaluationsResponse> waitUntilEvaluationAvailable(DescribeEvaluationsRequest describeEvaluationsRequest) {
        return this.evaluationAvailableWaiter.run(() -> this.client.describeEvaluations(this.applyWaitersUserAgent(describeEvaluationsRequest)));
    }

    @Override
    public WaiterResponse<DescribeEvaluationsResponse> waitUntilEvaluationAvailable(DescribeEvaluationsRequest describeEvaluationsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.evaluationAvailableWaiter.run(() -> this.client.describeEvaluations(this.applyWaitersUserAgent(describeEvaluationsRequest)), DefaultMachineLearningWaiter.evaluationAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeMlModelsResponse> waitUntilMLModelAvailable(DescribeMlModelsRequest describeMlModelsRequest) {
        return this.mLModelAvailableWaiter.run(() -> this.client.describeMLModels(this.applyWaitersUserAgent(describeMlModelsRequest)));
    }

    @Override
    public WaiterResponse<DescribeMlModelsResponse> waitUntilMLModelAvailable(DescribeMlModelsRequest describeMlModelsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.mLModelAvailableWaiter.run(() -> this.client.describeMLModels(this.applyWaitersUserAgent(describeMlModelsRequest)), DefaultMachineLearningWaiter.mLModelAvailableWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeDataSourcesResponse>> dataSourceAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDataSourcesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDataSourcesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "COMPLETED"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Results[].Status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeMlModelsResponse>> mLModelAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeMlModelsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeMlModelsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "COMPLETED"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Results[].Status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeEvaluationsResponse>> evaluationAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeEvaluationsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeEvaluationsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "COMPLETED"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Results[].Status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeBatchPredictionsResponse>> batchPredictionAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBatchPredictionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBatchPredictionsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "COMPLETED"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Results[].Status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration dataSourceAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration mLModelAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration evaluationAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration batchPredictionAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static MachineLearningWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends MachineLearningRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MachineLearningRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements MachineLearningWaiter.Builder {
        private MachineLearningClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public MachineLearningWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public MachineLearningWaiter.Builder client(MachineLearningClient client) {
            this.client = client;
            return this;
        }

        @Override
        public MachineLearningWaiter build() {
            return new DefaultMachineLearningWaiter(this);
        }
    }
}

