/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.machinelearning.DefaultMachineLearningAsyncClient;
import software.amazon.awssdk.services.machinelearning.DefaultMachineLearningBaseClientBuilder;
import software.amazon.awssdk.services.machinelearning.MachineLearningAsyncClient;
import software.amazon.awssdk.services.machinelearning.MachineLearningAsyncClientBuilder;
import software.amazon.awssdk.services.machinelearning.MachineLearningServiceClientConfiguration;
import software.amazon.awssdk.services.machinelearning.endpoints.MachineLearningEndpointProvider;

@SdkInternalApi
final class DefaultMachineLearningAsyncClientBuilder
extends DefaultMachineLearningBaseClientBuilder<MachineLearningAsyncClientBuilder, MachineLearningAsyncClient>
implements MachineLearningAsyncClientBuilder {
    DefaultMachineLearningAsyncClientBuilder() {
    }

    @Override
    public DefaultMachineLearningAsyncClientBuilder endpointProvider(MachineLearningEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MachineLearningAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMachineLearningAsyncClientBuilder.validateClientOptions(clientConfiguration);
        MachineLearningServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMachineLearningAsyncClient client = new DefaultMachineLearningAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MachineLearningServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MachineLearningServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

