/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.machinelearning.DefaultMachineLearningAsyncClient;
import software.amazon.awssdk.services.machinelearning.DefaultMachineLearningBaseClientBuilder;
import software.amazon.awssdk.services.machinelearning.MachineLearningAsyncClient;
import software.amazon.awssdk.services.machinelearning.MachineLearningAsyncClientBuilder;
import software.amazon.awssdk.services.machinelearning.MachineLearningServiceClientConfiguration;
import software.amazon.awssdk.services.machinelearning.endpoints.MachineLearningEndpointProvider;

@SdkInternalApi
final class DefaultMachineLearningAsyncClientBuilder
extends DefaultMachineLearningBaseClientBuilder<MachineLearningAsyncClientBuilder, MachineLearningAsyncClient>
implements MachineLearningAsyncClientBuilder {
    DefaultMachineLearningAsyncClientBuilder() {
    }

    @Override
    public DefaultMachineLearningAsyncClientBuilder endpointProvider(MachineLearningEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MachineLearningAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMachineLearningAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        MachineLearningServiceClientConfiguration serviceClientConfiguration = MachineLearningServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultMachineLearningAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

