/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the <code>DataSource</code> details specific to Amazon Redshift.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftMetadata.Builder, RedshiftMetadata> {
    private static final SdkField<RedshiftDatabase> REDSHIFT_DATABASE_FIELD = SdkField
            .<RedshiftDatabase> builder(MarshallingType.SDK_POJO).memberName("RedshiftDatabase")
            .getter(getter(RedshiftMetadata::redshiftDatabase)).setter(setter(Builder::redshiftDatabase))
            .constructor(RedshiftDatabase::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDatabase").build()).build();

    private static final SdkField<String> DATABASE_USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseUserName").getter(getter(RedshiftMetadata::databaseUserName))
            .setter(setter(Builder::databaseUserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseUserName").build()).build();

    private static final SdkField<String> SELECT_SQL_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectSqlQuery").getter(getter(RedshiftMetadata::selectSqlQuery))
            .setter(setter(Builder::selectSqlQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectSqlQuery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDSHIFT_DATABASE_FIELD,
            DATABASE_USER_NAME_FIELD, SELECT_SQL_QUERY_FIELD));

    private static final long serialVersionUID = 1L;

    private final RedshiftDatabase redshiftDatabase;

    private final String databaseUserName;

    private final String selectSqlQuery;

    private RedshiftMetadata(BuilderImpl builder) {
        this.redshiftDatabase = builder.redshiftDatabase;
        this.databaseUserName = builder.databaseUserName;
        this.selectSqlQuery = builder.selectSqlQuery;
    }

    /**
     * Returns the value of the RedshiftDatabase property for this object.
     * 
     * @return The value of the RedshiftDatabase property for this object.
     */
    public final RedshiftDatabase redshiftDatabase() {
        return redshiftDatabase;
    }

    /**
     * Returns the value of the DatabaseUserName property for this object.
     * 
     * @return The value of the DatabaseUserName property for this object.
     */
    public final String databaseUserName() {
        return databaseUserName;
    }

    /**
     * <p>
     * The SQL query that is specified during <a>CreateDataSourceFromRedshift</a>. Returns only if <code>Verbose</code>
     * is true in GetDataSourceInput.
     * </p>
     * 
     * @return The SQL query that is specified during <a>CreateDataSourceFromRedshift</a>. Returns only if
     *         <code>Verbose</code> is true in GetDataSourceInput.
     */
    public final String selectSqlQuery() {
        return selectSqlQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(redshiftDatabase());
        hashCode = 31 * hashCode + Objects.hashCode(databaseUserName());
        hashCode = 31 * hashCode + Objects.hashCode(selectSqlQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftMetadata)) {
            return false;
        }
        RedshiftMetadata other = (RedshiftMetadata) obj;
        return Objects.equals(redshiftDatabase(), other.redshiftDatabase())
                && Objects.equals(databaseUserName(), other.databaseUserName())
                && Objects.equals(selectSqlQuery(), other.selectSqlQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftMetadata").add("RedshiftDatabase", redshiftDatabase())
                .add("DatabaseUserName", databaseUserName()).add("SelectSqlQuery", selectSqlQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RedshiftDatabase":
            return Optional.ofNullable(clazz.cast(redshiftDatabase()));
        case "DatabaseUserName":
            return Optional.ofNullable(clazz.cast(databaseUserName()));
        case "SelectSqlQuery":
            return Optional.ofNullable(clazz.cast(selectSqlQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftMetadata, T> g) {
        return obj -> g.apply((RedshiftMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftMetadata> {
        /**
         * Sets the value of the RedshiftDatabase property for this object.
         *
         * @param redshiftDatabase
         *        The new value for the RedshiftDatabase property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDatabase(RedshiftDatabase redshiftDatabase);

        /**
         * Sets the value of the RedshiftDatabase property for this object.
         *
         * This is a convenience that creates an instance of the {@link RedshiftDatabase.Builder} avoiding the need to
         * create one manually via {@link RedshiftDatabase#builder()}.
         *
         * When the {@link Consumer} completes, {@link RedshiftDatabase.Builder#build()} is called immediately and its
         * result is passed to {@link #redshiftDatabase(RedshiftDatabase)}.
         * 
         * @param redshiftDatabase
         *        a consumer that will call methods on {@link RedshiftDatabase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftDatabase(RedshiftDatabase)
         */
        default Builder redshiftDatabase(Consumer<RedshiftDatabase.Builder> redshiftDatabase) {
            return redshiftDatabase(RedshiftDatabase.builder().applyMutation(redshiftDatabase).build());
        }

        /**
         * Sets the value of the DatabaseUserName property for this object.
         *
         * @param databaseUserName
         *        The new value for the DatabaseUserName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseUserName(String databaseUserName);

        /**
         * <p>
         * The SQL query that is specified during <a>CreateDataSourceFromRedshift</a>. Returns only if
         * <code>Verbose</code> is true in GetDataSourceInput.
         * </p>
         * 
         * @param selectSqlQuery
         *        The SQL query that is specified during <a>CreateDataSourceFromRedshift</a>. Returns only if
         *        <code>Verbose</code> is true in GetDataSourceInput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectSqlQuery(String selectSqlQuery);
    }

    static final class BuilderImpl implements Builder {
        private RedshiftDatabase redshiftDatabase;

        private String databaseUserName;

        private String selectSqlQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftMetadata model) {
            redshiftDatabase(model.redshiftDatabase);
            databaseUserName(model.databaseUserName);
            selectSqlQuery(model.selectSqlQuery);
        }

        public final RedshiftDatabase.Builder getRedshiftDatabase() {
            return redshiftDatabase != null ? redshiftDatabase.toBuilder() : null;
        }

        public final void setRedshiftDatabase(RedshiftDatabase.BuilderImpl redshiftDatabase) {
            this.redshiftDatabase = redshiftDatabase != null ? redshiftDatabase.build() : null;
        }

        @Override
        @Transient
        public final Builder redshiftDatabase(RedshiftDatabase redshiftDatabase) {
            this.redshiftDatabase = redshiftDatabase;
            return this;
        }

        public final String getDatabaseUserName() {
            return databaseUserName;
        }

        public final void setDatabaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
        }

        @Override
        @Transient
        public final Builder databaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
            return this;
        }

        public final String getSelectSqlQuery() {
            return selectSqlQuery;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        @Override
        @Transient
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        @Override
        public RedshiftMetadata build() {
            return new RedshiftMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
