/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMlModelRequest extends MachineLearningRequest implements
        ToCopyableBuilder<CreateMlModelRequest.Builder, CreateMlModelRequest> {
    private static final SdkField<String> ML_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MLModelId").getter(getter(CreateMlModelRequest::mlModelId)).setter(setter(Builder::mlModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelId").build()).build();

    private static final SdkField<String> ML_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MLModelName").getter(getter(CreateMlModelRequest::mlModelName)).setter(setter(Builder::mlModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelName").build()).build();

    private static final SdkField<String> ML_MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MLModelType").getter(getter(CreateMlModelRequest::mlModelTypeAsString))
            .setter(setter(Builder::mlModelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelType").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(CreateMlModelRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TRAINING_DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrainingDataSourceId").getter(getter(CreateMlModelRequest::trainingDataSourceId))
            .setter(setter(Builder::trainingDataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataSourceId").build())
            .build();

    private static final SdkField<String> RECIPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Recipe")
            .getter(getter(CreateMlModelRequest::recipe)).setter(setter(Builder::recipe))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recipe").build()).build();

    private static final SdkField<String> RECIPE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecipeUri").getter(getter(CreateMlModelRequest::recipeUri)).setter(setter(Builder::recipeUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_MODEL_ID_FIELD,
            ML_MODEL_NAME_FIELD, ML_MODEL_TYPE_FIELD, PARAMETERS_FIELD, TRAINING_DATA_SOURCE_ID_FIELD, RECIPE_FIELD,
            RECIPE_URI_FIELD));

    private final String mlModelId;

    private final String mlModelName;

    private final String mlModelType;

    private final Map<String, String> parameters;

    private final String trainingDataSourceId;

    private final String recipe;

    private final String recipeUri;

    private CreateMlModelRequest(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
        this.mlModelName = builder.mlModelName;
        this.mlModelType = builder.mlModelType;
        this.parameters = builder.parameters;
        this.trainingDataSourceId = builder.trainingDataSourceId;
        this.recipe = builder.recipe;
        this.recipeUri = builder.recipeUri;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the <code>MLModel</code>.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the <code>MLModel</code>.
     */
    public final String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>MLModel</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>MLModel</code>.
     */
    public final String mlModelName() {
        return mlModelName;
    }

    /**
     * <p>
     * The category of supervised learning that this <code>MLModel</code> will address. Choose from the following types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.
     * </p>
     * </li>
     * <li>
     * <p>
     * Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine
     * Learning Developer Guide</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mlModelType} will
     * return {@link MLModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mlModelTypeAsString}.
     * </p>
     * 
     * @return The category of supervised learning that this <code>MLModel</code> will address. Choose from the
     *         following types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon
     *         Machine Learning Developer Guide</a>.
     * @see MLModelType
     */
    public final MLModelType mlModelType() {
        return MLModelType.fromValue(mlModelType);
    }

    /**
     * <p>
     * The category of supervised learning that this <code>MLModel</code> will address. Choose from the following types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.
     * </p>
     * </li>
     * <li>
     * <p>
     * Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine
     * Learning Developer Guide</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mlModelType} will
     * return {@link MLModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mlModelTypeAsString}.
     * </p>
     * 
     * @return The category of supervised learning that this <code>MLModel</code> will address. Choose from the
     *         following types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon
     *         Machine Learning Developer Guide</a>.
     * @see MLModelType
     */
    public final String mlModelTypeAsString() {
        return mlModelType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value
     * pairs.
     * </p>
     * <p>
     * The following is the current set of training parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data, the
     * size of the model might affect its performance.
     * </p>
     * <p>
     * The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is
     * <code>33554432</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to build
     * the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>. The
     * default value is <code>10</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves a
     * model's ability to find the optimal solution for a variety of data types. The valid values are <code>auto</code>
     * and <code>none</code>. The default value is <code>none</code>. We strongly recommend that you shuffle your data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting the
     * data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse feature
     * set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     * </p>
     * <p>
     * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L1
     * normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter sparingly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting the
     * data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this
     * parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     * </p>
     * <p>
     * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L2
     * normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter sparingly.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of
     *         key-value pairs.</p>
     *         <p>
     *         The following is the current set of training parameters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input
     *         data, the size of the model might affect its performance.
     *         </p>
     *         <p>
     *         The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default
     *         value is <code>33554432</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to
     *         build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to
     *         <code>10000</code>. The default value is <code>10</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves
     *         a model's ability to find the optimal solution for a variety of data types. The valid values are
     *         <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We strongly recommend
     *         that you shuffle your data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting
     *         the data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a
     *         sparse feature set. If you use this parameter, start by specifying a small value, such as
     *         <code>1.0E-08</code>.
     *         </p>
     *         <p>
     *         The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not
     *         use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter
     *         sparingly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting
     *         the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If
     *         you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     *         </p>
     *         <p>
     *         The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not
     *         use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter
     *         sparingly.
     *         </p>
     *         </li>
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The <code>DataSource</code> that points to the training data.
     * </p>
     * 
     * @return The <code>DataSource</code> that points to the training data.
     */
    public final String trainingDataSourceId() {
        return trainingDataSourceId;
    }

    /**
     * <p>
     * The data recipe for creating the <code>MLModel</code>. You must specify either the recipe or its URI. If you
     * don't specify a recipe or its URI, Amazon ML creates a default.
     * </p>
     * 
     * @return The data recipe for creating the <code>MLModel</code>. You must specify either the recipe or its URI. If
     *         you don't specify a recipe or its URI, Amazon ML creates a default.
     */
    public final String recipe() {
        return recipe;
    }

    /**
     * <p>
     * The Amazon Simple Storage Service (Amazon S3) location and file name that contains the <code>MLModel</code>
     * recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML
     * creates a default.
     * </p>
     * 
     * @return The Amazon Simple Storage Service (Amazon S3) location and file name that contains the
     *         <code>MLModel</code> recipe. You must specify either the recipe or its URI. If you don't specify a recipe
     *         or its URI, Amazon ML creates a default.
     */
    public final String recipeUri() {
        return recipeUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(mlModelName());
        hashCode = 31 * hashCode + Objects.hashCode(mlModelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(recipe());
        hashCode = 31 * hashCode + Objects.hashCode(recipeUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMlModelRequest)) {
            return false;
        }
        CreateMlModelRequest other = (CreateMlModelRequest) obj;
        return Objects.equals(mlModelId(), other.mlModelId()) && Objects.equals(mlModelName(), other.mlModelName())
                && Objects.equals(mlModelTypeAsString(), other.mlModelTypeAsString()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters())
                && Objects.equals(trainingDataSourceId(), other.trainingDataSourceId())
                && Objects.equals(recipe(), other.recipe()) && Objects.equals(recipeUri(), other.recipeUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMlModelRequest").add("MLModelId", mlModelId()).add("MLModelName", mlModelName())
                .add("MLModelType", mlModelTypeAsString()).add("Parameters", hasParameters() ? parameters() : null)
                .add("TrainingDataSourceId", trainingDataSourceId()).add("Recipe", recipe()).add("RecipeUri", recipeUri())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MLModelId":
            return Optional.ofNullable(clazz.cast(mlModelId()));
        case "MLModelName":
            return Optional.ofNullable(clazz.cast(mlModelName()));
        case "MLModelType":
            return Optional.ofNullable(clazz.cast(mlModelTypeAsString()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "TrainingDataSourceId":
            return Optional.ofNullable(clazz.cast(trainingDataSourceId()));
        case "Recipe":
            return Optional.ofNullable(clazz.cast(recipe()));
        case "RecipeUri":
            return Optional.ofNullable(clazz.cast(recipeUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMlModelRequest, T> g) {
        return obj -> g.apply((CreateMlModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMlModelRequest> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the <code>MLModel</code>.
         * </p>
         * 
         * @param mlModelId
         *        A user-supplied ID that uniquely identifies the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * A user-supplied name or description of the <code>MLModel</code>.
         * </p>
         * 
         * @param mlModelName
         *        A user-supplied name or description of the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelName(String mlModelName);

        /**
         * <p>
         * The category of supervised learning that this <code>MLModel</code> will address. Choose from the following
         * types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.
         * </p>
         * </li>
         * <li>
         * <p>
         * Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine
         * Learning Developer Guide</a>.
         * </p>
         * 
         * @param mlModelType
         *        The category of supervised learning that this <code>MLModel</code> will address. Choose from the
         *        following types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon
         *        Machine Learning Developer Guide</a>.
         * @see MLModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLModelType
         */
        Builder mlModelType(String mlModelType);

        /**
         * <p>
         * The category of supervised learning that this <code>MLModel</code> will address. Choose from the following
         * types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.
         * </p>
         * </li>
         * <li>
         * <p>
         * Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine
         * Learning Developer Guide</a>.
         * </p>
         * 
         * @param mlModelType
         *        The category of supervised learning that this <code>MLModel</code> will address. Choose from the
         *        following types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon
         *        Machine Learning Developer Guide</a>.
         * @see MLModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLModelType
         */
        Builder mlModelType(MLModelType mlModelType);

        /**
         * <p>
         * A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value
         * pairs.
         * </p>
         * <p>
         * The following is the current set of training parameters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data,
         * the size of the model might affect its performance.
         * </p>
         * <p>
         * The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is
         * <code>33554432</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to
         * build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>
         * . The default value is <code>10</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves a
         * model's ability to find the optimal solution for a variety of data types. The valid values are
         * <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We strongly recommend that
         * you shuffle your data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting the
         * data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse
         * feature set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
         * </p>
         * <p>
         * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use
         * L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter
         * sparingly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting the
         * data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use
         * this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
         * </p>
         * <p>
         * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use
         * L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter
         * sparingly.
         * </p>
         * </li>
         * </ul>
         * 
         * @param parameters
         *        A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of
         *        key-value pairs.</p>
         *        <p>
         *        The following is the current set of training parameters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input
         *        data, the size of the model might affect its performance.
         *        </p>
         *        <p>
         *        The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default
         *        value is <code>33554432</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations
         *        to build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to
         *        <code>10000</code>. The default value is <code>10</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data
         *        improves a model's ability to find the optimal solution for a variety of data types. The valid values
         *        are <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We strongly
         *        recommend that you shuffle your data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls
         *        overfitting the data by penalizing large coefficients. This tends to drive coefficients to zero,
         *        resulting in a sparse feature set. If you use this parameter, start by specifying a small value, such
         *        as <code>1.0E-08</code>.
         *        </p>
         *        <p>
         *        The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to
         *        not use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this
         *        parameter sparingly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls
         *        overfitting the data by penalizing large coefficients. This tends to drive coefficients to small,
         *        nonzero values. If you use this parameter, start by specifying a small value, such as
         *        <code>1.0E-08</code>.
         *        </p>
         *        <p>
         *        The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to
         *        not use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this
         *        parameter sparingly.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The <code>DataSource</code> that points to the training data.
         * </p>
         * 
         * @param trainingDataSourceId
         *        The <code>DataSource</code> that points to the training data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataSourceId(String trainingDataSourceId);

        /**
         * <p>
         * The data recipe for creating the <code>MLModel</code>. You must specify either the recipe or its URI. If you
         * don't specify a recipe or its URI, Amazon ML creates a default.
         * </p>
         * 
         * @param recipe
         *        The data recipe for creating the <code>MLModel</code>. You must specify either the recipe or its URI.
         *        If you don't specify a recipe or its URI, Amazon ML creates a default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipe(String recipe);

        /**
         * <p>
         * The Amazon Simple Storage Service (Amazon S3) location and file name that contains the <code>MLModel</code>
         * recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML
         * creates a default.
         * </p>
         * 
         * @param recipeUri
         *        The Amazon Simple Storage Service (Amazon S3) location and file name that contains the
         *        <code>MLModel</code> recipe. You must specify either the recipe or its URI. If you don't specify a
         *        recipe or its URI, Amazon ML creates a default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeUri(String recipeUri);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String mlModelId;

        private String mlModelName;

        private String mlModelType;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String trainingDataSourceId;

        private String recipe;

        private String recipeUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMlModelRequest model) {
            super(model);
            mlModelId(model.mlModelId);
            mlModelName(model.mlModelName);
            mlModelType(model.mlModelType);
            parameters(model.parameters);
            trainingDataSourceId(model.trainingDataSourceId);
            recipe(model.recipe);
            recipeUri(model.recipeUri);
        }

        public final String getMlModelId() {
            return mlModelId;
        }

        public final void setMlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        @Override
        @Transient
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final String getMlModelName() {
            return mlModelName;
        }

        public final void setMlModelName(String mlModelName) {
            this.mlModelName = mlModelName;
        }

        @Override
        @Transient
        public final Builder mlModelName(String mlModelName) {
            this.mlModelName = mlModelName;
            return this;
        }

        public final String getMlModelType() {
            return mlModelType;
        }

        public final void setMlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
        }

        @Override
        @Transient
        public final Builder mlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
            return this;
        }

        @Override
        @Transient
        public final Builder mlModelType(MLModelType mlModelType) {
            this.mlModelType(mlModelType == null ? null : mlModelType.toString());
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = TrainingParametersCopier.copy(parameters);
        }

        @Override
        @Transient
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = TrainingParametersCopier.copy(parameters);
            return this;
        }

        public final String getTrainingDataSourceId() {
            return trainingDataSourceId;
        }

        public final void setTrainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
        }

        @Override
        @Transient
        public final Builder trainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
            return this;
        }

        public final String getRecipe() {
            return recipe;
        }

        public final void setRecipe(String recipe) {
            this.recipe = recipe;
        }

        @Override
        @Transient
        public final Builder recipe(String recipe) {
            this.recipe = recipe;
            return this;
        }

        public final String getRecipeUri() {
            return recipeUri;
        }

        public final void setRecipeUri(String recipeUri) {
            this.recipeUri = recipeUri;
        }

        @Override
        @Transient
        public final Builder recipeUri(String recipeUri) {
            this.recipeUri = recipeUri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMlModelRequest build() {
            return new CreateMlModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
