/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetMLModel</code> operation, and provides detailed information about a
 * <code>MLModel</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMlModelResponse extends MachineLearningResponse implements
        ToCopyableBuilder<GetMlModelResponse.Builder, GetMlModelResponse> {
    private static final SdkField<String> ML_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MLModelId").getter(getter(GetMlModelResponse::mlModelId)).setter(setter(Builder::mlModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelId").build()).build();

    private static final SdkField<String> TRAINING_DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrainingDataSourceId").getter(getter(GetMlModelResponse::trainingDataSourceId))
            .setter(setter(Builder::trainingDataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataSourceId").build())
            .build();

    private static final SdkField<String> CREATED_BY_IAM_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedByIamUser").getter(getter(GetMlModelResponse::createdByIamUser))
            .setter(setter(Builder::createdByIamUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByIamUser").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(GetMlModelResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(GetMlModelResponse::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetMlModelResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetMlModelResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Long> SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SizeInBytes").getter(getter(GetMlModelResponse::sizeInBytes)).setter(setter(Builder::sizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInBytes").build()).build();

    private static final SdkField<RealtimeEndpointInfo> ENDPOINT_INFO_FIELD = SdkField
            .<RealtimeEndpointInfo> builder(MarshallingType.SDK_POJO).memberName("EndpointInfo")
            .getter(getter(GetMlModelResponse::endpointInfo)).setter(setter(Builder::endpointInfo))
            .constructor(RealtimeEndpointInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointInfo").build()).build();

    private static final SdkField<Map<String, String>> TRAINING_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("TrainingParameters")
            .getter(getter(GetMlModelResponse::trainingParameters))
            .setter(setter(Builder::trainingParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> INPUT_DATA_LOCATION_S3_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputDataLocationS3").getter(getter(GetMlModelResponse::inputDataLocationS3))
            .setter(setter(Builder::inputDataLocationS3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataLocationS3").build())
            .build();

    private static final SdkField<String> ML_MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MLModelType").getter(getter(GetMlModelResponse::mlModelTypeAsString))
            .setter(setter(Builder::mlModelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelType").build()).build();

    private static final SdkField<Float> SCORE_THRESHOLD_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("ScoreThreshold").getter(getter(GetMlModelResponse::scoreThreshold))
            .setter(setter(Builder::scoreThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoreThreshold").build()).build();

    private static final SdkField<Instant> SCORE_THRESHOLD_LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ScoreThresholdLastUpdatedAt")
            .getter(getter(GetMlModelResponse::scoreThresholdLastUpdatedAt))
            .setter(setter(Builder::scoreThresholdLastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoreThresholdLastUpdatedAt")
                    .build()).build();

    private static final SdkField<String> LOG_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("LogUri")
            .getter(getter(GetMlModelResponse::logUri)).setter(setter(Builder::logUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogUri").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(GetMlModelResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Long> COMPUTE_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ComputeTime").getter(getter(GetMlModelResponse::computeTime)).setter(setter(Builder::computeTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeTime").build()).build();

    private static final SdkField<Instant> FINISHED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FinishedAt").getter(getter(GetMlModelResponse::finishedAt)).setter(setter(Builder::finishedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinishedAt").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAt").getter(getter(GetMlModelResponse::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build()).build();

    private static final SdkField<String> RECIPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Recipe")
            .getter(getter(GetMlModelResponse::recipe)).setter(setter(Builder::recipe))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recipe").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Schema")
            .getter(getter(GetMlModelResponse::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_MODEL_ID_FIELD,
            TRAINING_DATA_SOURCE_ID_FIELD, CREATED_BY_IAM_USER_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD,
            STATUS_FIELD, SIZE_IN_BYTES_FIELD, ENDPOINT_INFO_FIELD, TRAINING_PARAMETERS_FIELD, INPUT_DATA_LOCATION_S3_FIELD,
            ML_MODEL_TYPE_FIELD, SCORE_THRESHOLD_FIELD, SCORE_THRESHOLD_LAST_UPDATED_AT_FIELD, LOG_URI_FIELD, MESSAGE_FIELD,
            COMPUTE_TIME_FIELD, FINISHED_AT_FIELD, STARTED_AT_FIELD, RECIPE_FIELD, SCHEMA_FIELD));

    private final String mlModelId;

    private final String trainingDataSourceId;

    private final String createdByIamUser;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String name;

    private final String status;

    private final Long sizeInBytes;

    private final RealtimeEndpointInfo endpointInfo;

    private final Map<String, String> trainingParameters;

    private final String inputDataLocationS3;

    private final String mlModelType;

    private final Float scoreThreshold;

    private final Instant scoreThresholdLastUpdatedAt;

    private final String logUri;

    private final String message;

    private final Long computeTime;

    private final Instant finishedAt;

    private final Instant startedAt;

    private final String recipe;

    private final String schema;

    private GetMlModelResponse(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
        this.trainingDataSourceId = builder.trainingDataSourceId;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.sizeInBytes = builder.sizeInBytes;
        this.endpointInfo = builder.endpointInfo;
        this.trainingParameters = builder.trainingParameters;
        this.inputDataLocationS3 = builder.inputDataLocationS3;
        this.mlModelType = builder.mlModelType;
        this.scoreThreshold = builder.scoreThreshold;
        this.scoreThresholdLastUpdatedAt = builder.scoreThresholdLastUpdatedAt;
        this.logUri = builder.logUri;
        this.message = builder.message;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
        this.recipe = builder.recipe;
        this.schema = builder.schema;
    }

    /**
     * <p>
     * The MLModel ID, which is same as the <code>MLModelId</code> in the request.
     * </p>
     * 
     * @return The MLModel ID, which is same as the <code>MLModelId</code> in the request.
     */
    public final String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * The ID of the training <code>DataSource</code>.
     * </p>
     * 
     * @return The ID of the training <code>DataSource</code>.
     */
    public final String trainingDataSourceId() {
        return trainingDataSourceId;
    }

    /**
     * <p>
     * The AWS user account from which the <code>MLModel</code> was created. The account type can be either an AWS root
     * account or an AWS Identity and Access Management (IAM) user account.
     * </p>
     * 
     * @return The AWS user account from which the <code>MLModel</code> was created. The account type can be either an
     *         AWS root account or an AWS Identity and Access Management (IAM) user account.
     */
    public final String createdByIamUser() {
        return createdByIamUser;
    }

    /**
     * <p>
     * The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>MLModel</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>MLModel</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the <code>MLModel</code>. This element can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a <code>MLModel</code>
     * .
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INPROGRESS</code> - The request is processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - The request completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EntityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the <code>MLModel</code>. This element can have one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a
     *         <code>MLModel</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INPROGRESS</code> - The request is processing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> - The request completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.
     *         </p>
     *         </li>
     * @see EntityStatus
     */
    public final EntityStatus status() {
        return EntityStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the <code>MLModel</code>. This element can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a <code>MLModel</code>
     * .
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INPROGRESS</code> - The request is processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - The request completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EntityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the <code>MLModel</code>. This element can have one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a
     *         <code>MLModel</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INPROGRESS</code> - The request is processing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> - The request completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.
     *         </p>
     *         </li>
     * @see EntityStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the SizeInBytes property for this object.
     * 
     * @return The value of the SizeInBytes property for this object.
     */
    public final Long sizeInBytes() {
        return sizeInBytes;
    }

    /**
     * <p>
     * The current endpoint of the <code>MLModel</code>
     * </p>
     * 
     * @return The current endpoint of the <code>MLModel</code>
     */
    public final RealtimeEndpointInfo endpointInfo() {
        return endpointInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrainingParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrainingParameters() {
        return trainingParameters != null && !(trainingParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value
     * pairs.
     * </p>
     * <p>
     * The following is the current set of training parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data, the
     * size of the model might affect its performance.
     * </p>
     * <p>
     * The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is
     * <code>33554432</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to build
     * the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>. The
     * default value is <code>10</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling data improves a model's
     * ability to find the optimal solution for a variety of data types. The valid values are <code>auto</code> and
     * <code>none</code>. The default value is <code>none</code>. We strongly recommend that you shuffle your data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting the
     * data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse feature
     * set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     * </p>
     * <p>
     * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L1
     * normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter sparingly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting the
     * data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this
     * parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     * </p>
     * <p>
     * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L2
     * normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter sparingly.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrainingParameters} method.
     * </p>
     * 
     * @return A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of
     *         key-value pairs.</p>
     *         <p>
     *         The following is the current set of training parameters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input
     *         data, the size of the model might affect its performance.
     *         </p>
     *         <p>
     *         The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default
     *         value is <code>33554432</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to
     *         build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to
     *         <code>10000</code>. The default value is <code>10</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling data improves a
     *         model's ability to find the optimal solution for a variety of data types. The valid values are
     *         <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We strongly recommend
     *         that you shuffle your data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting
     *         the data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a
     *         sparse feature set. If you use this parameter, start by specifying a small value, such as
     *         <code>1.0E-08</code>.
     *         </p>
     *         <p>
     *         The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not
     *         use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter
     *         sparingly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting
     *         the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If
     *         you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     *         </p>
     *         <p>
     *         The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not
     *         use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter
     *         sparingly.
     *         </p>
     *         </li>
     */
    public final Map<String, String> trainingParameters() {
        return trainingParameters;
    }

    /**
     * <p>
     * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     * </p>
     * 
     * @return The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     */
    public final String inputDataLocationS3() {
        return inputDataLocationS3;
    }

    /**
     * <p>
     * Identifies the <code>MLModel</code> category. The following are the available types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"
     * </p>
     * </li>
     * <li>
     * <p>
     * BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"
     * </p>
     * </li>
     * <li>
     * <p>
     * MULTICLASS -- Produces one of several possible results. For example, "Is this a HIGH, LOW or MEDIUM risk trade?"
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mlModelType} will
     * return {@link MLModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mlModelTypeAsString}.
     * </p>
     * 
     * @return Identifies the <code>MLModel</code> category. The following are the available types: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MULTICLASS -- Produces one of several possible results. For example,
     *         "Is this a HIGH, LOW or MEDIUM risk trade?"
     *         </p>
     *         </li>
     * @see MLModelType
     */
    public final MLModelType mlModelType() {
        return MLModelType.fromValue(mlModelType);
    }

    /**
     * <p>
     * Identifies the <code>MLModel</code> category. The following are the available types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"
     * </p>
     * </li>
     * <li>
     * <p>
     * BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"
     * </p>
     * </li>
     * <li>
     * <p>
     * MULTICLASS -- Produces one of several possible results. For example, "Is this a HIGH, LOW or MEDIUM risk trade?"
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mlModelType} will
     * return {@link MLModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mlModelTypeAsString}.
     * </p>
     * 
     * @return Identifies the <code>MLModel</code> category. The following are the available types: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MULTICLASS -- Produces one of several possible results. For example,
     *         "Is this a HIGH, LOW or MEDIUM risk trade?"
     *         </p>
     *         </li>
     * @see MLModelType
     */
    public final String mlModelTypeAsString() {
        return mlModelType;
    }

    /**
     * <p>
     * The scoring threshold is used in binary classification <code>MLModel</code> models. It marks the boundary between
     * a positive prediction and a negative prediction.
     * </p>
     * <p>
     * Output values greater than or equal to the threshold receive a positive result from the MLModel, such as
     * <code>true</code>. Output values less than the threshold receive a negative response from the MLModel, such as
     * <code>false</code>.
     * </p>
     * 
     * @return The scoring threshold is used in binary classification <code>MLModel</code> models. It marks the boundary
     *         between a positive prediction and a negative prediction.</p>
     *         <p>
     *         Output values greater than or equal to the threshold receive a positive result from the MLModel, such as
     *         <code>true</code>. Output values less than the threshold receive a negative response from the MLModel,
     *         such as <code>false</code>.
     */
    public final Float scoreThreshold() {
        return scoreThreshold;
    }

    /**
     * <p>
     * The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.
     */
    public final Instant scoreThresholdLastUpdatedAt() {
        return scoreThresholdLastUpdatedAt;
    }

    /**
     * <p>
     * A link to the file that contains logs of the <code>CreateMLModel</code> operation.
     * </p>
     * 
     * @return A link to the file that contains logs of the <code>CreateMLModel</code> operation.
     */
    public final String logUri() {
        return logUri;
    }

    /**
     * <p>
     * A description of the most recent details about accessing the <code>MLModel</code>.
     * </p>
     * 
     * @return A description of the most recent details about accessing the <code>MLModel</code>.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>MLModel</code>,
     * normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the
     * <code>MLModel</code> is in the <code>COMPLETED</code> state.
     * </p>
     * 
     * @return The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the
     *         <code>MLModel</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only
     *         available if the <code>MLModel</code> is in the <code>COMPLETED</code> state.
     */
    public final Long computeTime() {
        return computeTime;
    }

    /**
     * <p>
     * The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>COMPLETED</code> or
     * <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>MLModel</code> is in the
     * <code>COMPLETED</code> or <code>FAILED</code> state.
     * </p>
     * 
     * @return The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>COMPLETED</code> or
     *         <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>MLModel</code> is in the
     *         <code>COMPLETED</code> or <code>FAILED</code> state.
     */
    public final Instant finishedAt() {
        return finishedAt;
    }

    /**
     * <p>
     * The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>INPROGRESS</code>.
     * <code>StartedAt</code> isn't available if the <code>MLModel</code> is in the <code>PENDING</code> state.
     * </p>
     * 
     * @return The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>INPROGRESS</code>.
     *         <code>StartedAt</code> isn't available if the <code>MLModel</code> is in the <code>PENDING</code> state.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The recipe to use when training the <code>MLModel</code>. The <code>Recipe</code> provides detailed information
     * about the observation data to use during training, and manipulations to perform on the observation data during
     * training.
     * </p>
     * <p>
     * <b>Note:</b> This parameter is provided as part of the verbose format.
     * </p>
     * 
     * @return The recipe to use when training the <code>MLModel</code>. The <code>Recipe</code> provides detailed
     *         information about the observation data to use during training, and manipulations to perform on the
     *         observation data during training.</p>
     *         <p>
     *         <b>Note:</b> This parameter is provided as part of the verbose format.
     */
    public final String recipe() {
        return recipe;
    }

    /**
     * <p>
     * The schema used by all of the data files referenced by the <code>DataSource</code>.
     * </p>
     * <p>
     * <b>Note:</b> This parameter is provided as part of the verbose format.
     * </p>
     * 
     * @return The schema used by all of the data files referenced by the <code>DataSource</code>.</p>
     *         <p>
     *         <b>Note:</b> This parameter is provided as part of the verbose format.
     */
    public final String schema() {
        return schema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(createdByIamUser());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(endpointInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrainingParameters() ? trainingParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputDataLocationS3());
        hashCode = 31 * hashCode + Objects.hashCode(mlModelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scoreThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(scoreThresholdLastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(logUri());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(computeTime());
        hashCode = 31 * hashCode + Objects.hashCode(finishedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(recipe());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlModelResponse)) {
            return false;
        }
        GetMlModelResponse other = (GetMlModelResponse) obj;
        return Objects.equals(mlModelId(), other.mlModelId())
                && Objects.equals(trainingDataSourceId(), other.trainingDataSourceId())
                && Objects.equals(createdByIamUser(), other.createdByIamUser()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(sizeInBytes(), other.sizeInBytes())
                && Objects.equals(endpointInfo(), other.endpointInfo())
                && hasTrainingParameters() == other.hasTrainingParameters()
                && Objects.equals(trainingParameters(), other.trainingParameters())
                && Objects.equals(inputDataLocationS3(), other.inputDataLocationS3())
                && Objects.equals(mlModelTypeAsString(), other.mlModelTypeAsString())
                && Objects.equals(scoreThreshold(), other.scoreThreshold())
                && Objects.equals(scoreThresholdLastUpdatedAt(), other.scoreThresholdLastUpdatedAt())
                && Objects.equals(logUri(), other.logUri()) && Objects.equals(message(), other.message())
                && Objects.equals(computeTime(), other.computeTime()) && Objects.equals(finishedAt(), other.finishedAt())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(recipe(), other.recipe())
                && Objects.equals(schema(), other.schema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMlModelResponse").add("MLModelId", mlModelId())
                .add("TrainingDataSourceId", trainingDataSourceId()).add("CreatedByIamUser", createdByIamUser())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).add("Name", name())
                .add("Status", statusAsString()).add("SizeInBytes", sizeInBytes()).add("EndpointInfo", endpointInfo())
                .add("TrainingParameters", hasTrainingParameters() ? trainingParameters() : null)
                .add("InputDataLocationS3", inputDataLocationS3()).add("MLModelType", mlModelTypeAsString())
                .add("ScoreThreshold", scoreThreshold()).add("ScoreThresholdLastUpdatedAt", scoreThresholdLastUpdatedAt())
                .add("LogUri", logUri()).add("Message", message()).add("ComputeTime", computeTime())
                .add("FinishedAt", finishedAt()).add("StartedAt", startedAt()).add("Recipe", recipe()).add("Schema", schema())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MLModelId":
            return Optional.ofNullable(clazz.cast(mlModelId()));
        case "TrainingDataSourceId":
            return Optional.ofNullable(clazz.cast(trainingDataSourceId()));
        case "CreatedByIamUser":
            return Optional.ofNullable(clazz.cast(createdByIamUser()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SizeInBytes":
            return Optional.ofNullable(clazz.cast(sizeInBytes()));
        case "EndpointInfo":
            return Optional.ofNullable(clazz.cast(endpointInfo()));
        case "TrainingParameters":
            return Optional.ofNullable(clazz.cast(trainingParameters()));
        case "InputDataLocationS3":
            return Optional.ofNullable(clazz.cast(inputDataLocationS3()));
        case "MLModelType":
            return Optional.ofNullable(clazz.cast(mlModelTypeAsString()));
        case "ScoreThreshold":
            return Optional.ofNullable(clazz.cast(scoreThreshold()));
        case "ScoreThresholdLastUpdatedAt":
            return Optional.ofNullable(clazz.cast(scoreThresholdLastUpdatedAt()));
        case "LogUri":
            return Optional.ofNullable(clazz.cast(logUri()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ComputeTime":
            return Optional.ofNullable(clazz.cast(computeTime()));
        case "FinishedAt":
            return Optional.ofNullable(clazz.cast(finishedAt()));
        case "StartedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "Recipe":
            return Optional.ofNullable(clazz.cast(recipe()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMlModelResponse, T> g) {
        return obj -> g.apply((GetMlModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMlModelResponse> {
        /**
         * <p>
         * The MLModel ID, which is same as the <code>MLModelId</code> in the request.
         * </p>
         * 
         * @param mlModelId
         *        The MLModel ID, which is same as the <code>MLModelId</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * The ID of the training <code>DataSource</code>.
         * </p>
         * 
         * @param trainingDataSourceId
         *        The ID of the training <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataSourceId(String trainingDataSourceId);

        /**
         * <p>
         * The AWS user account from which the <code>MLModel</code> was created. The account type can be either an AWS
         * root account or an AWS Identity and Access Management (IAM) user account.
         * </p>
         * 
         * @param createdByIamUser
         *        The AWS user account from which the <code>MLModel</code> was created. The account type can be either
         *        an AWS root account or an AWS Identity and Access Management (IAM) user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdByIamUser(String createdByIamUser);

        /**
         * <p>
         * The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
         * </p>
         * 
         * @param createdAt
         *        The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * A user-supplied name or description of the <code>MLModel</code>.
         * </p>
         * 
         * @param name
         *        A user-supplied name or description of the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the <code>MLModel</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a
         * <code>MLModel</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INPROGRESS</code> - The request is processing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> - The request completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the <code>MLModel</code>. This element can have one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a
         *        <code>MLModel</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INPROGRESS</code> - The request is processing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> - The request completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.
         *        </p>
         *        </li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the <code>MLModel</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a
         * <code>MLModel</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INPROGRESS</code> - The request is processing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> - The request completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the <code>MLModel</code>. This element can have one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a
         *        <code>MLModel</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INPROGRESS</code> - The request is processing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> - The request completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.
         *        </p>
         *        </li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(EntityStatus status);

        /**
         * Sets the value of the SizeInBytes property for this object.
         *
         * @param sizeInBytes
         *        The new value for the SizeInBytes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInBytes(Long sizeInBytes);

        /**
         * <p>
         * The current endpoint of the <code>MLModel</code>
         * </p>
         * 
         * @param endpointInfo
         *        The current endpoint of the <code>MLModel</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointInfo(RealtimeEndpointInfo endpointInfo);

        /**
         * <p>
         * The current endpoint of the <code>MLModel</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link RealtimeEndpointInfo.Builder} avoiding
         * the need to create one manually via {@link RealtimeEndpointInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link RealtimeEndpointInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #endpointInfo(RealtimeEndpointInfo)}.
         * 
         * @param endpointInfo
         *        a consumer that will call methods on {@link RealtimeEndpointInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointInfo(RealtimeEndpointInfo)
         */
        default Builder endpointInfo(Consumer<RealtimeEndpointInfo.Builder> endpointInfo) {
            return endpointInfo(RealtimeEndpointInfo.builder().applyMutation(endpointInfo).build());
        }

        /**
         * <p>
         * A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value
         * pairs.
         * </p>
         * <p>
         * The following is the current set of training parameters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data,
         * the size of the model might affect its performance.
         * </p>
         * <p>
         * The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is
         * <code>33554432</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to
         * build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>
         * . The default value is <code>10</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling data improves a
         * model's ability to find the optimal solution for a variety of data types. The valid values are
         * <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We strongly recommend that
         * you shuffle your data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting the
         * data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse
         * feature set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
         * </p>
         * <p>
         * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use
         * L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter
         * sparingly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting the
         * data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use
         * this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
         * </p>
         * <p>
         * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use
         * L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter
         * sparingly.
         * </p>
         * </li>
         * </ul>
         * 
         * @param trainingParameters
         *        A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of
         *        key-value pairs.</p>
         *        <p>
         *        The following is the current set of training parameters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input
         *        data, the size of the model might affect its performance.
         *        </p>
         *        <p>
         *        The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default
         *        value is <code>33554432</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations
         *        to build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to
         *        <code>10000</code>. The default value is <code>10</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling data improves a
         *        model's ability to find the optimal solution for a variety of data types. The valid values are
         *        <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We strongly recommend
         *        that you shuffle your data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls
         *        overfitting the data by penalizing large coefficients. This tends to drive coefficients to zero,
         *        resulting in a sparse feature set. If you use this parameter, start by specifying a small value, such
         *        as <code>1.0E-08</code>.
         *        </p>
         *        <p>
         *        The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to
         *        not use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this
         *        parameter sparingly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls
         *        overfitting the data by penalizing large coefficients. This tends to drive coefficients to small,
         *        nonzero values. If you use this parameter, start by specifying a small value, such as
         *        <code>1.0E-08</code>.
         *        </p>
         *        <p>
         *        The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to
         *        not use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this
         *        parameter sparingly.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingParameters(Map<String, String> trainingParameters);

        /**
         * <p>
         * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * </p>
         * 
         * @param inputDataLocationS3
         *        The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataLocationS3(String inputDataLocationS3);

        /**
         * <p>
         * Identifies the <code>MLModel</code> category. The following are the available types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"
         * </p>
         * </li>
         * <li>
         * <p>
         * BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"
         * </p>
         * </li>
         * <li>
         * <p>
         * MULTICLASS -- Produces one of several possible results. For example,
         * "Is this a HIGH, LOW or MEDIUM risk trade?"
         * </p>
         * </li>
         * </ul>
         * 
         * @param mlModelType
         *        Identifies the <code>MLModel</code> category. The following are the available types: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MULTICLASS -- Produces one of several possible results. For example,
         *        "Is this a HIGH, LOW or MEDIUM risk trade?"
         *        </p>
         *        </li>
         * @see MLModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLModelType
         */
        Builder mlModelType(String mlModelType);

        /**
         * <p>
         * Identifies the <code>MLModel</code> category. The following are the available types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"
         * </p>
         * </li>
         * <li>
         * <p>
         * BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"
         * </p>
         * </li>
         * <li>
         * <p>
         * MULTICLASS -- Produces one of several possible results. For example,
         * "Is this a HIGH, LOW or MEDIUM risk trade?"
         * </p>
         * </li>
         * </ul>
         * 
         * @param mlModelType
         *        Identifies the <code>MLModel</code> category. The following are the available types: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MULTICLASS -- Produces one of several possible results. For example,
         *        "Is this a HIGH, LOW or MEDIUM risk trade?"
         *        </p>
         *        </li>
         * @see MLModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLModelType
         */
        Builder mlModelType(MLModelType mlModelType);

        /**
         * <p>
         * The scoring threshold is used in binary classification <code>MLModel</code> models. It marks the boundary
         * between a positive prediction and a negative prediction.
         * </p>
         * <p>
         * Output values greater than or equal to the threshold receive a positive result from the MLModel, such as
         * <code>true</code>. Output values less than the threshold receive a negative response from the MLModel, such
         * as <code>false</code>.
         * </p>
         * 
         * @param scoreThreshold
         *        The scoring threshold is used in binary classification <code>MLModel</code> models. It marks the
         *        boundary between a positive prediction and a negative prediction.</p>
         *        <p>
         *        Output values greater than or equal to the threshold receive a positive result from the MLModel, such
         *        as <code>true</code>. Output values less than the threshold receive a negative response from the
         *        MLModel, such as <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreThreshold(Float scoreThreshold);

        /**
         * <p>
         * The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.
         * </p>
         * 
         * @param scoreThresholdLastUpdatedAt
         *        The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreThresholdLastUpdatedAt(Instant scoreThresholdLastUpdatedAt);

        /**
         * <p>
         * A link to the file that contains logs of the <code>CreateMLModel</code> operation.
         * </p>
         * 
         * @param logUri
         *        A link to the file that contains logs of the <code>CreateMLModel</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUri(String logUri);

        /**
         * <p>
         * A description of the most recent details about accessing the <code>MLModel</code>.
         * </p>
         * 
         * @param message
         *        A description of the most recent details about accessing the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the
         * <code>MLModel</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only
         * available if the <code>MLModel</code> is in the <code>COMPLETED</code> state.
         * </p>
         * 
         * @param computeTime
         *        The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the
         *        <code>MLModel</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only
         *        available if the <code>MLModel</code> is in the <code>COMPLETED</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTime(Long computeTime);

        /**
         * <p>
         * The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>COMPLETED</code> or
         * <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>MLModel</code> is in the
         * <code>COMPLETED</code> or <code>FAILED</code> state.
         * </p>
         * 
         * @param finishedAt
         *        The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>COMPLETED</code>
         *        or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>MLModel</code> is in
         *        the <code>COMPLETED</code> or <code>FAILED</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finishedAt(Instant finishedAt);

        /**
         * <p>
         * The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>INPROGRESS</code>.
         * <code>StartedAt</code> isn't available if the <code>MLModel</code> is in the <code>PENDING</code> state.
         * </p>
         * 
         * @param startedAt
         *        The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>INPROGRESS</code>
         *        . <code>StartedAt</code> isn't available if the <code>MLModel</code> is in the <code>PENDING</code>
         *        state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The recipe to use when training the <code>MLModel</code>. The <code>Recipe</code> provides detailed
         * information about the observation data to use during training, and manipulations to perform on the
         * observation data during training.
         * </p>
         * <p>
         * <b>Note:</b> This parameter is provided as part of the verbose format.
         * </p>
         * 
         * @param recipe
         *        The recipe to use when training the <code>MLModel</code>. The <code>Recipe</code> provides detailed
         *        information about the observation data to use during training, and manipulations to perform on the
         *        observation data during training.</p>
         *        <p>
         *        <b>Note:</b> This parameter is provided as part of the verbose format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipe(String recipe);

        /**
         * <p>
         * The schema used by all of the data files referenced by the <code>DataSource</code>.
         * </p>
         * <p>
         * <b>Note:</b> This parameter is provided as part of the verbose format.
         * </p>
         * 
         * @param schema
         *        The schema used by all of the data files referenced by the <code>DataSource</code>.</p>
         *        <p>
         *        <b>Note:</b> This parameter is provided as part of the verbose format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private String mlModelId;

        private String trainingDataSourceId;

        private String createdByIamUser;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String name;

        private String status;

        private Long sizeInBytes;

        private RealtimeEndpointInfo endpointInfo;

        private Map<String, String> trainingParameters = DefaultSdkAutoConstructMap.getInstance();

        private String inputDataLocationS3;

        private String mlModelType;

        private Float scoreThreshold;

        private Instant scoreThresholdLastUpdatedAt;

        private String logUri;

        private String message;

        private Long computeTime;

        private Instant finishedAt;

        private Instant startedAt;

        private String recipe;

        private String schema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlModelResponse model) {
            super(model);
            mlModelId(model.mlModelId);
            trainingDataSourceId(model.trainingDataSourceId);
            createdByIamUser(model.createdByIamUser);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            name(model.name);
            status(model.status);
            sizeInBytes(model.sizeInBytes);
            endpointInfo(model.endpointInfo);
            trainingParameters(model.trainingParameters);
            inputDataLocationS3(model.inputDataLocationS3);
            mlModelType(model.mlModelType);
            scoreThreshold(model.scoreThreshold);
            scoreThresholdLastUpdatedAt(model.scoreThresholdLastUpdatedAt);
            logUri(model.logUri);
            message(model.message);
            computeTime(model.computeTime);
            finishedAt(model.finishedAt);
            startedAt(model.startedAt);
            recipe(model.recipe);
            schema(model.schema);
        }

        public final String getMlModelId() {
            return mlModelId;
        }

        public final void setMlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final String getTrainingDataSourceId() {
            return trainingDataSourceId;
        }

        public final void setTrainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
        }

        @Override
        public final Builder trainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
            return this;
        }

        public final String getCreatedByIamUser() {
            return createdByIamUser;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Long getSizeInBytes() {
            return sizeInBytes;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final RealtimeEndpointInfo.Builder getEndpointInfo() {
            return endpointInfo != null ? endpointInfo.toBuilder() : null;
        }

        public final void setEndpointInfo(RealtimeEndpointInfo.BuilderImpl endpointInfo) {
            this.endpointInfo = endpointInfo != null ? endpointInfo.build() : null;
        }

        @Override
        public final Builder endpointInfo(RealtimeEndpointInfo endpointInfo) {
            this.endpointInfo = endpointInfo;
            return this;
        }

        public final Map<String, String> getTrainingParameters() {
            if (trainingParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return trainingParameters;
        }

        public final void setTrainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
        }

        @Override
        public final Builder trainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
            return this;
        }

        public final String getInputDataLocationS3() {
            return inputDataLocationS3;
        }

        public final void setInputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
        }

        @Override
        public final Builder inputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
            return this;
        }

        public final String getMlModelType() {
            return mlModelType;
        }

        public final void setMlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
        }

        @Override
        public final Builder mlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
            return this;
        }

        @Override
        public final Builder mlModelType(MLModelType mlModelType) {
            this.mlModelType(mlModelType == null ? null : mlModelType.toString());
            return this;
        }

        public final Float getScoreThreshold() {
            return scoreThreshold;
        }

        public final void setScoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
        }

        @Override
        public final Builder scoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
            return this;
        }

        public final Instant getScoreThresholdLastUpdatedAt() {
            return scoreThresholdLastUpdatedAt;
        }

        public final void setScoreThresholdLastUpdatedAt(Instant scoreThresholdLastUpdatedAt) {
            this.scoreThresholdLastUpdatedAt = scoreThresholdLastUpdatedAt;
        }

        @Override
        public final Builder scoreThresholdLastUpdatedAt(Instant scoreThresholdLastUpdatedAt) {
            this.scoreThresholdLastUpdatedAt = scoreThresholdLastUpdatedAt;
            return this;
        }

        public final String getLogUri() {
            return logUri;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Long getComputeTime() {
            return computeTime;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final Instant getFinishedAt() {
            return finishedAt;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getRecipe() {
            return recipe;
        }

        public final void setRecipe(String recipe) {
            this.recipe = recipe;
        }

        @Override
        public final Builder recipe(String recipe) {
            this.recipe = recipe;
            return this;
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public GetMlModelResponse build() {
            return new GetMlModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
