/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.machinelearning.MachineLearningAsyncClient;
import software.amazon.awssdk.services.machinelearning.model.DataSource;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse;

public class DescribeDataSourcesPublisher
implements SdkPublisher<DescribeDataSourcesResponse> {
    private final MachineLearningAsyncClient client;
    private final DescribeDataSourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDataSourcesPublisher(MachineLearningAsyncClient client, DescribeDataSourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDataSourcesPublisher(MachineLearningAsyncClient client, DescribeDataSourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDataSourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDataSourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataSource> results() {
        Function<DescribeDataSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDataSourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDataSourcesResponseFetcher
    implements AsyncPageFetcher<DescribeDataSourcesResponse> {
        private DescribeDataSourcesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeDataSourcesResponse> nextPage(DescribeDataSourcesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataSourcesPublisher.this.client.describeDataSources(DescribeDataSourcesPublisher.this.firstRequest);
            }
            return DescribeDataSourcesPublisher.this.client.describeDataSources((DescribeDataSourcesRequest)((Object)DescribeDataSourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

