/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataSourceFromS3Request extends MachineLearningRequest implements
        ToCopyableBuilder<CreateDataSourceFromS3Request.Builder, CreateDataSourceFromS3Request> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceId").getter(getter(CreateDataSourceFromS3Request::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()).build();

    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceName").getter(getter(CreateDataSourceFromS3Request::dataSourceName))
            .setter(setter(Builder::dataSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceName").build()).build();

    private static final SdkField<S3DataSpec> DATA_SPEC_FIELD = SdkField.<S3DataSpec> builder(MarshallingType.SDK_POJO)
            .memberName("DataSpec").getter(getter(CreateDataSourceFromS3Request::dataSpec)).setter(setter(Builder::dataSpec))
            .constructor(S3DataSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSpec").build()).build();

    private static final SdkField<Boolean> COMPUTE_STATISTICS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ComputeStatistics").getter(getter(CreateDataSourceFromS3Request::computeStatistics))
            .setter(setter(Builder::computeStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeStatistics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD,
            DATA_SOURCE_NAME_FIELD, DATA_SPEC_FIELD, COMPUTE_STATISTICS_FIELD));

    private final String dataSourceId;

    private final String dataSourceName;

    private final S3DataSpec dataSpec;

    private final Boolean computeStatistics;

    private CreateDataSourceFromS3Request(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceName = builder.dataSourceName;
        this.dataSpec = builder.dataSpec;
        this.computeStatistics = builder.computeStatistics;
    }

    /**
     * <p>
     * A user-supplied identifier that uniquely identifies the <code>DataSource</code>.
     * </p>
     * 
     * @return A user-supplied identifier that uniquely identifies the <code>DataSource</code>.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>DataSource</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>DataSource</code>.
     */
    public final String dataSourceName() {
        return dataSourceName;
    }

    /**
     * <p>
     * The data specification of a <code>DataSource</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DataLocationS3 - The Amazon S3 location of the observation data.
     * </p>
     * </li>
     * <li>
     * <p>
     * DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
     * specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
     * <code>Datasource</code>.
     * </p>
     * <p>
     * Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The data specification of a <code>DataSource</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DataLocationS3 - The Amazon S3 location of the observation data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
     *         specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
     *         <code>Datasource</code>.
     *         </p>
     *         <p>
     *         Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
     *         </p>
     *         </li>
     */
    public final S3DataSpec dataSpec() {
        return dataSpec;
    }

    /**
     * <p>
     * The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data
     * referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code>
     * training. This parameter must be set to <code>true</code> if the
     * <code/>DataSource<code/> needs to be used for <code>MLModel</code> training.
     * </p>
     * 
     * @return The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation
     *         data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during
     *         <code>MLModel</code> training. This parameter must be set to <code>true</code> if the
     *         <code/>DataSource<code/> needs to be used for <code>MLModel</code> training.
     */
    public final Boolean computeStatistics() {
        return computeStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(dataSpec());
        hashCode = 31 * hashCode + Objects.hashCode(computeStatistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromS3Request)) {
            return false;
        }
        CreateDataSourceFromS3Request other = (CreateDataSourceFromS3Request) obj;
        return Objects.equals(dataSourceId(), other.dataSourceId()) && Objects.equals(dataSourceName(), other.dataSourceName())
                && Objects.equals(dataSpec(), other.dataSpec()) && Objects.equals(computeStatistics(), other.computeStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataSourceFromS3Request").add("DataSourceId", dataSourceId())
                .add("DataSourceName", dataSourceName()).add("DataSpec", dataSpec())
                .add("ComputeStatistics", computeStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "DataSourceName":
            return Optional.ofNullable(clazz.cast(dataSourceName()));
        case "DataSpec":
            return Optional.ofNullable(clazz.cast(dataSpec()));
        case "ComputeStatistics":
            return Optional.ofNullable(clazz.cast(computeStatistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceFromS3Request, T> g) {
        return obj -> g.apply((CreateDataSourceFromS3Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataSourceFromS3Request> {
        /**
         * <p>
         * A user-supplied identifier that uniquely identifies the <code>DataSource</code>.
         * </p>
         * 
         * @param dataSourceId
         *        A user-supplied identifier that uniquely identifies the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * A user-supplied name or description of the <code>DataSource</code>.
         * </p>
         * 
         * @param dataSourceName
         *        A user-supplied name or description of the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceName(String dataSourceName);

        /**
         * <p>
         * The data specification of a <code>DataSource</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DataLocationS3 - The Amazon S3 location of the observation data.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
         * specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
         * <code>Datasource</code>.
         * </p>
         * <p>
         * Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataSpec
         *        The data specification of a <code>DataSource</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DataLocationS3 - The Amazon S3 location of the observation data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code>
         *        is specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
         *        <code>Datasource</code>.
         *        </p>
         *        <p>
         *        Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSpec(S3DataSpec dataSpec);

        /**
         * <p>
         * The data specification of a <code>DataSource</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DataLocationS3 - The Amazon S3 location of the observation data.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
         * specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
         * <code>Datasource</code>.
         * </p>
         * <p>
         * Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link S3DataSpec.Builder} avoiding the need to create
         * one manually via {@link S3DataSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DataSpec.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSpec(S3DataSpec)}.
         * 
         * @param dataSpec
         *        a consumer that will call methods on {@link S3DataSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSpec(S3DataSpec)
         */
        default Builder dataSpec(Consumer<S3DataSpec.Builder> dataSpec) {
            return dataSpec(S3DataSpec.builder().applyMutation(dataSpec).build());
        }

        /**
         * <p>
         * The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data
         * referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code>
         * training. This parameter must be set to <code>true</code> if the
         * <code/>DataSource<code/> needs to be used for <code>MLModel</code> training.
         * </p>
         * 
         * @param computeStatistics
         *        The compute statistics for a <code>DataSource</code>. The statistics are generated from the
         *        observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally
         *        during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the
         *        <code/>DataSource<code/> needs to be used for <code>MLModel</code> training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeStatistics(Boolean computeStatistics);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String dataSourceId;

        private String dataSourceName;

        private S3DataSpec dataSpec;

        private Boolean computeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromS3Request model) {
            super(model);
            dataSourceId(model.dataSourceId);
            dataSourceName(model.dataSourceName);
            dataSpec(model.dataSpec);
            computeStatistics(model.computeStatistics);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataSourceName() {
            return dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final S3DataSpec.Builder getDataSpec() {
            return dataSpec != null ? dataSpec.toBuilder() : null;
        }

        @Override
        public final Builder dataSpec(S3DataSpec dataSpec) {
            this.dataSpec = dataSpec;
            return this;
        }

        public final void setDataSpec(S3DataSpec.BuilderImpl dataSpec) {
            this.dataSpec = dataSpec != null ? dataSpec.build() : null;
        }

        public final Boolean getComputeStatistics() {
            return computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceFromS3Request build() {
            return new CreateDataSourceFromS3Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
