/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RDSDatabase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RDSDatabase> {
    private static final SdkField<String> INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceIdentifier").getter(RDSDatabase.getter(RDSDatabase::instanceIdentifier)).setter(RDSDatabase.setter(Builder::instanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIdentifier").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(RDSDatabase.getter(RDSDatabase::databaseName)).setter(RDSDatabase.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_IDENTIFIER_FIELD, DATABASE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceIdentifier;
    private final String databaseName;

    private RDSDatabase(BuilderImpl builder) {
        this.instanceIdentifier = builder.instanceIdentifier;
        this.databaseName = builder.databaseName;
    }

    public final String instanceIdentifier() {
        return this.instanceIdentifier;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDatabase)) {
            return false;
        }
        RDSDatabase other = (RDSDatabase)obj;
        return Objects.equals(this.instanceIdentifier(), other.instanceIdentifier()) && Objects.equals(this.databaseName(), other.databaseName());
    }

    public final String toString() {
        return ToString.builder((String)"RDSDatabase").add("InstanceIdentifier", (Object)this.instanceIdentifier()).add("DatabaseName", (Object)this.databaseName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.instanceIdentifier()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RDSDatabase, T> g) {
        return obj -> g.apply((RDSDatabase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceIdentifier;
        private String databaseName;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDatabase model) {
            this.instanceIdentifier(model.instanceIdentifier);
            this.databaseName(model.databaseName);
        }

        public final String getInstanceIdentifier() {
            return this.instanceIdentifier;
        }

        @Override
        public final Builder instanceIdentifier(String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
            return this;
        }

        public final void setInstanceIdentifier(String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public RDSDatabase build() {
            return new RDSDatabase(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RDSDatabase> {
        public Builder instanceIdentifier(String var1);

        public Builder databaseName(String var1);
    }
}

