/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.services.machinelearning.model.S3DataSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataSourceFromS3Request
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, CreateDataSourceFromS3Request> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceId").getter(CreateDataSourceFromS3Request.getter(CreateDataSourceFromS3Request::dataSourceId)).setter(CreateDataSourceFromS3Request.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceName").getter(CreateDataSourceFromS3Request.getter(CreateDataSourceFromS3Request::dataSourceName)).setter(CreateDataSourceFromS3Request.setter(Builder::dataSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceName").build()}).build();
    private static final SdkField<S3DataSpec> DATA_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSpec").getter(CreateDataSourceFromS3Request.getter(CreateDataSourceFromS3Request::dataSpec)).setter(CreateDataSourceFromS3Request.setter(Builder::dataSpec)).constructor(S3DataSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSpec").build()}).build();
    private static final SdkField<Boolean> COMPUTE_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ComputeStatistics").getter(CreateDataSourceFromS3Request.getter(CreateDataSourceFromS3Request::computeStatistics)).setter(CreateDataSourceFromS3Request.setter(Builder::computeStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeStatistics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD, DATA_SOURCE_NAME_FIELD, DATA_SPEC_FIELD, COMPUTE_STATISTICS_FIELD));
    private final String dataSourceId;
    private final String dataSourceName;
    private final S3DataSpec dataSpec;
    private final Boolean computeStatistics;

    private CreateDataSourceFromS3Request(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceName = builder.dataSourceName;
        this.dataSpec = builder.dataSpec;
        this.computeStatistics = builder.computeStatistics;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String dataSourceName() {
        return this.dataSourceName;
    }

    public final S3DataSpec dataSpec() {
        return this.dataSpec;
    }

    public final Boolean computeStatistics() {
        return this.computeStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeStatistics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromS3Request)) {
            return false;
        }
        CreateDataSourceFromS3Request other = (CreateDataSourceFromS3Request)((Object)obj);
        return Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.dataSourceName(), other.dataSourceName()) && Objects.equals(this.dataSpec(), other.dataSpec()) && Objects.equals(this.computeStatistics(), other.computeStatistics());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataSourceFromS3Request").add("DataSourceId", (Object)this.dataSourceId()).add("DataSourceName", (Object)this.dataSourceName()).add("DataSpec", (Object)this.dataSpec()).add("ComputeStatistics", (Object)this.computeStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "DataSourceName": {
                return Optional.ofNullable(clazz.cast(this.dataSourceName()));
            }
            case "DataSpec": {
                return Optional.ofNullable(clazz.cast(this.dataSpec()));
            }
            case "ComputeStatistics": {
                return Optional.ofNullable(clazz.cast(this.computeStatistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceFromS3Request, T> g) {
        return obj -> g.apply((CreateDataSourceFromS3Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String dataSourceName;
        private S3DataSpec dataSpec;
        private Boolean computeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromS3Request model) {
            super(model);
            this.dataSourceId(model.dataSourceId);
            this.dataSourceName(model.dataSourceName);
            this.dataSpec(model.dataSpec);
            this.computeStatistics(model.computeStatistics);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final S3DataSpec.Builder getDataSpec() {
            return this.dataSpec != null ? this.dataSpec.toBuilder() : null;
        }

        @Override
        public final Builder dataSpec(S3DataSpec dataSpec) {
            this.dataSpec = dataSpec;
            return this;
        }

        public final void setDataSpec(S3DataSpec.BuilderImpl dataSpec) {
            this.dataSpec = dataSpec != null ? dataSpec.build() : null;
        }

        public final Boolean getComputeStatistics() {
            return this.computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceFromS3Request build() {
            return new CreateDataSourceFromS3Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataSourceFromS3Request> {
        public Builder dataSourceId(String var1);

        public Builder dataSourceName(String var1);

        public Builder dataSpec(S3DataSpec var1);

        default public Builder dataSpec(Consumer<S3DataSpec.Builder> dataSpec) {
            return this.dataSpec((S3DataSpec)((S3DataSpec.Builder)S3DataSpec.builder().applyMutation(dataSpec)).build());
        }

        public Builder computeStatistics(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

