/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataSourceFromRedshiftRequest extends MachineLearningRequest implements
        ToCopyableBuilder<CreateDataSourceFromRedshiftRequest.Builder, CreateDataSourceFromRedshiftRequest> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceId").getter(getter(CreateDataSourceFromRedshiftRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()).build();

    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceName").getter(getter(CreateDataSourceFromRedshiftRequest::dataSourceName))
            .setter(setter(Builder::dataSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceName").build()).build();

    private static final SdkField<RedshiftDataSpec> DATA_SPEC_FIELD = SdkField
            .<RedshiftDataSpec> builder(MarshallingType.SDK_POJO).memberName("DataSpec")
            .getter(getter(CreateDataSourceFromRedshiftRequest::dataSpec)).setter(setter(Builder::dataSpec))
            .constructor(RedshiftDataSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSpec").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(CreateDataSourceFromRedshiftRequest::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<Boolean> COMPUTE_STATISTICS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ComputeStatistics").getter(getter(CreateDataSourceFromRedshiftRequest::computeStatistics))
            .setter(setter(Builder::computeStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeStatistics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD,
            DATA_SOURCE_NAME_FIELD, DATA_SPEC_FIELD, ROLE_ARN_FIELD, COMPUTE_STATISTICS_FIELD));

    private final String dataSourceId;

    private final String dataSourceName;

    private final RedshiftDataSpec dataSpec;

    private final String roleARN;

    private final Boolean computeStatistics;

    private CreateDataSourceFromRedshiftRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceName = builder.dataSourceName;
        this.dataSpec = builder.dataSpec;
        this.roleARN = builder.roleARN;
        this.computeStatistics = builder.computeStatistics;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the <code>DataSource</code>.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the <code>DataSource</code>.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>DataSource</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>DataSource</code>.
     */
    public final String dataSourceName() {
        return dataSourceName;
    }

    /**
     * <p>
     * The data specification of an Amazon Redshift <code>DataSource</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DatabaseInformation -
     * <ul>
     * <li> <code>DatabaseName</code> - The name of the Amazon Redshift database.</li>
     * <li> <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</li>
     * </ul>
     * </p>
     * </li>
     * <li>
     * <p>
     * DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to the
     * Amazon Redshift database.
     * </p>
     * </li>
     * <li>
     * <p>
     * SelectSqlQuery - The query that is used to retrieve the observation data for the <code>Datasource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon Redshift data. The
     * data retrieved from Amazon Redshift using the <code>SelectSqlQuery</code> query is stored in this location.
     * </p>
     * </li>
     * <li>
     * <p>
     * DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
     * specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
     * <code>DataSource</code>.
     * </p>
     * <p>
     * Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The data specification of an Amazon Redshift <code>DataSource</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DatabaseInformation -
     *         <ul>
     *         <li> <code>DatabaseName</code> - The name of the Amazon Redshift database.</li>
     *         <li> <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</li>
     *         </ul>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect
     *         to the Amazon Redshift database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SelectSqlQuery - The query that is used to retrieve the observation data for the <code>Datasource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon Redshift
     *         data. The data retrieved from Amazon Redshift using the <code>SelectSqlQuery</code> query is stored in
     *         this location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
     *         specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
     *         <code>DataSource</code>.
     *         </p>
     *         <p>
     *         Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
     *         </p>
     *         </li>
     */
    public final RedshiftDataSpec dataSpec() {
        return dataSpec;
    }

    /**
     * <p>
     * A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create the
     * following:
     * </p>
     * <p>
     * <ul>
     * <li>
     * <p>
     * A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon Redshift
     * cluster
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the <code>S3StagingLocation</code>
     * </p>
     * </li>
     * </ul>
     * </p>
     * 
     * @return A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to
     *         create the following: </p>
     *         <p>
     *         <ul>
     *         <li>
     *         <p>
     *         A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon
     *         Redshift cluster
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the
     *         <code>S3StagingLocation</code>
     *         </p>
     *         </li>
     *         </ul>
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data
     * referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code>
     * training. This parameter must be set to <code>true</code> if the <code>DataSource</code> needs to be used for
     * <code>MLModel</code> training.
     * </p>
     * 
     * @return The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation
     *         data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during
     *         <code>MLModel</code> training. This parameter must be set to <code>true</code> if the
     *         <code>DataSource</code> needs to be used for <code>MLModel</code> training.
     */
    public final Boolean computeStatistics() {
        return computeStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(dataSpec());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(computeStatistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromRedshiftRequest)) {
            return false;
        }
        CreateDataSourceFromRedshiftRequest other = (CreateDataSourceFromRedshiftRequest) obj;
        return Objects.equals(dataSourceId(), other.dataSourceId()) && Objects.equals(dataSourceName(), other.dataSourceName())
                && Objects.equals(dataSpec(), other.dataSpec()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(computeStatistics(), other.computeStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataSourceFromRedshiftRequest").add("DataSourceId", dataSourceId())
                .add("DataSourceName", dataSourceName()).add("DataSpec", dataSpec()).add("RoleARN", roleARN())
                .add("ComputeStatistics", computeStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "DataSourceName":
            return Optional.ofNullable(clazz.cast(dataSourceName()));
        case "DataSpec":
            return Optional.ofNullable(clazz.cast(dataSpec()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "ComputeStatistics":
            return Optional.ofNullable(clazz.cast(computeStatistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceFromRedshiftRequest, T> g) {
        return obj -> g.apply((CreateDataSourceFromRedshiftRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataSourceFromRedshiftRequest> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the <code>DataSource</code>.
         * </p>
         * 
         * @param dataSourceId
         *        A user-supplied ID that uniquely identifies the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * A user-supplied name or description of the <code>DataSource</code>.
         * </p>
         * 
         * @param dataSourceName
         *        A user-supplied name or description of the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceName(String dataSourceName);

        /**
         * <p>
         * The data specification of an Amazon Redshift <code>DataSource</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DatabaseInformation -
         * <ul>
         * <li> <code>DatabaseName</code> - The name of the Amazon Redshift database.</li>
         * <li> <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</li>
         * </ul>
         * </p>
         * </li>
         * <li>
         * <p>
         * DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to
         * the Amazon Redshift database.
         * </p>
         * </li>
         * <li>
         * <p>
         * SelectSqlQuery - The query that is used to retrieve the observation data for the <code>Datasource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon Redshift data.
         * The data retrieved from Amazon Redshift using the <code>SelectSqlQuery</code> query is stored in this
         * location.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
         * specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
         * <code>DataSource</code>.
         * </p>
         * <p>
         * Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataSpec
         *        The data specification of an Amazon Redshift <code>DataSource</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DatabaseInformation -
         *        <ul>
         *        <li> <code>DatabaseName</code> - The name of the Amazon Redshift database.</li>
         *        <li> <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</li>
         *        </ul>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to
         *        connect to the Amazon Redshift database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SelectSqlQuery - The query that is used to retrieve the observation data for the
         *        <code>Datasource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon Redshift
         *        data. The data retrieved from Amazon Redshift using the <code>SelectSqlQuery</code> query is stored in
         *        this location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code>
         *        is specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
         *        <code>DataSource</code>.
         *        </p>
         *        <p>
         *        Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSpec(RedshiftDataSpec dataSpec);

        /**
         * <p>
         * The data specification of an Amazon Redshift <code>DataSource</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DatabaseInformation -
         * <ul>
         * <li> <code>DatabaseName</code> - The name of the Amazon Redshift database.</li>
         * <li> <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</li>
         * </ul>
         * </p>
         * </li>
         * <li>
         * <p>
         * DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to
         * the Amazon Redshift database.
         * </p>
         * </li>
         * <li>
         * <p>
         * SelectSqlQuery - The query that is used to retrieve the observation data for the <code>Datasource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon Redshift data.
         * The data retrieved from Amazon Redshift using the <code>SelectSqlQuery</code> query is stored in this
         * location.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
         * specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
         * <code>DataSource</code>.
         * </p>
         * <p>
         * Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link RedshiftDataSpec.Builder} avoiding the need to
         * create one manually via {@link RedshiftDataSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link RedshiftDataSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSpec(RedshiftDataSpec)}.
         * 
         * @param dataSpec
         *        a consumer that will call methods on {@link RedshiftDataSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSpec(RedshiftDataSpec)
         */
        default Builder dataSpec(Consumer<RedshiftDataSpec.Builder> dataSpec) {
            return dataSpec(RedshiftDataSpec.builder().applyMutation(dataSpec).build());
        }

        /**
         * <p>
         * A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create
         * the following:
         * </p>
         * <p>
         * <ul>
         * <li>
         * <p>
         * A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon Redshift
         * cluster
         * </p>
         * </li>
         * <li>
         * <p>
         * An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the <code>S3StagingLocation</code>
         * </p>
         * </li>
         * </ul>
         * </p>
         * 
         * @param roleARN
         *        A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to
         *        create the following: </p>
         *        <p>
         *        <ul>
         *        <li>
         *        <p>
         *        A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon
         *        Redshift cluster
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the
         *        <code>S3StagingLocation</code>
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data
         * referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code>
         * training. This parameter must be set to <code>true</code> if the <code>DataSource</code> needs to be used for
         * <code>MLModel</code> training.
         * </p>
         * 
         * @param computeStatistics
         *        The compute statistics for a <code>DataSource</code>. The statistics are generated from the
         *        observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally
         *        during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the
         *        <code>DataSource</code> needs to be used for <code>MLModel</code> training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeStatistics(Boolean computeStatistics);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String dataSourceId;

        private String dataSourceName;

        private RedshiftDataSpec dataSpec;

        private String roleARN;

        private Boolean computeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromRedshiftRequest model) {
            super(model);
            dataSourceId(model.dataSourceId);
            dataSourceName(model.dataSourceName);
            dataSpec(model.dataSpec);
            roleARN(model.roleARN);
            computeStatistics(model.computeStatistics);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataSourceName() {
            return dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final RedshiftDataSpec.Builder getDataSpec() {
            return dataSpec != null ? dataSpec.toBuilder() : null;
        }

        @Override
        public final Builder dataSpec(RedshiftDataSpec dataSpec) {
            this.dataSpec = dataSpec;
            return this;
        }

        public final void setDataSpec(RedshiftDataSpec.BuilderImpl dataSpec) {
            this.dataSpec = dataSpec != null ? dataSpec.build() : null;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Boolean getComputeStatistics() {
            return computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceFromRedshiftRequest build() {
            return new CreateDataSourceFromRedshiftRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
