/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon ML returns the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddTagsResponse extends MachineLearningResponse implements
        ToCopyableBuilder<AddTagsResponse.Builder, AddTagsResponse> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(AddTagsResponse::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(AddTagsResponse::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            RESOURCE_TYPE_FIELD));

    private final String resourceId;

    private final String resourceType;

    private AddTagsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The ID of the ML object that was tagged.
     * </p>
     * 
     * @return The ID of the ML object that was tagged.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of the ML object that was tagged.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TaggableResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the ML object that was tagged.
     * @see TaggableResourceType
     */
    public final TaggableResourceType resourceType() {
        return TaggableResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the ML object that was tagged.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TaggableResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the ML object that was tagged.
     * @see TaggableResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsResponse)) {
            return false;
        }
        AddTagsResponse other = (AddTagsResponse) obj;
        return Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddTagsResponse").add("ResourceId", resourceId()).add("ResourceType", resourceTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddTagsResponse, T> g) {
        return obj -> g.apply((AddTagsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningResponse.Builder, SdkPojo, CopyableBuilder<Builder, AddTagsResponse> {
        /**
         * <p>
         * The ID of the ML object that was tagged.
         * </p>
         * 
         * @param resourceId
         *        The ID of the ML object that was tagged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of the ML object that was tagged.
         * </p>
         * 
         * @param resourceType
         *        The type of the ML object that was tagged.
         * @see TaggableResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaggableResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the ML object that was tagged.
         * </p>
         * 
         * @param resourceType
         *        The type of the ML object that was tagged.
         * @see TaggableResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaggableResourceType
         */
        Builder resourceType(TaggableResourceType resourceType);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private String resourceId;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(AddTagsResponse model) {
            super(model);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TaggableResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public AddTagsResponse build() {
            return new AddTagsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
