/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.machinelearning.model.RedshiftDatabase;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftMetadata> {
    private static final SdkField<RedshiftDatabase> REDSHIFT_DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RedshiftDatabase").getter(RedshiftMetadata.getter(RedshiftMetadata::redshiftDatabase)).setter(RedshiftMetadata.setter(Builder::redshiftDatabase)).constructor(RedshiftDatabase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDatabase").build()}).build();
    private static final SdkField<String> DATABASE_USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseUserName").getter(RedshiftMetadata.getter(RedshiftMetadata::databaseUserName)).setter(RedshiftMetadata.setter(Builder::databaseUserName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseUserName").build()}).build();
    private static final SdkField<String> SELECT_SQL_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectSqlQuery").getter(RedshiftMetadata.getter(RedshiftMetadata::selectSqlQuery)).setter(RedshiftMetadata.setter(Builder::selectSqlQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectSqlQuery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDSHIFT_DATABASE_FIELD, DATABASE_USER_NAME_FIELD, SELECT_SQL_QUERY_FIELD));
    private static final long serialVersionUID = 1L;
    private final RedshiftDatabase redshiftDatabase;
    private final String databaseUserName;
    private final String selectSqlQuery;

    private RedshiftMetadata(BuilderImpl builder) {
        this.redshiftDatabase = builder.redshiftDatabase;
        this.databaseUserName = builder.databaseUserName;
        this.selectSqlQuery = builder.selectSqlQuery;
    }

    public RedshiftDatabase redshiftDatabase() {
        return this.redshiftDatabase;
    }

    public String databaseUserName() {
        return this.databaseUserName;
    }

    public String selectSqlQuery() {
        return this.selectSqlQuery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftDatabase());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseUserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectSqlQuery());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftMetadata)) {
            return false;
        }
        RedshiftMetadata other = (RedshiftMetadata)obj;
        return Objects.equals(this.redshiftDatabase(), other.redshiftDatabase()) && Objects.equals(this.databaseUserName(), other.databaseUserName()) && Objects.equals(this.selectSqlQuery(), other.selectSqlQuery());
    }

    public String toString() {
        return ToString.builder((String)"RedshiftMetadata").add("RedshiftDatabase", (Object)this.redshiftDatabase()).add("DatabaseUserName", (Object)this.databaseUserName()).add("SelectSqlQuery", (Object)this.selectSqlQuery()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RedshiftDatabase": {
                return Optional.ofNullable(clazz.cast(this.redshiftDatabase()));
            }
            case "DatabaseUserName": {
                return Optional.ofNullable(clazz.cast(this.databaseUserName()));
            }
            case "SelectSqlQuery": {
                return Optional.ofNullable(clazz.cast(this.selectSqlQuery()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftMetadata, T> g) {
        return obj -> g.apply((RedshiftMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RedshiftDatabase redshiftDatabase;
        private String databaseUserName;
        private String selectSqlQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftMetadata model) {
            this.redshiftDatabase(model.redshiftDatabase);
            this.databaseUserName(model.databaseUserName);
            this.selectSqlQuery(model.selectSqlQuery);
        }

        public final RedshiftDatabase.Builder getRedshiftDatabase() {
            return this.redshiftDatabase != null ? this.redshiftDatabase.toBuilder() : null;
        }

        @Override
        public final Builder redshiftDatabase(RedshiftDatabase redshiftDatabase) {
            this.redshiftDatabase = redshiftDatabase;
            return this;
        }

        public final void setRedshiftDatabase(RedshiftDatabase.BuilderImpl redshiftDatabase) {
            this.redshiftDatabase = redshiftDatabase != null ? redshiftDatabase.build() : null;
        }

        public final String getDatabaseUserName() {
            return this.databaseUserName;
        }

        @Override
        public final Builder databaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
            return this;
        }

        public final void setDatabaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
        }

        public final String getSelectSqlQuery() {
            return this.selectSqlQuery;
        }

        @Override
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        public RedshiftMetadata build() {
            return new RedshiftMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftMetadata> {
        public Builder redshiftDatabase(RedshiftDatabase var1);

        default public Builder redshiftDatabase(Consumer<RedshiftDatabase.Builder> redshiftDatabase) {
            return this.redshiftDatabase((RedshiftDatabase)((RedshiftDatabase.Builder)RedshiftDatabase.builder().applyMutation(redshiftDatabase)).build());
        }

        public Builder databaseUserName(String var1);

        public Builder selectSqlQuery(String var1);
    }
}

