/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.machinelearning.model.DetailsAttributes;
import software.amazon.awssdk.services.machinelearning.model.DetailsMapCopier;
import software.amazon.awssdk.services.machinelearning.model.ScoreValuePerLabelMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Prediction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Prediction> {
    private static final SdkField<String> PREDICTED_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("predictedLabel").getter(Prediction.getter(Prediction::predictedLabel)).setter(Prediction.setter(Builder::predictedLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictedLabel").build()}).build();
    private static final SdkField<Float> PREDICTED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("predictedValue").getter(Prediction.getter(Prediction::predictedValue)).setter(Prediction.setter(Builder::predictedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictedValue").build()}).build();
    private static final SdkField<Map<String, Float>> PREDICTED_SCORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("predictedScores").getter(Prediction.getter(Prediction::predictedScores)).setter(Prediction.setter(Builder::predictedScores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictedScores").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.FLOAT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("details").getter(Prediction.getter(Prediction::detailsAsStrings)).setter(Prediction.setter(Builder::detailsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTED_LABEL_FIELD, PREDICTED_VALUE_FIELD, PREDICTED_SCORES_FIELD, DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String predictedLabel;
    private final Float predictedValue;
    private final Map<String, Float> predictedScores;
    private final Map<String, String> details;

    private Prediction(BuilderImpl builder) {
        this.predictedLabel = builder.predictedLabel;
        this.predictedValue = builder.predictedValue;
        this.predictedScores = builder.predictedScores;
        this.details = builder.details;
    }

    public String predictedLabel() {
        return this.predictedLabel;
    }

    public Float predictedValue() {
        return this.predictedValue;
    }

    public boolean hasPredictedScores() {
        return this.predictedScores != null && !(this.predictedScores instanceof SdkAutoConstructMap);
    }

    public Map<String, Float> predictedScores() {
        return this.predictedScores;
    }

    public Map<DetailsAttributes, String> details() {
        return DetailsMapCopier.copyStringToEnum(this.details);
    }

    public boolean hasDetails() {
        return this.details != null && !(this.details instanceof SdkAutoConstructMap);
    }

    public Map<String, String> detailsAsStrings() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.predictedLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictedValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictedScores());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Prediction)) {
            return false;
        }
        Prediction other = (Prediction)obj;
        return Objects.equals(this.predictedLabel(), other.predictedLabel()) && Objects.equals(this.predictedValue(), other.predictedValue()) && Objects.equals(this.predictedScores(), other.predictedScores()) && Objects.equals(this.detailsAsStrings(), other.detailsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"Prediction").add("PredictedLabel", (Object)this.predictedLabel()).add("PredictedValue", (Object)this.predictedValue()).add("PredictedScores", this.predictedScores()).add("Details", this.detailsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "predictedLabel": {
                return Optional.ofNullable(clazz.cast(this.predictedLabel()));
            }
            case "predictedValue": {
                return Optional.ofNullable(clazz.cast(this.predictedValue()));
            }
            case "predictedScores": {
                return Optional.ofNullable(clazz.cast(this.predictedScores()));
            }
            case "details": {
                return Optional.ofNullable(clazz.cast(this.detailsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Prediction, T> g) {
        return obj -> g.apply((Prediction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String predictedLabel;
        private Float predictedValue;
        private Map<String, Float> predictedScores = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> details = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Prediction model) {
            this.predictedLabel(model.predictedLabel);
            this.predictedValue(model.predictedValue);
            this.predictedScores(model.predictedScores);
            this.detailsWithStrings(model.details);
        }

        public final String getPredictedLabel() {
            return this.predictedLabel;
        }

        @Override
        public final Builder predictedLabel(String predictedLabel) {
            this.predictedLabel = predictedLabel;
            return this;
        }

        public final void setPredictedLabel(String predictedLabel) {
            this.predictedLabel = predictedLabel;
        }

        public final Float getPredictedValue() {
            return this.predictedValue;
        }

        @Override
        public final Builder predictedValue(Float predictedValue) {
            this.predictedValue = predictedValue;
            return this;
        }

        public final void setPredictedValue(Float predictedValue) {
            this.predictedValue = predictedValue;
        }

        public final Map<String, Float> getPredictedScores() {
            return this.predictedScores;
        }

        @Override
        public final Builder predictedScores(Map<String, Float> predictedScores) {
            this.predictedScores = ScoreValuePerLabelMapCopier.copy(predictedScores);
            return this;
        }

        public final void setPredictedScores(Map<String, Float> predictedScores) {
            this.predictedScores = ScoreValuePerLabelMapCopier.copy(predictedScores);
        }

        public final Map<String, String> getDetails() {
            return this.details;
        }

        @Override
        public final Builder detailsWithStrings(Map<String, String> details) {
            this.details = DetailsMapCopier.copy(details);
            return this;
        }

        @Override
        public final Builder details(Map<DetailsAttributes, String> details) {
            this.details = DetailsMapCopier.copyEnumToString(details);
            return this;
        }

        public final void setDetails(Map<String, String> details) {
            this.details = DetailsMapCopier.copy(details);
        }

        public Prediction build() {
            return new Prediction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Prediction> {
        public Builder predictedLabel(String var1);

        public Builder predictedValue(Float var1);

        public Builder predictedScores(Map<String, Float> var1);

        public Builder detailsWithStrings(Map<String, String> var1);

        public Builder details(Map<DetailsAttributes, String> var1);
    }
}

