/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.machinelearning.model.EntityStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPrediction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchPrediction> {
    private static final SdkField<String> BATCH_PREDICTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchPrediction.getter(BatchPrediction::batchPredictionId)).setter(BatchPrediction.setter(Builder::batchPredictionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchPredictionId").build()}).build();
    private static final SdkField<String> ML_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchPrediction.getter(BatchPrediction::mlModelId)).setter(BatchPrediction.setter(Builder::mlModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelId").build()}).build();
    private static final SdkField<String> BATCH_PREDICTION_DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchPrediction.getter(BatchPrediction::batchPredictionDataSourceId)).setter(BatchPrediction.setter(Builder::batchPredictionDataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchPredictionDataSourceId").build()}).build();
    private static final SdkField<String> INPUT_DATA_LOCATION_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchPrediction.getter(BatchPrediction::inputDataLocationS3)).setter(BatchPrediction.setter(Builder::inputDataLocationS3)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataLocationS3").build()}).build();
    private static final SdkField<String> CREATED_BY_IAM_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchPrediction.getter(BatchPrediction::createdByIamUser)).setter(BatchPrediction.setter(Builder::createdByIamUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByIamUser").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(BatchPrediction.getter(BatchPrediction::createdAt)).setter(BatchPrediction.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(BatchPrediction.getter(BatchPrediction::lastUpdatedAt)).setter(BatchPrediction.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchPrediction.getter(BatchPrediction::name)).setter(BatchPrediction.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchPrediction.getter(BatchPrediction::statusAsString)).setter(BatchPrediction.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> OUTPUT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchPrediction.getter(BatchPrediction::outputUri)).setter(BatchPrediction.setter(Builder::outputUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputUri").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchPrediction.getter(BatchPrediction::message)).setter(BatchPrediction.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Long> COMPUTE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(BatchPrediction.getter(BatchPrediction::computeTime)).setter(BatchPrediction.setter(Builder::computeTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeTime").build()}).build();
    private static final SdkField<Instant> FINISHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(BatchPrediction.getter(BatchPrediction::finishedAt)).setter(BatchPrediction.setter(Builder::finishedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinishedAt").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(BatchPrediction.getter(BatchPrediction::startedAt)).setter(BatchPrediction.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build()}).build();
    private static final SdkField<Long> TOTAL_RECORD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(BatchPrediction.getter(BatchPrediction::totalRecordCount)).setter(BatchPrediction.setter(Builder::totalRecordCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRecordCount").build()}).build();
    private static final SdkField<Long> INVALID_RECORD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(BatchPrediction.getter(BatchPrediction::invalidRecordCount)).setter(BatchPrediction.setter(Builder::invalidRecordCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidRecordCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_PREDICTION_ID_FIELD, ML_MODEL_ID_FIELD, BATCH_PREDICTION_DATA_SOURCE_ID_FIELD, INPUT_DATA_LOCATION_S3_FIELD, CREATED_BY_IAM_USER_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, STATUS_FIELD, OUTPUT_URI_FIELD, MESSAGE_FIELD, COMPUTE_TIME_FIELD, FINISHED_AT_FIELD, STARTED_AT_FIELD, TOTAL_RECORD_COUNT_FIELD, INVALID_RECORD_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String batchPredictionId;
    private final String mlModelId;
    private final String batchPredictionDataSourceId;
    private final String inputDataLocationS3;
    private final String createdByIamUser;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String name;
    private final String status;
    private final String outputUri;
    private final String message;
    private final Long computeTime;
    private final Instant finishedAt;
    private final Instant startedAt;
    private final Long totalRecordCount;
    private final Long invalidRecordCount;

    private BatchPrediction(BuilderImpl builder) {
        this.batchPredictionId = builder.batchPredictionId;
        this.mlModelId = builder.mlModelId;
        this.batchPredictionDataSourceId = builder.batchPredictionDataSourceId;
        this.inputDataLocationS3 = builder.inputDataLocationS3;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.outputUri = builder.outputUri;
        this.message = builder.message;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
        this.totalRecordCount = builder.totalRecordCount;
        this.invalidRecordCount = builder.invalidRecordCount;
    }

    public String batchPredictionId() {
        return this.batchPredictionId;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public String batchPredictionDataSourceId() {
        return this.batchPredictionDataSourceId;
    }

    public String inputDataLocationS3() {
        return this.inputDataLocationS3;
    }

    public String createdByIamUser() {
        return this.createdByIamUser;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public String name() {
        return this.name;
    }

    public EntityStatus status() {
        return EntityStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String outputUri() {
        return this.outputUri;
    }

    public String message() {
        return this.message;
    }

    public Long computeTime() {
        return this.computeTime;
    }

    public Instant finishedAt() {
        return this.finishedAt;
    }

    public Instant startedAt() {
        return this.startedAt;
    }

    public Long totalRecordCount() {
        return this.totalRecordCount;
    }

    public Long invalidRecordCount() {
        return this.invalidRecordCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.batchPredictionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchPredictionDataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataLocationS3());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdByIamUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.finishedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRecordCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidRecordCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPrediction)) {
            return false;
        }
        BatchPrediction other = (BatchPrediction)obj;
        return Objects.equals(this.batchPredictionId(), other.batchPredictionId()) && Objects.equals(this.mlModelId(), other.mlModelId()) && Objects.equals(this.batchPredictionDataSourceId(), other.batchPredictionDataSourceId()) && Objects.equals(this.inputDataLocationS3(), other.inputDataLocationS3()) && Objects.equals(this.createdByIamUser(), other.createdByIamUser()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.outputUri(), other.outputUri()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.computeTime(), other.computeTime()) && Objects.equals(this.finishedAt(), other.finishedAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.totalRecordCount(), other.totalRecordCount()) && Objects.equals(this.invalidRecordCount(), other.invalidRecordCount());
    }

    public String toString() {
        return ToString.builder((String)"BatchPrediction").add("BatchPredictionId", (Object)this.batchPredictionId()).add("MLModelId", (Object)this.mlModelId()).add("BatchPredictionDataSourceId", (Object)this.batchPredictionDataSourceId()).add("InputDataLocationS3", (Object)this.inputDataLocationS3()).add("CreatedByIamUser", (Object)this.createdByIamUser()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("OutputUri", (Object)this.outputUri()).add("Message", (Object)this.message()).add("ComputeTime", (Object)this.computeTime()).add("FinishedAt", (Object)this.finishedAt()).add("StartedAt", (Object)this.startedAt()).add("TotalRecordCount", (Object)this.totalRecordCount()).add("InvalidRecordCount", (Object)this.invalidRecordCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BatchPredictionId": {
                return Optional.ofNullable(clazz.cast(this.batchPredictionId()));
            }
            case "MLModelId": {
                return Optional.ofNullable(clazz.cast(this.mlModelId()));
            }
            case "BatchPredictionDataSourceId": {
                return Optional.ofNullable(clazz.cast(this.batchPredictionDataSourceId()));
            }
            case "InputDataLocationS3": {
                return Optional.ofNullable(clazz.cast(this.inputDataLocationS3()));
            }
            case "CreatedByIamUser": {
                return Optional.ofNullable(clazz.cast(this.createdByIamUser()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "OutputUri": {
                return Optional.ofNullable(clazz.cast(this.outputUri()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ComputeTime": {
                return Optional.ofNullable(clazz.cast(this.computeTime()));
            }
            case "FinishedAt": {
                return Optional.ofNullable(clazz.cast(this.finishedAt()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "TotalRecordCount": {
                return Optional.ofNullable(clazz.cast(this.totalRecordCount()));
            }
            case "InvalidRecordCount": {
                return Optional.ofNullable(clazz.cast(this.invalidRecordCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPrediction, T> g) {
        return obj -> g.apply((BatchPrediction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String batchPredictionId;
        private String mlModelId;
        private String batchPredictionDataSourceId;
        private String inputDataLocationS3;
        private String createdByIamUser;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String name;
        private String status;
        private String outputUri;
        private String message;
        private Long computeTime;
        private Instant finishedAt;
        private Instant startedAt;
        private Long totalRecordCount;
        private Long invalidRecordCount;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPrediction model) {
            this.batchPredictionId(model.batchPredictionId);
            this.mlModelId(model.mlModelId);
            this.batchPredictionDataSourceId(model.batchPredictionDataSourceId);
            this.inputDataLocationS3(model.inputDataLocationS3);
            this.createdByIamUser(model.createdByIamUser);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.name(model.name);
            this.status(model.status);
            this.outputUri(model.outputUri);
            this.message(model.message);
            this.computeTime(model.computeTime);
            this.finishedAt(model.finishedAt);
            this.startedAt(model.startedAt);
            this.totalRecordCount(model.totalRecordCount);
            this.invalidRecordCount(model.invalidRecordCount);
        }

        public final String getBatchPredictionId() {
            return this.batchPredictionId;
        }

        @Override
        public final Builder batchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
            return this;
        }

        public final void setBatchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
        }

        public final String getMlModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getBatchPredictionDataSourceId() {
            return this.batchPredictionDataSourceId;
        }

        @Override
        public final Builder batchPredictionDataSourceId(String batchPredictionDataSourceId) {
            this.batchPredictionDataSourceId = batchPredictionDataSourceId;
            return this;
        }

        public final void setBatchPredictionDataSourceId(String batchPredictionDataSourceId) {
            this.batchPredictionDataSourceId = batchPredictionDataSourceId;
        }

        public final String getInputDataLocationS3() {
            return this.inputDataLocationS3;
        }

        @Override
        public final Builder inputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
            return this;
        }

        public final void setInputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
        }

        public final String getCreatedByIamUser() {
            return this.createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getOutputUri() {
            return this.outputUri;
        }

        @Override
        public final Builder outputUri(String outputUri) {
            this.outputUri = outputUri;
            return this;
        }

        public final void setOutputUri(String outputUri) {
            this.outputUri = outputUri;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Long getComputeTime() {
            return this.computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        public final Instant getFinishedAt() {
            return this.finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public final Long getTotalRecordCount() {
            return this.totalRecordCount;
        }

        @Override
        public final Builder totalRecordCount(Long totalRecordCount) {
            this.totalRecordCount = totalRecordCount;
            return this;
        }

        public final void setTotalRecordCount(Long totalRecordCount) {
            this.totalRecordCount = totalRecordCount;
        }

        public final Long getInvalidRecordCount() {
            return this.invalidRecordCount;
        }

        @Override
        public final Builder invalidRecordCount(Long invalidRecordCount) {
            this.invalidRecordCount = invalidRecordCount;
            return this;
        }

        public final void setInvalidRecordCount(Long invalidRecordCount) {
            this.invalidRecordCount = invalidRecordCount;
        }

        public BatchPrediction build() {
            return new BatchPrediction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchPrediction> {
        public Builder batchPredictionId(String var1);

        public Builder mlModelId(String var1);

        public Builder batchPredictionDataSourceId(String var1);

        public Builder inputDataLocationS3(String var1);

        public Builder createdByIamUser(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(EntityStatus var1);

        public Builder outputUri(String var1);

        public Builder message(String var1);

        public Builder computeTime(Long var1);

        public Builder finishedAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder totalRecordCount(Long var1);

        public Builder invalidRecordCount(Long var1);
    }
}

