/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataSourceRequest extends MachineLearningRequest implements
        ToCopyableBuilder<GetDataSourceRequest.Builder, GetDataSourceRequest> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDataSourceRequest::dataSourceId)).setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()).build();

    private static final SdkField<Boolean> VERBOSE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetDataSourceRequest::verbose)).setter(setter(Builder::verbose))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Verbose").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD,
            VERBOSE_FIELD));

    private final String dataSourceId;

    private final Boolean verbose;

    private GetDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.verbose = builder.verbose;
    }

    /**
     * <p>
     * The ID assigned to the <code>DataSource</code> at creation.
     * </p>
     * 
     * @return The ID assigned to the <code>DataSource</code> at creation.
     */
    public String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>.
     * </p>
     * <p>
     * If true, <code>DataSourceSchema</code> is returned.
     * </p>
     * <p>
     * If false, <code>DataSourceSchema</code> is not returned.
     * </p>
     * 
     * @return Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>
     *         .</p>
     *         <p>
     *         If true, <code>DataSourceSchema</code> is returned.
     *         </p>
     *         <p>
     *         If false, <code>DataSourceSchema</code> is not returned.
     */
    public Boolean verbose() {
        return verbose;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(verbose());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSourceRequest)) {
            return false;
        }
        GetDataSourceRequest other = (GetDataSourceRequest) obj;
        return Objects.equals(dataSourceId(), other.dataSourceId()) && Objects.equals(verbose(), other.verbose());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDataSourceRequest").add("DataSourceId", dataSourceId()).add("Verbose", verbose()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "Verbose":
            return Optional.ofNullable(clazz.cast(verbose()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataSourceRequest, T> g) {
        return obj -> g.apply((GetDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDataSourceRequest> {
        /**
         * <p>
         * The ID assigned to the <code>DataSource</code> at creation.
         * </p>
         * 
         * @param dataSourceId
         *        The ID assigned to the <code>DataSource</code> at creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>.
         * </p>
         * <p>
         * If true, <code>DataSourceSchema</code> is returned.
         * </p>
         * <p>
         * If false, <code>DataSourceSchema</code> is not returned.
         * </p>
         * 
         * @param verbose
         *        Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>
         *        .</p>
         *        <p>
         *        If true, <code>DataSourceSchema</code> is returned.
         *        </p>
         *        <p>
         *        If false, <code>DataSourceSchema</code> is not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verbose(Boolean verbose);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String dataSourceId;

        private Boolean verbose;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSourceRequest model) {
            super(model);
            dataSourceId(model.dataSourceId);
            verbose(model.verbose);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final Boolean getVerbose() {
            return verbose;
        }

        @Override
        public final Builder verbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public final void setVerbose(Boolean verbose) {
            this.verbose = verbose;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDataSourceRequest build() {
            return new GetDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
