/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.machinelearning.model.Evaluation;
import software.amazon.awssdk.services.machinelearning.model.EvaluationsCopier;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEvaluationsResponse
extends MachineLearningResponse
implements ToCopyableBuilder<Builder, DescribeEvaluationsResponse> {
    private static final SdkField<List<Evaluation>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeEvaluationsResponse.getter(DescribeEvaluationsResponse::results)).setter(DescribeEvaluationsResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Evaluation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeEvaluationsResponse.getter(DescribeEvaluationsResponse::nextToken)).setter(DescribeEvaluationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Evaluation> results;
    private final String nextToken;

    private DescribeEvaluationsResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.nextToken = builder.nextToken;
    }

    public boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public List<Evaluation> results() {
        return this.results;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.results());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEvaluationsResponse)) {
            return false;
        }
        DescribeEvaluationsResponse other = (DescribeEvaluationsResponse)((Object)obj);
        return Objects.equals(this.results(), other.results()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEvaluationsResponse").add("Results", this.results()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEvaluationsResponse, T> g) {
        return obj -> g.apply((DescribeEvaluationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningResponse.BuilderImpl
    implements Builder {
        private List<Evaluation> results = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEvaluationsResponse model) {
            super(model);
            this.results(model.results);
            this.nextToken(model.nextToken);
        }

        public final Collection<Evaluation.Builder> getResults() {
            return this.results != null ? (Collection)this.results.stream().map(Evaluation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder results(Collection<Evaluation> results) {
            this.results = EvaluationsCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Evaluation ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<Evaluation.Builder> ... results) {
            this.results(Stream.of(results).map(c -> (Evaluation)((Evaluation.Builder)Evaluation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResults(Collection<Evaluation.BuilderImpl> results) {
            this.results = EvaluationsCopier.copyFromBuilder(results);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEvaluationsResponse build() {
            return new DescribeEvaluationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MachineLearningResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEvaluationsResponse> {
        public Builder results(Collection<Evaluation> var1);

        public Builder results(Evaluation ... var1);

        public Builder results(Consumer<Evaluation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

