/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.MLModel;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MLModelMarshaller {
    private static final MarshallingInfo<String> MLMODELID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelId").isBinary(false).build();
    private static final MarshallingInfo<String> TRAININGDATASOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingDataSourceId").isBinary(false).build();
    private static final MarshallingInfo<String> CREATEDBYIAMUSER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedByIamUser").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedAt").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<Long> SIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeInBytes").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENDPOINTINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointInfo").isBinary(false).build();
    private static final MarshallingInfo<Map> TRAININGPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingParameters").isBinary(false).build();
    private static final MarshallingInfo<String> INPUTDATALOCATIONS3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataLocationS3").isBinary(false).build();
    private static final MarshallingInfo<String> ALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Algorithm").isBinary(false).build();
    private static final MarshallingInfo<String> MLMODELTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelType").isBinary(false).build();
    private static final MarshallingInfo<Float> SCORETHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScoreThreshold").isBinary(false).build();
    private static final MarshallingInfo<Instant> SCORETHRESHOLDLASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScoreThresholdLastUpdatedAt").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();
    private static final MarshallingInfo<Long> COMPUTETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> FINISHEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FinishedAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedAt").isBinary(false).build();
    private static final MLModelMarshaller INSTANCE = new MLModelMarshaller();

    private MLModelMarshaller() {
    }

    public static MLModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MLModel mlModel, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)mlModel, (String)"mlModel");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)mlModel.mlModelId(), MLMODELID_BINDING);
            protocolMarshaller.marshall((Object)mlModel.trainingDataSourceId(), TRAININGDATASOURCEID_BINDING);
            protocolMarshaller.marshall((Object)mlModel.createdByIamUser(), CREATEDBYIAMUSER_BINDING);
            protocolMarshaller.marshall((Object)mlModel.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)mlModel.lastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)mlModel.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)mlModel.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)mlModel.sizeInBytes(), SIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)mlModel.endpointInfo(), ENDPOINTINFO_BINDING);
            protocolMarshaller.marshall(mlModel.trainingParameters(), TRAININGPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)mlModel.inputDataLocationS3(), INPUTDATALOCATIONS3_BINDING);
            protocolMarshaller.marshall((Object)mlModel.algorithmString(), ALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)mlModel.mlModelTypeString(), MLMODELTYPE_BINDING);
            protocolMarshaller.marshall((Object)mlModel.scoreThreshold(), SCORETHRESHOLD_BINDING);
            protocolMarshaller.marshall((Object)mlModel.scoreThresholdLastUpdatedAt(), SCORETHRESHOLDLASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)mlModel.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)mlModel.computeTime(), COMPUTETIME_BINDING);
            protocolMarshaller.marshall((Object)mlModel.finishedAt(), FINISHEDAT_BINDING);
            protocolMarshaller.marshall((Object)mlModel.startedAt(), STARTEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

