/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.machinelearning.MachineLearningClient;
import software.amazon.awssdk.services.machinelearning.model.DescribeMLModelsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeMLModelsResponse;
import software.amazon.awssdk.services.machinelearning.model.MLModel;

public class DescribeMLModelsIterable
implements SdkIterable<DescribeMLModelsResponse> {
    private final MachineLearningClient client;
    private final DescribeMLModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMLModelsIterable(MachineLearningClient client, DescribeMLModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeMLModelsResponseFetcher();
    }

    public Iterator<DescribeMLModelsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<MLModel> results() {
        Function<DescribeMLModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeMLModelsIterable resume(DescribeMLModelsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeMLModelsIterable(this.client, (DescribeMLModelsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeMLModelsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeMLModelsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeMLModelsResponseFetcher
    implements SyncPageFetcher<DescribeMLModelsResponse> {
        private DescribeMLModelsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMLModelsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeMLModelsResponse nextPage(DescribeMLModelsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMLModelsIterable.this.client.describeMLModels(DescribeMLModelsIterable.this.firstRequest);
            }
            return DescribeMLModelsIterable.this.client.describeMLModels((DescribeMLModelsRequest)((Object)DescribeMLModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

