/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.machinelearning.MachineLearningAsyncClient;
import software.amazon.awssdk.services.machinelearning.model.DataSource;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse;

public class DescribeDataSourcesPublisher
implements SdkPublisher<DescribeDataSourcesResponse> {
    private final MachineLearningAsyncClient client;
    private final DescribeDataSourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDataSourcesPublisher(MachineLearningAsyncClient client, DescribeDataSourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDataSourcesPublisher(MachineLearningAsyncClient client, DescribeDataSourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDataSourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDataSourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<DataSource> results() {
        Function<DescribeDataSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeDataSourcesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeDataSourcesPublisher resume(DescribeDataSourcesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDataSourcesPublisher(this.client, (DescribeDataSourcesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeDataSourcesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeDataSourcesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeDataSourcesResponseFetcher
    implements AsyncPageFetcher<DescribeDataSourcesResponse> {
        private DescribeDataSourcesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataSourcesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeDataSourcesResponse> nextPage(DescribeDataSourcesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataSourcesPublisher.this.client.describeDataSources(DescribeDataSourcesPublisher.this.firstRequest);
            }
            return DescribeDataSourcesPublisher.this.client.describeDataSources((DescribeDataSourcesRequest)((Object)DescribeDataSourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

