/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.DataSource;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DataSource} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DataSourceMarshaller {
    private static final MarshallingInfo<String> DATASOURCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSourceId").isBinary(false).build();

    private static final MarshallingInfo<String> DATALOCATIONS3_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataLocationS3").isBinary(false).build();

    private static final MarshallingInfo<String> DATAREARRANGEMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataRearrangement").isBinary(false).build();

    private static final MarshallingInfo<String> CREATEDBYIAMUSER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedByIamUser").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTUPDATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedAt").isBinary(false).build();

    private static final MarshallingInfo<Long> DATASIZEINBYTES_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSizeInBytes").isBinary(false).build();

    private static final MarshallingInfo<Long> NUMBEROFFILES_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfFiles").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> REDSHIFTMETADATA_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("RedshiftMetadata").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> RDSMETADATA_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RDSMetadata")
            .isBinary(false).build();

    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();

    private static final MarshallingInfo<Boolean> COMPUTESTATISTICS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeStatistics").isBinary(false).build();

    private static final MarshallingInfo<Long> COMPUTETIME_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> FINISHEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FinishedAt").isBinary(false).build();

    private static final MarshallingInfo<Instant> STARTEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedAt").isBinary(false).build();

    private static final DataSourceMarshaller INSTANCE = new DataSourceMarshaller();

    private DataSourceMarshaller() {
    }

    public static DataSourceMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DataSource dataSource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(dataSource, "dataSource");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(dataSource.dataSourceId(), DATASOURCEID_BINDING);
            protocolMarshaller.marshall(dataSource.dataLocationS3(), DATALOCATIONS3_BINDING);
            protocolMarshaller.marshall(dataSource.dataRearrangement(), DATAREARRANGEMENT_BINDING);
            protocolMarshaller.marshall(dataSource.createdByIamUser(), CREATEDBYIAMUSER_BINDING);
            protocolMarshaller.marshall(dataSource.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(dataSource.lastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall(dataSource.dataSizeInBytes(), DATASIZEINBYTES_BINDING);
            protocolMarshaller.marshall(dataSource.numberOfFiles(), NUMBEROFFILES_BINDING);
            protocolMarshaller.marshall(dataSource.name(), NAME_BINDING);
            protocolMarshaller.marshall(dataSource.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall(dataSource.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall(dataSource.redshiftMetadata(), REDSHIFTMETADATA_BINDING);
            protocolMarshaller.marshall(dataSource.rdsMetadata(), RDSMETADATA_BINDING);
            protocolMarshaller.marshall(dataSource.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall(dataSource.computeStatistics(), COMPUTESTATISTICS_BINDING);
            protocolMarshaller.marshall(dataSource.computeTime(), COMPUTETIME_BINDING);
            protocolMarshaller.marshall(dataSource.finishedAt(), FINISHEDAT_BINDING);
            protocolMarshaller.marshall(dataSource.startedAt(), STARTEDAT_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
