/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.RedshiftMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the <code>DataSource</code> details specific to Amazon Redshift.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RedshiftMetadata implements StructuredPojo, ToCopyableBuilder<RedshiftMetadata.Builder, RedshiftMetadata> {
    private final RedshiftDatabase redshiftDatabase;

    private final String databaseUserName;

    private final String selectSqlQuery;

    private RedshiftMetadata(BuilderImpl builder) {
        this.redshiftDatabase = builder.redshiftDatabase;
        this.databaseUserName = builder.databaseUserName;
        this.selectSqlQuery = builder.selectSqlQuery;
    }

    /**
     * Returns the value of the RedshiftDatabase property for this object.
     * 
     * @return The value of the RedshiftDatabase property for this object.
     */
    public RedshiftDatabase redshiftDatabase() {
        return redshiftDatabase;
    }

    /**
     * Returns the value of the DatabaseUserName property for this object.
     * 
     * @return The value of the DatabaseUserName property for this object.
     */
    public String databaseUserName() {
        return databaseUserName;
    }

    /**
     * <p>
     * The SQL query that is specified during <a>CreateDataSourceFromRedshift</a>. Returns only if <code>Verbose</code>
     * is true in GetDataSourceInput.
     * </p>
     * 
     * @return The SQL query that is specified during <a>CreateDataSourceFromRedshift</a>. Returns only if
     *         <code>Verbose</code> is true in GetDataSourceInput.
     */
    public String selectSqlQuery() {
        return selectSqlQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(redshiftDatabase());
        hashCode = 31 * hashCode + Objects.hashCode(databaseUserName());
        hashCode = 31 * hashCode + Objects.hashCode(selectSqlQuery());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftMetadata)) {
            return false;
        }
        RedshiftMetadata other = (RedshiftMetadata) obj;
        return Objects.equals(redshiftDatabase(), other.redshiftDatabase())
                && Objects.equals(databaseUserName(), other.databaseUserName())
                && Objects.equals(selectSqlQuery(), other.selectSqlQuery());
    }

    @Override
    public String toString() {
        return ToString.builder("RedshiftMetadata").add("RedshiftDatabase", redshiftDatabase())
                .add("DatabaseUserName", databaseUserName()).add("SelectSqlQuery", selectSqlQuery()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RedshiftDatabase":
            return Optional.of(clazz.cast(redshiftDatabase()));
        case "DatabaseUserName":
            return Optional.of(clazz.cast(databaseUserName()));
        case "SelectSqlQuery":
            return Optional.of(clazz.cast(selectSqlQuery()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RedshiftMetadata> {
        /**
         * Sets the value of the RedshiftDatabase property for this object.
         *
         * @param redshiftDatabase
         *        The new value for the RedshiftDatabase property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDatabase(RedshiftDatabase redshiftDatabase);

        /**
         * Sets the value of the RedshiftDatabase property for this object.
         *
         * This is a convenience that creates an instance of the {@link RedshiftDatabase.Builder} avoiding the need to
         * create one manually via {@link RedshiftDatabase#builder()}.
         *
         * When the {@link Consumer} completes, {@link RedshiftDatabase.Builder#build()} is called immediately and its
         * result is passed to {@link #redshiftDatabase(RedshiftDatabase)}.
         * 
         * @param redshiftDatabase
         *        a consumer that will call methods on {@link RedshiftDatabase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftDatabase(RedshiftDatabase)
         */
        default Builder redshiftDatabase(Consumer<RedshiftDatabase.Builder> redshiftDatabase) {
            return redshiftDatabase(RedshiftDatabase.builder().apply(redshiftDatabase).build());
        }

        /**
         * Sets the value of the DatabaseUserName property for this object.
         *
         * @param databaseUserName
         *        The new value for the DatabaseUserName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseUserName(String databaseUserName);

        /**
         * <p>
         * The SQL query that is specified during <a>CreateDataSourceFromRedshift</a>. Returns only if
         * <code>Verbose</code> is true in GetDataSourceInput.
         * </p>
         * 
         * @param selectSqlQuery
         *        The SQL query that is specified during <a>CreateDataSourceFromRedshift</a>. Returns only if
         *        <code>Verbose</code> is true in GetDataSourceInput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectSqlQuery(String selectSqlQuery);
    }

    static final class BuilderImpl implements Builder {
        private RedshiftDatabase redshiftDatabase;

        private String databaseUserName;

        private String selectSqlQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftMetadata model) {
            redshiftDatabase(model.redshiftDatabase);
            databaseUserName(model.databaseUserName);
            selectSqlQuery(model.selectSqlQuery);
        }

        public final RedshiftDatabase.Builder getRedshiftDatabase() {
            return redshiftDatabase != null ? redshiftDatabase.toBuilder() : null;
        }

        @Override
        public final Builder redshiftDatabase(RedshiftDatabase redshiftDatabase) {
            this.redshiftDatabase = redshiftDatabase;
            return this;
        }

        public final void setRedshiftDatabase(RedshiftDatabase.BuilderImpl redshiftDatabase) {
            this.redshiftDatabase = redshiftDatabase != null ? redshiftDatabase.build() : null;
        }

        public final String getDatabaseUserName() {
            return databaseUserName;
        }

        @Override
        public final Builder databaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
            return this;
        }

        public final void setDatabaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
        }

        public final String getSelectSqlQuery() {
            return selectSqlQuery;
        }

        @Override
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        @Override
        public RedshiftMetadata build() {
            return new RedshiftMetadata(this);
        }
    }
}
