/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon ML returns the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTagsResponse extends MachineLearningResponse implements
        ToCopyableBuilder<DescribeTagsResponse.Builder, DescribeTagsResponse> {
    private final String resourceId;

    private final String resourceType;

    private final List<Tag> tags;

    private DescribeTagsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the tagged ML object.
     * </p>
     * 
     * @return The ID of the tagged ML object.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of the tagged ML object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TaggableResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of the tagged ML object.
     * @see TaggableResourceType
     */
    public TaggableResourceType resourceType() {
        return TaggableResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the tagged ML object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TaggableResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of the tagged ML object.
     * @see TaggableResourceType
     */
    public String resourceTypeString() {
        return resourceType;
    }

    /**
     * <p>
     * A list of tags associated with the ML object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of tags associated with the ML object.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse) obj;
        return Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceTypeString(), other.resourceTypeString()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeTagsResponse").add("ResourceId", resourceId()).add("ResourceType", resourceTypeString())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.of(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningResponse.Builder, CopyableBuilder<Builder, DescribeTagsResponse> {
        /**
         * <p>
         * The ID of the tagged ML object.
         * </p>
         * 
         * @param resourceId
         *        The ID of the tagged ML object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of the tagged ML object.
         * </p>
         * 
         * @param resourceType
         *        The type of the tagged ML object.
         * @see TaggableResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaggableResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the tagged ML object.
         * </p>
         * 
         * @param resourceType
         *        The type of the tagged ML object.
         * @see TaggableResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaggableResourceType
         */
        Builder resourceType(TaggableResourceType resourceType);

        /**
         * <p>
         * A list of tags associated with the ML object.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with the ML object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags associated with the ML object.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with the ML object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private String resourceId;

        private String resourceType;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            tags(model.tags);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TaggableResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }
    }
}
